/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.client.renderer.MyRenderMethods;
import com.direwolf20.buildinggadgets.client.renderer.MyRenderType;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.view.SimpleBuildContext;
import com.direwolf20.buildinggadgets.common.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.RecordingItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.gadgets.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class BuildRender
extends BaseRenderer {
    private boolean isExchanger = false;
    private static final BlockState DEFAULT_EFFECT_BLOCK = OurBlocks.effectBlock.func_176223_P();

    public BuildRender(boolean isExchanger) {
        this.isExchanger = isExchanger;
    }

    @Override
    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        super.render(evt, player, heldItem);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, heldItem);
        Vec3d playerPos = BuildRender.getMc().field_71460_t.func_215316_n().func_216785_c();
        BlockState state = AIR;
        Optional<List<BlockPos>> anchor = GadgetUtils.getAnchor(heldItem);
        if (player.field_70170_p.func_175623_d(lookingAt.func_216350_a()) && !anchor.isPresent()) {
            return;
        }
        BlockState startBlock = player.field_70170_p.func_180495_p(lookingAt.func_216350_a());
        if (startBlock == DEFAULT_EFFECT_BLOCK) {
            return;
        }
        BlockData data = GadgetUtils.getToolBlock(heldItem);
        BlockState renderBlockState = data.getState();
        if (renderBlockState == BaseRenderer.AIR) {
            return;
        }
        List coordinates = anchor.orElseGet(() -> {
            AbstractMode mode = !this.isExchanger ? GadgetBuilding.getToolMode(heldItem).getMode() : GadgetExchanger.getToolMode(heldItem).getMode();
            return mode.getCollection(new AbstractMode.UseContext(player.field_70170_p, renderBlockState, lookingAt.func_216350_a(), heldItem, lookingAt.func_216354_b(), !this.isExchanger && GadgetBuilding.shouldPlaceAtop(heldItem)), player);
        });
        RecordingItemIndex index = new RecordingItemIndex(InventoryHelper.index(heldItem, player));
        MaterialList materials = data.getRequiredItems(new SimpleBuildContext((IWorld)player.field_70170_p, player, heldItem), null, null);
        int hasEnergy = this.getEnergy(player, heldItem);
        LazyOptional energyCap = heldItem.getCapability(CapabilityEnergy.ENERGY);
        BuildRender.getBuilderWorld().setWorldAndState(player.field_70170_p, renderBlockState, coordinates);
        IVertexBuilder builder = buffer.getBuffer(MyRenderType.RenderBlock);
        MatrixStack matrix = evt.getMatrixStack();
        matrix.func_227860_a_();
        matrix.func_227861_a_(-playerPos.func_82615_a(), -playerPos.func_82617_b(), -playerPos.func_82616_c());
        Random rand = new Random();
        BlockRendererDispatcher dispatcher = BuildRender.getMc().func_175602_ab();
        for (BlockPos coordinate : coordinates) {
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p());
            if (this.isExchanger) {
                matrix.func_227861_a_((double)-5.0E-4f, (double)-5.0E-4f, (double)-5.0E-4f);
                matrix.func_227862_a_(1.001f, 1.001f, 1.001f);
            }
            if (BuildRender.getBuilderWorld().getWorldType() != WorldType.field_180272_g) {
                try {
                    state = renderBlockState;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            IBakedModel ibakedmodel = dispatcher.func_184389_a(state);
            BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
            int color = blockColors.func_228054_a_(renderBlockState, (ILightReader)player.field_70170_p, coordinate, 0);
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            try {
                if (state.func_185901_i() == BlockRenderType.MODEL) {
                    for (Direction direction : Direction.values()) {
                        MyRenderMethods.renderModelBrightnessColorQuads(matrix.func_227866_c_(), builder, f, f1, f2, 0.7f, ibakedmodel.getQuads(state, direction, new Random(MathHelper.func_180186_a((Vec3i)coordinate)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
                    }
                    MyRenderMethods.renderModelBrightnessColorQuads(matrix.func_227866_c_(), builder, f, f1, f2, 0.7f, ibakedmodel.getQuads(state, null, new Random(MathHelper.func_180186_a((Vec3i)coordinate)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
                }
            }
            catch (Throwable t) {
                BuildingGadgets.LOG.trace("Block at {} with state {} threw exception, whilst rendering", (Object)coordinate, (Object)state, (Object)t);
            }
            matrix.func_227865_b_();
        }
        for (BlockPos coordinate : coordinates) {
            MatchResult match;
            if (energyCap.isPresent()) {
                hasEnergy -= ((AbstractGadget)heldItem.func_77973_b()).getEnergyCost(heldItem);
            }
            if (!(match = index.tryMatch(materials)).isSuccess()) {
                match = index.tryMatch(InventoryHelper.PASTE_LIST);
            }
            if (!match.isSuccess() || hasEnergy < 0) {
                builder = buffer.getBuffer(MyRenderType.MissingBlockOverlay);
                this.renderMissingBlock(matrix.func_227866_c_().func_227870_a_(), builder, coordinate);
                continue;
            }
            index.applyMatch(match);
        }
        matrix.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228461_a_();
    }

    @Override
    public boolean isLinkable() {
        return true;
    }
}

