/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.client.screen.GuiMod;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.items.gadgets.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.BaseRenderer;
import com.direwolf20.buildinggadgets.common.items.gadgets.renderers.DestructionRender;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.save.Undo;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.helpers.VectorHelper;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import com.direwolf20.buildinggadgets.common.util.ref.Reference;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class GadgetDestruction
extends AbstractGadget {
    public GadgetDestruction(Item.Properties builder, IntSupplier undoLengthSupplier, String undoName) {
        super(builder, undoLengthSupplier, undoName, Reference.BlockReference.TagReference.WHITELIST_DESTRUCTION, Reference.BlockReference.TagReference.BLACKLIST_DESTRUCTION);
    }

    @Override
    public int getEnergyMax() {
        return (Integer)Config.GADGETS.GADGET_DESTRUCTION.maxEnergy.get();
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return (Integer)Config.GADGETS.GADGET_DESTRUCTION.energyCost.get() * this.getCostMultiplier(tool);
    }

    @Override
    protected Supplier<BaseRenderer> createRenderFactory() {
        return DestructionRender::new;
    }

    private int getCostMultiplier(ItemStack tool) {
        return (int)(!GadgetDestruction.getFuzzy(tool) ? (Double)Config.GADGETS.GADGET_DESTRUCTION.nonFuzzyMultiplier.get() : 1.0);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        this.addEnergyInformation(tooltip, stack);
        tooltip.add(TooltipTranslation.GADGET_DESTROYWARNING.componentTranslation(new Object[0]).func_150255_a(Styles.RED));
        tooltip.add(TooltipTranslation.GADGET_DESTROYSHOWOVERLAY.componentTranslation(String.valueOf(GadgetDestruction.getOverlay(stack))).func_150255_a(Styles.AQUA));
        tooltip.add(TooltipTranslation.GADGET_BUILDING_PLACE_ATOP.componentTranslation(String.valueOf(GadgetDestruction.getConnectedArea(stack))).func_150255_a(Styles.YELLOW));
        if (((Boolean)Config.GADGETS.GADGET_DESTRUCTION.nonFuzzyEnabled.get()).booleanValue()) {
            tooltip.add(TooltipTranslation.GADGET_FUZZY.componentTranslation(String.valueOf(GadgetDestruction.getFuzzy(stack))).func_150255_a(Styles.GOLD));
        }
        GadgetDestruction.addInformationRayTraceFluid(tooltip, stack);
    }

    public static void setAnchor(ItemStack stack, BlockPos pos) {
        GadgetUtils.writePOSToNBT(stack, pos, "anchor");
    }

    public static void setAnchorSide(ItemStack stack, Direction side) {
        CompoundNBT tag = stack.func_196082_o();
        if (side == null) {
            tag.func_82580_o("anchor_side");
        } else {
            tag.func_74778_a("anchor_side", side.func_176610_l());
        }
    }

    public static Direction getAnchorSide(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        String facing = tag.func_74779_i("anchor_side");
        if (facing.isEmpty()) {
            return null;
        }
        return Direction.func_176739_a((String)facing);
    }

    public static void setToolValue(ItemStack stack, int value, String valueName) {
        stack.func_196082_o().func_74768_a(valueName, value);
    }

    public static int getToolValue(ItemStack stack, String valueName) {
        return stack.func_196082_o().func_74762_e(valueName);
    }

    public static boolean getOverlay(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("overlay")) {
            return tag.func_74767_n("overlay");
        }
        tag.func_74757_a("overlay", true);
        tag.func_74757_a("fuzzy", true);
        return true;
    }

    public static void setOverlay(ItemStack stack, boolean showOverlay) {
        stack.func_196082_o().func_74757_a("overlay", showOverlay);
    }

    public static void switchOverlay(PlayerEntity player, ItemStack stack) {
        boolean newOverlay = !GadgetDestruction.getOverlay(stack);
        GadgetDestruction.setOverlay(stack, newOverlay);
        player.func_146105_b(TooltipTranslation.GADGET_DESTROYSHOWOVERLAY.componentTranslation(newOverlay).func_150255_a(Styles.AQUA), true);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (!player.func_225608_bj_()) {
                BlockPos anchorPos = this.getAnchor(stack);
                Direction anchorSide = GadgetDestruction.getAnchorSide(stack);
                if (anchorPos != null && anchorSide != null) {
                    this.clearArea(world, anchorPos, anchorSide, (ServerPlayerEntity)player, stack);
                    this.onAnchorRemoved(stack, player);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                }
                BlockRayTraceResult lookingAt = VectorHelper.getLookingAt(player, stack);
                if (!world.func_175623_d(lookingAt.func_216350_a())) {
                    this.clearArea(world, lookingAt.func_216350_a(), lookingAt.func_216354_b(), (ServerPlayerEntity)player, stack);
                    this.onAnchorRemoved(stack, player);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                }
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
        } else if (player.func_225608_bj_()) {
            GuiMod.DESTRUCTION.openScreen(player);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    protected void onAnchorSet(ItemStack stack, PlayerEntity player, BlockRayTraceResult lookingAt) {
        super.onAnchorSet(stack, player, lookingAt);
        GadgetDestruction.setAnchorSide(stack, lookingAt.func_216354_b());
    }

    @Override
    protected void onAnchorRemoved(ItemStack stack, PlayerEntity player) {
        super.onAnchorRemoved(stack, player);
        GadgetDestruction.setAnchorSide(stack, null);
    }

    public static List<BlockPos> getClearingPositions(World world, BlockPos pos, Direction incomingSide, PlayerEntity player, ItemStack stack) {
        ItemStack tool = GadgetDestruction.getGadget(player);
        int depth = GadgetDestruction.getToolValue(stack, "depth");
        if (tool.func_190926_b() || depth == 0 || !player.func_175142_cm()) {
            return new ArrayList<BlockPos>();
        }
        boolean vertical = incomingSide.func_176740_k().func_200128_b();
        Direction up = vertical ? player.func_174811_aO() : Direction.UP;
        Direction down = up.func_176734_d();
        Direction right = vertical ? up.func_176746_e() : incomingSide.func_176735_f();
        Direction left = right.func_176734_d();
        BlockPos first = pos.func_177967_a(left, GadgetDestruction.getToolValue(stack, "left")).func_177967_a(up, GadgetDestruction.getToolValue(stack, "up"));
        BlockPos second = pos.func_177967_a(right, GadgetDestruction.getToolValue(stack, "right")).func_177967_a(down, GadgetDestruction.getToolValue(stack, "down")).func_177967_a(incomingSide.func_176734_d(), depth - 1);
        return new Region((Vec3i)first, (Vec3i)second).stream().filter(e -> GadgetDestruction.isValidBlock(world, e, player, world.func_180495_p(e))).sorted(Comparator.comparing(arg_0 -> ((BlockPos)player.func_180425_c()).func_177951_i(arg_0))).collect(Collectors.toList());
    }

    public static boolean isValidBlock(World world, BlockPos voidPos, PlayerEntity player, BlockState currentBlock) {
        if (world.func_175623_d(voidPos) || currentBlock.equals(OurBlocks.effectBlock.func_176223_P()) || currentBlock.func_185887_b((IBlockReader)world, voidPos) < 0.0f || !world.func_175660_a(player, voidPos)) {
            return false;
        }
        TileEntity te = world.func_175625_s(voidPos);
        if (te != null && !(te instanceof ConstructionBlockTileEntity)) {
            return false;
        }
        if (!world.field_72995_K) {
            BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)voidPos);
            if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
                return false;
            }
            BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(world, voidPos, currentBlock, player);
            return !MinecraftForge.EVENT_BUS.post((Event)e);
        }
        return true;
    }

    public void clearArea(World world, BlockPos pos, Direction side, ServerPlayerEntity player, ItemStack stack) {
        List<BlockPos> positions = GadgetDestruction.getClearingPositions(world, pos, side, (PlayerEntity)player, stack);
        Undo.Builder builder = Undo.builder();
        for (BlockPos clearPos : positions) {
            BlockState state = world.func_180495_p(clearPos);
            TileEntity te = world.func_175625_s(clearPos);
            if (!this.isAllowedBlock(state.func_177230_c()) || te != null && (state.func_177230_c() != OurBlocks.constructionBlock || !(te instanceof ConstructionBlockTileEntity))) continue;
            this.destroyBlock(world, clearPos, player, builder);
        }
        this.pushUndo(stack, builder.build(world.func_201675_m().func_186058_p()));
    }

    private boolean destroyBlock(World world, BlockPos voidPos, ServerPlayerEntity player, Undo.Builder builder) {
        if (world.func_175623_d(voidPos)) {
            return false;
        }
        ItemStack tool = GadgetDestruction.getGadget((PlayerEntity)player);
        if (tool.func_190926_b()) {
            return false;
        }
        if (!this.canUse(tool, (PlayerEntity)player)) {
            return false;
        }
        this.applyDamage(tool, player);
        builder.record((IBlockReader)world, voidPos, BlockData.AIR, (Multiset<IUniqueObject<?>>)ImmutableMultiset.of(), (Multiset<IUniqueObject<?>>)ImmutableMultiset.of());
        EffectBlock.spawnEffectBlock((IWorld)world, voidPos, TileSupport.createBlockData((IBlockReader)world, voidPos), EffectBlock.Mode.REMOVE, false);
        return true;
    }

    public static ItemStack getGadget(PlayerEntity player) {
        ItemStack stack = AbstractGadget.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetDestruction)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }
}

