/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.inventory;

import com.direwolf20.buildinggadgets.common.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.inventory.materials.objects.IUniqueObject;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;

public final class RecordingItemIndex
implements IItemIndex {
    private final IItemIndex other;
    private Multiset<IUniqueObject<?>> extractedItems;
    private Multiset<IUniqueObject<?>> insertedItems;

    public RecordingItemIndex(IItemIndex other) {
        this.other = other;
        this.extractedItems = HashMultiset.create();
        this.insertedItems = HashMultiset.create();
    }

    @Override
    public Multiset<IUniqueObject<?>> insert(Multiset<IUniqueObject<?>> items, boolean simulate) {
        Multiset<IUniqueObject<?>> res = this.other.insert(items, simulate);
        if (!simulate) {
            this.insertedItems.addAll(items);
        }
        return res;
    }

    @Override
    public void reIndex() {
        this.other.reIndex();
        this.insertedItems.clear();
        this.extractedItems.clear();
    }

    @Override
    public MatchResult tryMatch(MaterialList list) {
        return this.other.tryMatch(MaterialList.and(list, MaterialList.of(this.extractedItems)));
    }

    @Override
    public MatchResult tryMatch(Multiset<IUniqueObject<?>> items) {
        return this.other.tryMatch((Multiset<IUniqueObject<?>>)ImmutableMultiset.builder().addAll(items).addAll(this.extractedItems).build());
    }

    @Override
    public boolean applyMatch(MatchResult result) {
        if (result.isSuccess()) {
            this.extractedItems.addAll((Collection)Multisets.difference(result.getChosenOption(), this.extractedItems));
            return true;
        }
        return false;
    }
}

