/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.concurrent;

import com.direwolf20.buildinggadgets.common.building.BlockData;
import com.direwolf20.buildinggadgets.common.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.view.IBuildContext;
import com.direwolf20.buildinggadgets.common.building.view.IBuildView;
import com.direwolf20.buildinggadgets.common.concurrent.ServerTickingScheduler;
import com.direwolf20.buildinggadgets.common.concurrent.SteppedScheduler;
import com.direwolf20.buildinggadgets.common.registry.OurItems;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;

public final class CopyScheduler
extends SteppedScheduler {
    private final BiConsumer<ImmutableMap<BlockPos, BlockData>, Region> finisher;
    private final Spliterator<PlacementTarget> targets;
    private final ImmutableMap.Builder<BlockPos, BlockData> builder;
    private Region.Builder regionBuilder;
    private final IBuildContext context;

    public static void scheduleCopy(BiConsumer<ImmutableMap<BlockPos, BlockData>, Region> finisher, IBuildView worldView, int steps) {
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
        ServerTickingScheduler.runTicked(new CopyScheduler(Objects.requireNonNull(finisher), Objects.requireNonNull(worldView), steps));
    }

    private CopyScheduler(BiConsumer<ImmutableMap<BlockPos, BlockData>, Region> finisher, IBuildView worldView, int steps) {
        super(steps);
        this.finisher = finisher;
        this.targets = worldView.spliterator();
        this.builder = ImmutableMap.builder();
        this.context = worldView.getContext();
        this.regionBuilder = null;
    }

    @Override
    protected SteppedScheduler.StepResult advance() {
        return SteppedScheduler.StepResult.ofBoolean(this.targets.tryAdvance(t -> {
            if (!t.getData().getState().isAir((IBlockReader)this.context.getWorld(), t.getPos()) && OurItems.gadgetCopyPaste.isAllowedBlock(t.getData().getState().func_177230_c())) {
                this.builder.put((Object)t.getPos(), (Object)t.getData());
                if (this.regionBuilder == null) {
                    this.regionBuilder = Region.enclosingBuilder();
                }
                this.regionBuilder.enclose((Vec3i)t.getPos());
            }
        }));
    }

    @Override
    protected void onFinish() {
        this.finisher.accept((ImmutableMap<BlockPos, BlockData>)this.builder.build(), this.regionBuilder != null ? this.regionBuilder.build() : Region.singleZero());
    }
}

