/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.worldgen.DefaultDimensionInfo;
import mcjty.lostcities.worldgen.IDimensionInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LostCityFeature
extends Feature<NoFeatureConfig> {
    private Map<DimensionType, IDimensionInfo> dimensionInfo = new HashMap<DimensionType, IDimensionInfo>();

    public LostCityFeature() {
        super(NoFeatureConfig::func_214639_a);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        IDimensionInfo diminfo;
        if (world instanceof WorldGenRegion && (diminfo = this.getDimensionInfo(world)) != null) {
            WorldGenRegion region = (WorldGenRegion)world;
            int chunkX = region.func_201679_a();
            int chunkZ = region.func_201680_b();
            diminfo.setWorld(world);
            diminfo.getFeature().generate(region, region.func_212866_a_(chunkX, chunkZ));
            return true;
        }
        return false;
    }

    @Nullable
    public IDimensionInfo getDimensionInfo(IWorld world) {
        DimensionType type = world.func_201675_m().func_186058_p();
        String profileName = Config.getProfileForDimension(type);
        if (profileName != null) {
            if (!this.dimensionInfo.containsKey(type)) {
                LostCityProfile profile = LostCityConfiguration.standardProfiles.get(profileName);
                DefaultDimensionInfo diminfo = new DefaultDimensionInfo(world, profile);
                this.dimensionInfo.put(type, diminfo);
            }
            return this.dimensionInfo.get(type);
        }
        return null;
    }
}

