/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import mcjty.lostcities.config.LandscapeType;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import net.minecraft.block.BlockState;

public class ChunkHeightmap {
    private final byte[] heightmap = new byte[256];
    private final LandscapeType type;
    private final int groundLevel;
    private final BlockState baseState;
    private Integer maxHeight = null;
    private Integer minHeight = null;
    private Integer avgHeight = null;

    public ChunkHeightmap(LandscapeType type, int groundLevel, BlockState baseState) {
        this.groundLevel = groundLevel;
        this.type = type;
        this.baseState = baseState;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.heightmap[z * 16 + x] = 0;
            }
        }
    }

    public void update(int x, int y, int z, BlockState state) {
        BlockState air = LostCityTerrainFeature.air;
        if (state == air) {
            return;
        }
        int current = this.heightmap[z * 16 + x] & 0xFF;
        if (y <= current) {
            return;
        }
        if (this.type == LandscapeType.CAVERN) {
            int base = Math.max(this.groundLevel - 20, 1);
            if (y > 100 || y < base) {
                return;
            }
            if (y == 100) {
                this.heightmap[z * 16 + x] = 127;
                return;
            }
            this.heightmap[z * 16 + x] = (byte)y;
        } else if (this.type == LandscapeType.SPACE) {
            if (state != this.baseState) {
                return;
            }
            this.heightmap[z * 16 + x] = (byte)y;
        } else {
            this.heightmap[z * 16 + x] = (byte)y;
        }
    }

    public int getHeight(int x, int z) {
        return this.heightmap[z * 16 + x] & 0xFF;
    }

    private void calculateHeightInfo() {
        int max = 0;
        int min = 256;
        int avg = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int h = this.getHeight(x, z);
                if (h > max) {
                    max = h;
                }
                if (h < min) {
                    min = h;
                }
                avg += h;
            }
        }
        this.avgHeight = avg / 256;
        this.minHeight = min;
        this.maxHeight = max;
    }

    public int getAverageHeight() {
        if (this.avgHeight == null) {
            this.calculateHeightInfo();
        }
        return this.avgHeight;
    }

    public int getMinimumHeight() {
        if (this.minHeight == null) {
            this.calculateHeightInfo();
        }
        return this.minHeight;
    }

    public int getMaximumHeight() {
        if (this.maxHeight == null) {
            this.calculateHeightInfo();
        }
        return this.maxHeight;
    }
}

