/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.varia;

import mcjty.lostcities.worldgen.lost.Orientation;
import net.minecraft.world.dimension.DimensionType;

public class ChunkCoord {
    private final DimensionType dimension;
    private final int chunkX;
    private final int chunkZ;

    public ChunkCoord(DimensionType dimension, int chunkX, int chunkZ) {
        this.dimension = dimension;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public DimensionType getDimension() {
        return this.dimension;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public ChunkCoord lower(Orientation o) {
        switch (o) {
            case X: {
                return new ChunkCoord(this.dimension, this.chunkX - 1, this.chunkZ);
            }
            case Z: {
                return new ChunkCoord(this.dimension, this.chunkX, this.chunkZ - 1);
            }
        }
        throw new IllegalArgumentException("Cannot happen!");
    }

    public ChunkCoord higher(Orientation o) {
        switch (o) {
            case X: {
                return new ChunkCoord(this.dimension, this.chunkX + 1, this.chunkZ);
            }
            case Z: {
                return new ChunkCoord(this.dimension, this.chunkX, this.chunkZ + 1);
            }
        }
        throw new IllegalArgumentException("Cannot happen!");
    }

    public int getCoord(Orientation o) {
        switch (o) {
            case X: {
                return this.chunkX;
            }
            case Z: {
                return this.chunkZ;
            }
        }
        throw new IllegalArgumentException("Cannot happen!");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkCoord that = (ChunkCoord)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        if (this.chunkX != that.chunkX) {
            return false;
        }
        return this.chunkZ == that.chunkZ;
    }

    public int hashCode() {
        int result = this.dimension.func_186068_a();
        result = 31 * result + this.chunkX;
        result = 31 * result + this.chunkZ;
        return result;
    }

    public String toString() {
        return "ChunkCoord{dimension=" + this.dimension + ", chunkX=" + this.chunkX + ", chunkZ=" + this.chunkZ + '}';
    }
}

