/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.setup;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.ConfigSetup;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.network.PacketHandler;
import mcjty.lostcities.setup.ForgeEventHandlers;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldtypes.CavernWorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModSetup {
    public static boolean chisel = false;
    public static boolean biomesoplenty = false;
    public static boolean atg = false;
    public static Logger logger = null;

    public static Logger getLogger() {
        return logger;
    }

    public void init(FMLCommonSetupEvent e) {
        logger = LogManager.getLogger();
        LostCityConfiguration.setupProfiles();
        PacketHandler.registerMessages("lostcities");
        CavernWorldType.init();
        this.setupModCompat();
        ConfigSetup.init();
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        ConfigSetup.postInit();
        ConfigSetup.profileConfigs.clear();
        AssetRegistries.reset();
        for (String path : LostCityConfiguration.ASSETS) {
            if (path.startsWith("/")) {
                try (InputStream inputstream = LostCities.class.getResourceAsStream(path);){
                    AssetRegistries.load(inputstream, path);
                    continue;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            throw new RuntimeException("Invalid path for lostcity resource in 'assets' config!");
        }
        if (LostCityConfiguration.DEBUG) {
            AssetRegistries.showStatistics();
        }
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.VOID)) continue;
            biome.func_203611_a(GenerationStage.Decoration.RAW_GENERATION, Registration.LOSTCITY_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 0, 0, 1))));
        }
    }

    private void setupModCompat() {
        chisel = ModList.get().isLoaded("chisel");
        biomesoplenty = ModList.get().isLoaded("biomesoplenty");
    }
}

