/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.extrabuttons.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DelayButtonBlock
extends HorizontalFaceBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final EnumProperty<State> STATE = EnumProperty.func_177709_a((String)"state", State.class);
    public static final EnumProperty<State> PROGRAMMED = EnumProperty.func_177709_a((String)"programmed", State.class);
    protected static final VoxelShape AABB_NORTH = Block.func_208617_a((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape AABB_SOUTH = Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0);
    protected static final VoxelShape AABB_WEST = Block.func_208617_a((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    protected static final VoxelShape AABB_EAST = Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0);
    protected static final VoxelShape AABB_UP = Block.func_208617_a((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape AABB_DOWN = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0);

    public DelayButtonBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_196366_M, (Comparable)AttachFace.WALL)).func_206870_a(STATE, (Comparable)((Object)State.S0))).func_206870_a(PROGRAMMED, (Comparable)((Object)State.S0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
        switch ((AttachFace)state.func_177229_b((IProperty)field_196366_M)) {
            case FLOOR: {
                return AABB_DOWN;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return AABB_EAST;
                    }
                    case WEST: {
                        return AABB_WEST;
                    }
                    case SOUTH: {
                        return AABB_SOUTH;
                    }
                }
                return AABB_NORTH;
            }
        }
        return AABB_UP;
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 20;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return ActionResultType.CONSUME;
        }
        if (player.func_225608_bj_()) {
            State next = ((State)((Object)state.func_177229_b(PROGRAMMED))).cycle();
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a(STATE, (Comparable)((Object)next))).func_206870_a(PROGRAMMED, (Comparable)((Object)next)), 3);
        } else {
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true))).func_206870_a(STATE, state.func_177229_b(PROGRAMMED)), 3);
            this.playSound(player, (IWorld)worldIn, pos, true);
        }
        this.updateNeighbors(state, worldIn, pos);
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
        return ActionResultType.SUCCESS;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K) {
            if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(STATE, (Comparable)((Object)State.S0)), 3);
                return;
            }
            State remaining = (State)((Object)state.func_177229_b(STATE));
            if (remaining != State.S0) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(STATE, (Comparable)((Object)remaining.reduce())), 3);
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
            } else {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                this.updateNeighbors(state, (World)worldIn, pos);
                this.playSound(null, (IWorld)worldIn, pos, false);
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                this.updateNeighbors(state, worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private void playSound(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos, boolean buttonOn) {
        worldIn.func_184133_a((PlayerEntity)(buttonOn ? player : null), pos, this.getSoundEvent(buttonOn), SoundCategory.BLOCKS, 0.3f, buttonOn ? 0.6f : 0.5f);
    }

    private SoundEvent getSoundEvent(boolean buttonOn) {
        return buttonOn ? SoundEvents.field_187839_fV : SoundEvents.field_187837_fU;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false && DelayButtonBlock.func_196365_i((BlockState)blockState) == side ? 15 : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, POWERED, field_196366_M, STATE, PROGRAMMED});
    }

    private void updateNeighbors(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_195593_d(pos, (Block)this);
        worldIn.func_195593_d(pos.func_177972_a(DelayButtonBlock.func_196365_i((BlockState)state).func_176734_d()), (Block)this);
    }

    public static enum State implements IStringSerializable
    {
        S0("s0"),
        S1("s1"),
        S2("s2"),
        S3("s3");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public State cycle() {
            switch (this) {
                case S0: {
                    return S1;
                }
                case S1: {
                    return S2;
                }
                case S2: {
                    return S3;
                }
                case S3: {
                    return S0;
                }
            }
            return S0;
        }

        public State reduce() {
            switch (this) {
                case S3: {
                    return S2;
                }
                case S2: {
                    return S1;
                }
            }
            return S0;
        }
    }
}

