/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.container.RootFilterContainer;
import net.blay09.mods.refinedrelocation.filter.SubFilterWrapper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RootFilter
implements IRootFilter {
    private final List<SubFilterWrapper> filterList = Lists.newArrayList();

    @Override
    public int getFilterCount() {
        return this.filterList.size();
    }

    @Override
    @Nullable
    public IFilter getFilter(int index) {
        if (index < 0 || index >= this.filterList.size()) {
            return null;
        }
        return this.filterList.get(index).getFilter();
    }

    @Override
    public boolean isBlacklist(int index) {
        return index >= 0 && index < this.filterList.size() && this.filterList.get(index).isBlacklist();
    }

    @Override
    public void setIsBlacklist(int index, boolean isBlacklist) {
        if (index < 0 || index >= this.filterList.size()) {
            return;
        }
        this.filterList.get(index).setBlacklist(isBlacklist);
    }

    @Override
    public void addFilter(IFilter filter) {
        this.filterList.add(new SubFilterWrapper(filter));
    }

    @Override
    public void removeFilter(int index) {
        this.filterList.remove(index);
    }

    @Override
    public boolean passes(TileEntity tileEntity, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        boolean passes = false;
        for (SubFilterWrapper filter : this.filterList) {
            boolean filterPasses = filter.getFilter().passes(tileEntity, itemStack);
            if (filterPasses && filter.isBlacklist()) {
                return false;
            }
            passes = passes || filterPasses;
        }
        return passes;
    }

    public INBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        ListNBT filterList = new ListNBT();
        for (SubFilterWrapper filter : this.filterList) {
            CompoundNBT tagCompound = new CompoundNBT();
            filter.writeNBT(tagCompound);
            filterList.add((Object)tagCompound);
        }
        compound.func_218657_a("FilterList", (INBT)filterList);
        return compound;
    }

    public void deserializeNBT(INBT nbt) {
        this.filterList.clear();
        CompoundNBT compound = (CompoundNBT)nbt;
        ListNBT filterList = compound.func_150295_c("FilterList", 10);
        for (int i = 0; i < filterList.size(); ++i) {
            CompoundNBT tagCompound = filterList.func_150305_b(i);
            SubFilterWrapper filter = SubFilterWrapper.loadFromNBT(tagCompound);
            if (filter == null) continue;
            this.filterList.add(filter);
        }
    }

    @Override
    @Nullable
    public INamedContainerProvider getConfiguration(PlayerEntity player, final TileEntity tileEntity, final int rootFilterIndex) {
        return new INamedContainerProvider(){

            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new RootFilterContainer(i, playerInventory, tileEntity, rootFilterIndex);
            }

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("refinedrelocation:root_filter", new Object[0]);
            }
        };
    }
}

