/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.blay09.mods.refinedrelocation.api.container.IContainerReturnable;
import net.blay09.mods.refinedrelocation.api.container.ReturnCallback;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.container.FilterContainer;
import net.blay09.mods.refinedrelocation.container.ModContainers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ChecklistFilterContainer
extends FilterContainer
implements IContainerReturnable {
    public static final String KEY_CHECK = "Check";
    public static final String KEY_UNCHECK = "Uncheck";
    public static final String KEY_STATES = "States";
    private static final int UPDATE_INTERVAL = 20;
    private final PlayerEntity player;
    private final TileEntity tileEntity;
    private final int rootFilterIndex;
    private final IChecklistFilter filter;
    private final byte[] lastStates;
    private int ticksSinceUpdate = 20;
    private ReturnCallback returnCallback;

    public ChecklistFilterContainer(int windowId, PlayerInventory playerInventory, TileEntity tileEntity, int rootFilterIndex, IChecklistFilter filter) {
        super(ModContainers.checklistFilter, windowId);
        this.player = playerInventory.field_70458_d;
        this.tileEntity = tileEntity;
        this.rootFilterIndex = rootFilterIndex;
        this.filter = filter;
        this.lastStates = new byte[filter.getOptionCount()];
        this.addPlayerInventory(playerInventory, 8, 128);
    }

    public IChecklistFilter getFilter() {
        return this.filter;
    }

    public void func_75142_b() {
        super.func_75142_b();
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate >= 20) {
            boolean anyChanges = false;
            for (int i = 0; i < this.lastStates.length; ++i) {
                byte isChecked = (byte)(this.filter.isOptionChecked(i) ? 1 : 0);
                if (this.lastStates[i] == isChecked) continue;
                anyChanges = true;
                this.lastStates[i] = isChecked;
            }
            if (anyChanges) {
                RefinedRelocationAPI.syncContainerValue(KEY_STATES, this.lastStates, (Iterable<IContainerListener>)this.field_75149_d);
                RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.filter);
            }
            this.ticksSinceUpdate = 0;
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        ItemStack itemStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        RefinedRelocationAPI.updateFilterPreview(player, this.tileEntity, this.filter);
        return itemStack;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (index < 27 ? !this.func_75135_a(slotStack, 27, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public void receivedMessageServer(IContainerMessage message) {
        if (message.getKey().equals(KEY_CHECK)) {
            int index = message.getIntValue();
            if (index < 0 || index >= this.lastStates.length) {
                return;
            }
            this.filter.setOptionChecked(index, true);
            this.tileEntity.func_70296_d();
            this.lastStates[index] = 1;
            RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.filter);
        } else if (message.getKey().equals(KEY_UNCHECK)) {
            int index = message.getIntValue();
            if (index < 0 || index >= this.lastStates.length) {
                return;
            }
            this.filter.setOptionChecked(index, false);
            this.tileEntity.func_70296_d();
            this.lastStates[index] = 0;
            RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.filter);
        }
    }

    @Override
    public void receivedMessageClient(IContainerMessage message) {
        if (message.getKey().equals(KEY_STATES)) {
            byte[] states = message.getByteArrayValue();
            for (int i = 0; i < states.length; ++i) {
                this.filter.setOptionChecked(i, states[i] == 1);
            }
        }
    }

    @Override
    public void setReturnCallback(@Nullable ReturnCallback callback) {
        this.returnCallback = callback;
    }

    @Override
    @Nullable
    public ReturnCallback getReturnCallback() {
        return this.returnCallback;
    }

    @Override
    public int getRootFilterIndex() {
        return this.rootFilterIndex;
    }
}

