/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import net.blay09.mods.refinedrelocation.RefinedRelocationUtils;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.container.BaseContainer;
import net.blay09.mods.refinedrelocation.container.IRootFilterContainer;
import net.blay09.mods.refinedrelocation.container.ModContainers;
import net.blay09.mods.refinedrelocation.filter.FilterRegistry;
import net.blay09.mods.refinedrelocation.filter.RootFilter;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.network.NetworkHooks;

public class AddFilterContainer
extends BaseContainer
implements IRootFilterContainer {
    public static final String KEY_ADD_FILTER = "AddFilter";
    public static final String KEY_ROOT_FILTER = "RootFilter";
    private final TileEntity tileEntity;
    private final PlayerEntity player;
    private final IRootFilter rootFilter;
    private final int rootFilterIndex;

    public AddFilterContainer(int windowId, PlayerInventory playerInventory, TileEntity tileEntity, int rootFilterIndex) {
        super(ModContainers.addFilter, windowId);
        this.tileEntity = tileEntity;
        this.player = playerInventory.field_70458_d;
        this.addPlayerInventory(playerInventory, 8, 128);
        this.rootFilterIndex = rootFilterIndex;
        this.rootFilter = (IRootFilter)RefinedRelocationUtils.getRootFilter(tileEntity, rootFilterIndex).orElseGet(RootFilter::new);
    }

    @Override
    public void receivedMessageServer(IContainerMessage message) {
        switch (message.getKey()) {
            case "AddFilter": {
                String typeId = message.getStringValue();
                IFilter filter = FilterRegistry.createFilter(typeId);
                if (filter == null) {
                    return;
                }
                if (this.rootFilter.getFilterCount() >= 3) {
                    return;
                }
                this.rootFilter.addFilter(filter);
                this.tileEntity.func_70296_d();
                this.syncFilterList();
                RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.rootFilter);
                INamedContainerProvider filterConfig = filter.getConfiguration(this.player, this.tileEntity, this.rootFilterIndex);
                if (filterConfig == null) break;
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)this.player), (INamedContainerProvider)filterConfig, it -> {
                    it.func_179255_a(this.tileEntity.func_174877_v());
                    it.writeByte(this.rootFilterIndex);
                    it.writeByte(this.rootFilter.getFilterCount() - 1);
                });
                break;
            }
        }
    }

    private void syncFilterList() {
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_218657_a(KEY_ROOT_FILTER, this.rootFilter.serializeNBT());
        RefinedRelocationAPI.syncContainerValue(KEY_ROOT_FILTER, tagCompound, (Iterable<IContainerListener>)this.field_75149_d);
    }

    @Override
    public void receivedMessageClient(IContainerMessage message) {
        switch (message.getKey()) {
            case "RootFilter": {
                this.rootFilter.deserializeNBT((INBT)message.getNBTValue().func_74775_l(KEY_ROOT_FILTER));
            }
        }
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public IRootFilter getRootFilter() {
        return this.rootFilter;
    }
}

