/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.client.IDrawable;
import net.blay09.mods.refinedrelocation.api.client.IFilterPreviewGui;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.client.gui.FilterScreen;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.blay09.mods.refinedrelocation.client.gui.base.element.LabelWidget;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiButtonPriority;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiDeleteFilterButton;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiFilterSlot;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiReturnFromFilterButton;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiWhitelistButton;
import net.blay09.mods.refinedrelocation.container.RootFilterContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.INameable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class RootFilterScreen
extends FilterScreen<RootFilterContainer>
implements IFilterPreviewGui,
IHasContainer<RootFilterContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("refinedrelocation", "textures/gui/root_filter.png");
    private static final ResourceLocation TEXTURE_NO_PRIORITY = new ResourceLocation("refinedrelocation", "textures/gui/root_filter_no_priority.png");
    private static final int UPDATE_INTERVAL = 20;
    private final IDrawable textureSeparator = GuiTextures.FILTER_SEPARATOR;
    private int ticksSinceUpdate;
    private int lastSentPriority;

    public RootFilterScreen(RootFilterContainer container, PlayerInventory playerInventory, ITextComponent displayName) {
        super(container, playerInventory, displayName);
        if (container.hasSortingInventory()) {
            this.field_147000_g = 210;
        }
    }

    public PlayerInventory getPlayerInventory() {
        return this.field_213127_e;
    }

    @Override
    public void init() {
        super.init();
        GuiFilterSlot[] filterSlots = new GuiFilterSlot[3];
        GuiDeleteFilterButton[] deleteButtons = new GuiDeleteFilterButton[3];
        GuiWhitelistButton[] whitelistButtons = new GuiWhitelistButton[3];
        int x = this.field_147003_i + 10;
        for (int i = 0; i < filterSlots.length; ++i) {
            filterSlots[i] = new GuiFilterSlot(x, this.field_147009_r + 30, this, ((RootFilterContainer)this.field_147002_h).getRootFilter(), i);
            this.addButton(filterSlots[i]);
            deleteButtons[i] = new GuiDeleteFilterButton(x + 19, this.field_147009_r + 27, filterSlots[i]);
            this.addButton(deleteButtons[i]);
            whitelistButtons[i] = new GuiWhitelistButton(x + 1, this.field_147009_r + 55, this, filterSlots[i]);
            this.addButton(whitelistButtons[i]);
            x += 40;
        }
        if (((RootFilterContainer)this.field_147002_h).canReturnFromFilter()) {
            this.addButton(new GuiReturnFromFilterButton(this.field_147003_i + this.field_146999_f - 20, this.field_147009_r + 4));
        }
        if (((RootFilterContainer)this.field_147002_h).hasSortingInventory()) {
            this.addButton(new LabelWidget(this.field_147003_i + 10, this.field_147009_r + 65, I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.priority_label", (Object[])new Object[0]), 0x404040));
            this.addButton(new GuiButtonPriority(this.field_147003_i + 10, this.field_147009_r + 80, 100, 20, ((RootFilterContainer)this.field_147002_h).getSortingInventory()));
        }
    }

    @Override
    public void tick() {
        super.tick();
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate >= 20) {
            ISortingInventory sortingInventory = ((RootFilterContainer)this.field_147002_h).getSortingInventory();
            if (this.lastSentPriority != sortingInventory.getPriority()) {
                RefinedRelocationAPI.sendContainerMessageToServer("Priority", sortingInventory.getPriority());
                this.lastSentPriority = sortingInventory.getPriority();
            }
            this.ticksSinceUpdate = 0;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (((RootFilterContainer)this.field_147002_h).hasSortingInventory()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_NO_PRIORITY);
        }
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int x = this.field_147003_i + 10;
        int y = this.field_147009_r + 37;
        RenderSystem.enableBlend();
        this.textureSeparator.bind();
        this.textureSeparator.draw(x + 30, y, this.getBlitOffset());
        this.textureSeparator.draw(x + 70, y, this.getBlitOffset());
        RenderSystem.disableBlend();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        TileEntity tileEntity = ((RootFilterContainer)this.field_147002_h).getTileEntity();
        ITextComponent displayName = null;
        if (tileEntity instanceof INameable) {
            displayName = ((INameable)tileEntity).func_145748_c_();
        }
        this.font.func_211126_b(displayName != null ? I18n.func_135052_a((String)"container.refinedrelocation:root_filter_with_name", (Object[])new Object[]{displayName.func_150254_d()}) : I18n.func_135052_a((String)"container.refinedrelocation:root_filter", (Object[])new Object[0]), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    @Override
    public boolean onGuiAboutToClose() {
        RefinedRelocationAPI.sendContainerMessageToServer("Priority", ((RootFilterContainer)this.field_147002_h).getSortingInventory().getPriority());
        return true;
    }

    @Override
    public Container getFilterContainer() {
        return this.field_147002_h;
    }

    @Override
    public int getFilterGuiLeft() {
        return this.field_147003_i;
    }

    @Override
    public int getFilterGuiTop() {
        return this.field_147009_r;
    }

    @Override
    protected boolean hasOpenFilterButton() {
        return false;
    }
}

