/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.block;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.RefinedRelocationUtils;
import net.blay09.mods.refinedrelocation.SortingChestType;
import net.blay09.mods.refinedrelocation.tile.SortingChestTileEntity;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class SortingChestBlock
extends AbstractChestBlock<SortingChestTileEntity> {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private final SortingChestType chestType;

    public SortingChestBlock(SortingChestType chestType) {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(3.0f), chestType::getTileEntityType);
        this.chestType = chestType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TileEntityMerger.ICallbackWrapper<? extends ChestTileEntity> func_225536_a_(BlockState p_225536_1_, World p_225536_2_, BlockPos p_225536_3_, boolean p_225536_4_) {
        return TileEntityMerger.ICallback::func_225537_b_;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext useContext) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)useContext.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        TileEntity tileEntity;
        if (itemStack.func_82837_s() && (tileEntity = world.func_175625_s(pos)) instanceof SortingChestTileEntity) {
            ((SortingChestTileEntity)tileEntity).setCustomName(itemStack.func_200301_q().func_150261_e());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof SortingChestTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((SortingChestTileEntity)tileEntity), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean what) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            RefinedRelocationUtils.dropItemHandler(world, pos);
            world.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, world, pos, newState, what);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new SortingChestTileEntity(this.chestType);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return RefinedRelocationUtils.getComparatorInputOverride(state, world, pos);
    }

    public SortingChestType getChestType() {
        return this.chestType;
    }
}

