/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation;

import net.blay09.mods.refinedrelocation.InternalMethodsImpl;
import net.blay09.mods.refinedrelocation.ModBlocks;
import net.blay09.mods.refinedrelocation.ModItems;
import net.blay09.mods.refinedrelocation.ModTileEntities;
import net.blay09.mods.refinedrelocation.RefinedRelocationConfig;
import net.blay09.mods.refinedrelocation.SortingChestType;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.capability.CapabilityMultiRootFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySimpleFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingGridMember;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingInventory;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingUpgradable;
import net.blay09.mods.refinedrelocation.client.ModRenderers;
import net.blay09.mods.refinedrelocation.client.ModScreens;
import net.blay09.mods.refinedrelocation.container.ModContainers;
import net.blay09.mods.refinedrelocation.filter.CreativeTabFilter;
import net.blay09.mods.refinedrelocation.filter.ModFilter;
import net.blay09.mods.refinedrelocation.filter.NameFilter;
import net.blay09.mods.refinedrelocation.filter.PresetFilter;
import net.blay09.mods.refinedrelocation.filter.SameItemFilter;
import net.blay09.mods.refinedrelocation.filter.SameModFilter;
import net.blay09.mods.refinedrelocation.network.NetworkHandler;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(value="refinedrelocation")
public class RefinedRelocation {
    public static final String MOD_ID = "refinedrelocation";
    public static final Logger logger = LogManager.getLogger((String)"refinedrelocation");
    public static final ItemGroup itemGroup = new ItemGroup("refinedrelocation"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModBlocks.sortingChests[SortingChestType.WOOD.ordinal()]);
        }
    };

    public RefinedRelocation() {
        RefinedRelocationAPI.__internal__setupAPI(new InternalMethodsImpl());
        NetworkHandler.init();
        RefinedRelocationAPI.registerFilter(SameItemFilter.class);
        RefinedRelocationAPI.registerFilter(NameFilter.class);
        RefinedRelocationAPI.registerFilter(PresetFilter.class);
        RefinedRelocationAPI.registerFilter(CreativeTabFilter.class);
        RefinedRelocationAPI.registerFilter(ModFilter.class);
        RefinedRelocationAPI.registerFilter(SameModFilter.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, this::registerTileEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::finishLoading);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RefinedRelocationConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, RefinedRelocationConfig.clientSpec);
    }

    private void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
    }

    private void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        ModContainers.register(event.getRegistry());
    }

    private void registerItems(RegistryEvent.Register<Item> event) {
        ModItems.register((IForgeRegistry<Item>)event.getRegistry());
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
    }

    private void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        ModTileEntities.registerTileEntities(event.getRegistry());
    }

    private void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            CapabilitySimpleFilter.register();
            CapabilityRootFilter.register();
            CapabilityMultiRootFilter.register();
            CapabilitySortingGridMember.register();
            CapabilitySortingInventory.register();
            CapabilitySortingUpgradable.register();
        });
    }

    private void setupClient(FMLClientSetupEvent event) {
        ModScreens.register();
        ModRenderers.register();
    }

    private void finishLoading(FMLLoadCompleteEvent event) {
        CreativeTabFilter.gatherCreativeTabs();
        ModFilter.gatherMods();
        if (ModList.get().isLoaded("ironchest")) {
            try {
                Class.forName("net.blay09.mods.refinedrelocation.compat.ironchest.IronChestAddon").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("Failed to load Iron Chest compat", (Throwable)e);
            }
        }
    }
}

