/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.client.screens.widget.ToggleButton;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeFreezeDelay;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeMiningSize;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeRange;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeVolume;
import com.direwolf20.mininggadgets.common.network.packets.PacketOpenFilterContainer;
import com.direwolf20.mininggadgets.common.network.packets.PacketToggleFilters;
import com.direwolf20.mininggadgets.common.network.packets.PacketTogglePrecision;
import com.direwolf20.mininggadgets.common.network.packets.PacketUpdateUpgrade;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class MiningSettingScreen
extends Screen
implements Slider.ISlider {
    private ItemStack gadget;
    private int beamRange;
    private int freezeDelay;
    private float volume;
    private int currentSize = 1;
    private boolean isWhitelist = true;
    private boolean isPrecision = true;
    private Slider rangeSlider;
    private Slider volumeSlider;
    private Slider freezeDelaySlider;
    private List<Upgrade> toggleableList = new ArrayList<Upgrade>();
    private HashMap<Upgrade, ToggleButton> upgradeButtons = new HashMap();
    private boolean containsFreeze = false;

    public MiningSettingScreen(ItemStack gadget) {
        super((ITextComponent)new StringTextComponent("title"));
        this.gadget = gadget;
        this.beamRange = MiningProperties.getBeamRange(gadget);
        this.volume = MiningProperties.getVolume(gadget);
        this.freezeDelay = MiningProperties.getFreezeDelay(gadget);
    }

    protected void init() {
        ArrayList<Object> leftWidgets = new ArrayList<Object>();
        int baseX = this.width / 2;
        int baseY = this.height / 2;
        this.toggleableList.clear();
        this.toggleableList = UpgradeTools.getUpgrades(this.gadget).stream().filter(Upgrade::isToggleable).collect(Collectors.toList());
        this.containsFreeze = UpgradeTools.containsUpgradeFromList(this.toggleableList, Upgrade.FREEZING);
        boolean containsVoid = UpgradeTools.containsUpgradeFromList(this.toggleableList, Upgrade.VOID_JUNK);
        this.isWhitelist = MiningProperties.getWhiteList(this.gadget);
        this.isPrecision = MiningProperties.getPrecisionMode(this.gadget);
        int top = baseY - (this.containsFreeze ? 80 : 60);
        int index = 0;
        int x = baseX + 10;
        int y = top + (containsVoid ? 45 : 20);
        for (Upgrade upgrade : this.toggleableList) {
            ToggleButton btn = new ToggleButton(x + index * 30, y, UpgradeTools.getName(upgrade), new ResourceLocation("mininggadgets", "textures/item/upgrade_" + upgrade.getName() + ".png"), send -> this.toggleUpgrade(upgrade, (boolean)send));
            this.addButton(btn);
            this.upgradeButtons.put(upgrade, btn);
            if (++index % 4 != 0) continue;
            index = 0;
            y += 35;
        }
        if (containsVoid) {
            this.addButton((Widget)new Button(baseX + 10, top + 20, 95, 20, MiningSettingScreen.getTrans("tooltip.screen.edit_filters", new Object[0]), button -> PacketHandler.sendToServer(new PacketOpenFilterContainer())));
            this.addButton((Widget)new WhitelistButton(baseX + 10 + 95, top + 20, 20, 20, this.isWhitelist, button -> {
                this.isWhitelist = !this.isWhitelist;
                ((WhitelistButton)button).setWhitelist(this.isWhitelist);
                PacketHandler.sendToServer(new PacketToggleFilters());
            }));
        }
        this.currentSize = MiningProperties.getRange(this.gadget);
        Button sizeButton = new Button(baseX - 135, 0, 125, 20, new TranslationTextComponent("mininggadgets.tooltip.screen.size", new Object[]{this.currentSize}).func_150261_e(), button -> {
            this.currentSize = this.currentSize == 1 ? 3 : 1;
            button.setMessage(MiningSettingScreen.getTrans("tooltip.screen.size", this.currentSize));
            PacketHandler.sendToServer(new PacketChangeMiningSize());
        });
        leftWidgets.add(sizeButton);
        this.rangeSlider = new Slider(baseX - 135, 0, 125, 20, MiningSettingScreen.getTrans("tooltip.screen.range", new Object[0]) + ": ", "", 1.0, (double)MiningProperties.getBeamMaxRange(this.gadget), (double)this.beamRange, false, true, s -> {}, (Slider.ISlider)this);
        leftWidgets.add(this.rangeSlider);
        leftWidgets.add(new Button(baseX - 135, 0, 125, 20, MiningSettingScreen.getTrans("tooltip.screen.visuals_menu", new Object[0]), button -> ModScreens.openVisualSettingsScreen(this.gadget)));
        leftWidgets.add(new Button(baseX - 135, 0, 125, 20, MiningSettingScreen.getTrans("tooltip.screen.precision_mode", this.isPrecision), button -> {
            this.isPrecision = !this.isPrecision;
            button.setMessage(MiningSettingScreen.getTrans("tooltip.screen.precision_mode", this.isPrecision));
            PacketHandler.sendToServer(new PacketTogglePrecision());
        }));
        this.volumeSlider = new Slider(baseX - 135, 0, 125, 20, MiningSettingScreen.getTrans("tooltip.screen.volume", new Object[0]) + ": ", "%", 0.0, 100.0, (double)Math.min(100.0f, this.volume * 100.0f), false, true, s -> {}, (Slider.ISlider)this);
        leftWidgets.add(this.volumeSlider);
        if (this.containsFreeze) {
            this.freezeDelaySlider = new Slider(baseX - 135, 0, 125, 20, MiningSettingScreen.getTrans("tooltip.screen.freeze_delay", new Object[0]) + ": ", " " + MiningSettingScreen.getTrans("tooltip.screen.ticks", new Object[0]), 0.0, 10.0, (double)MiningProperties.getFreezeDelay(this.gadget), false, true, s -> {}, (Slider.ISlider)this);
            leftWidgets.add(this.freezeDelaySlider);
        }
        if (!UpgradeTools.containsActiveUpgrade(this.gadget, Upgrade.THREE_BY_THREE)) {
            sizeButton.active = false;
        }
        for (int i = 0; i < leftWidgets.size(); ++i) {
            ((Widget)leftWidgets.get((int)i)).y = top + 20 + i * 25;
            this.addButton((Widget)leftWidgets.get(i));
        }
    }

    private boolean toggleUpgrade(Upgrade upgrade, boolean update) {
        if (update) {
            this.updateButtons(upgrade);
            PacketHandler.sendToServer(new PacketUpdateUpgrade(upgrade.getName()));
        }
        return upgrade.isEnabled();
    }

    private void updateButtons(Upgrade upgrade) {
        for (Map.Entry<Upgrade, ToggleButton> btn : this.upgradeButtons.entrySet()) {
            Upgrade btnUpgrade = btn.getKey();
            if ((!btnUpgrade.lazyIs(Upgrade.FORTUNE_1) || !btn.getValue().isEnabled() || !upgrade.lazyIs(Upgrade.SILK)) && (!btnUpgrade.lazyIs(Upgrade.SILK) || !btn.getValue().isEnabled() || !upgrade.lazyIs(Upgrade.FORTUNE_1))) continue;
            this.upgradeButtons.get((Object)btn.getKey()).setEnabled(false);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        int top = this.height / 2 - (this.containsFreeze ? 80 : 60);
        this.drawString(this.getMinecraft().field_71466_p, MiningSettingScreen.getTrans("tooltip.screen.mining_gadget", new Object[0]), this.width / 2 - 135, top, Color.WHITE.getRGB());
        this.drawString(this.getMinecraft().field_71466_p, MiningSettingScreen.getTrans("tooltip.screen.toggle_upgrades", new Object[0]), this.width / 2 + 10, top, Color.WHITE.getRGB());
        if (this.toggleableList.size() == 0) {
            this.drawString(this.getMinecraft().field_71466_p, MiningSettingScreen.getTrans("tooltip.screen.no_upgrades", new Object[0]), this.width / 2 + 10, top + 20, Color.GRAY.getRGB());
        }
        this.children.forEach(e -> {
            if (!(e instanceof ToggleButton || e instanceof WhitelistButton || e.equals(this.freezeDelaySlider))) {
                return;
            }
            if (e instanceof WhitelistButton) {
                if (e.isMouseOver((double)mouseX, (double)mouseY)) {
                    this.renderTooltip(this.isWhitelist ? MiningSettingScreen.getTrans("tooltip.screen.whitelist", new Object[0]) : MiningSettingScreen.getTrans("tooltip.screen.blacklist", new Object[0]), mouseX, mouseY);
                }
            } else if (e.equals(this.freezeDelaySlider)) {
                if (e.isMouseOver((double)mouseX, (double)mouseY)) {
                    assert (e instanceof Slider);
                    this.renderTooltip(Arrays.asList(MiningSettingScreen.getTrans("tooltip.screen.delay_explain", new Object[0]).split("\n")), ((Slider)e).x - 8, ((Slider)e).y + 40);
                }
            } else {
                assert (e instanceof ToggleButton);
                ToggleButton btn = (ToggleButton)((Object)e);
                if (btn.isMouseOver(mouseX, mouseY)) {
                    this.renderTooltip(btn.getTooltip(), mouseX, mouseY);
                }
            }
        });
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        PacketHandler.sendToServer(new PacketChangeRange(this.beamRange));
        PacketHandler.sendToServer(new PacketChangeVolume(this.volume));
        PacketHandler.sendToServer(new PacketChangeFreezeDelay(this.freezeDelay));
        super.onClose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void onChangeSliderValue(Slider slider) {
        if (slider.equals(this.rangeSlider)) {
            this.beamRange = slider.getValueInt();
        }
        if (slider.equals(this.freezeDelaySlider)) {
            this.freezeDelay = slider.getValueInt();
        }
        if (slider.equals(this.volumeSlider)) {
            this.volume = (float)slider.getValueInt() / 100.0f;
        }
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.rangeSlider.dragging = false;
        this.volumeSlider.dragging = false;
        if (this.freezeDelaySlider != null) {
            this.freezeDelaySlider.dragging = false;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.rangeSlider.isMouseOver(mouseX, mouseY)) {
            this.rangeSlider.sliderValue = this.rangeSlider.sliderValue + (double)(0.1f * (float)(delta > 0.0 ? 1 : -1));
            this.rangeSlider.updateSlider();
        }
        if (this.freezeDelaySlider.isMouseOver(mouseX, mouseY)) {
            this.freezeDelaySlider.sliderValue = this.freezeDelaySlider.sliderValue + (double)(0.1f * (float)(delta > 0.0 ? 1 : -1));
            this.freezeDelaySlider.updateSlider();
        }
        if (this.volumeSlider.isMouseOver(mouseX, mouseY)) {
            this.volumeSlider.sliderValue = this.volumeSlider.sliderValue + (double)(1.0f * (float)(delta > 0.0 ? 1 : -1));
            this.volumeSlider.updateSlider();
        }
        return false;
    }

    private static String getTrans(String key, Object ... args) {
        return new TranslationTextComponent("mininggadgets." + key, args).func_150261_e();
    }

    public static final class WhitelistButton
    extends Button {
        private boolean isWhitelist;

        public WhitelistButton(int widthIn, int heightIn, int width, int height, boolean isWhitelist, Button.IPressable onPress) {
            super(widthIn, heightIn, width, height, "", onPress);
            this.isWhitelist = isWhitelist;
        }

        public void renderButton(int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            RenderSystem.disableTexture();
            RenderSystem.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
            this.blit(this.x, this.y, 0, 0, this.width, this.height);
            if (this.isWhitelist) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.blit(this.x + 2, this.y + 2, 0, 0, this.width - 4, this.height - 4);
            RenderSystem.enableTexture();
        }

        public void setWhitelist(boolean whitelist) {
            this.isWhitelist = whitelist;
        }
    }
}

