/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IRegistryDelegate;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.api.wand.IWireframeAABBProvider;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.core.helper.ColorHelper;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.item.ModItems;

public class BlockSpreader
extends BlockMod
implements IWandable,
IWandHUD,
IWireframeAABBProvider {
    private static final VoxelShape RENDER_SHAPE = BlockSpreader.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public final Variant variant;

    public BlockSpreader(Variant v, Block.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @Nonnull
    public VoxelShape func_196247_c(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return RENDER_SHAPE;
    }

    public boolean func_220067_a(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, EntityType<?> type) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction orientation = placer == null ? Direction.WEST : Direction.func_196054_a((Entity)placer)[0].func_176734_d();
        TileSpreader spreader = (TileSpreader)world.func_175625_s(pos);
        switch (orientation) {
            case DOWN: {
                spreader.rotationY = -90.0f;
                break;
            }
            case UP: {
                spreader.rotationY = 90.0f;
                break;
            }
            case NORTH: {
                spreader.rotationX = 270.0f;
                break;
            }
            case SOUTH: {
                spreader.rotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            case EAST: {
                spreader.rotationX = 180.0f;
            }
        }
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean wool;
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileSpreader)) {
            return ActionResultType.PASS;
        }
        TileSpreader spreader = (TileSpreader)tile;
        ItemStack lens = spreader.getItemHandler().getStackInSlot(0);
        ItemStack heldItem = player.func_184586_b(hand);
        boolean isHeldItemLens = !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ILens;
        boolean bl = wool = !heldItem.func_190926_b() && ColorHelper.WOOL_MAP.containsValue((Object)Block.func_149634_a((Item)heldItem.func_77973_b()).delegate);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.twigWand) {
            return ActionResultType.PASS;
        }
        if (lens.func_190926_b() && isHeldItemLens) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            spreader.getItemHandler().setStackInSlot(0, heldItem.func_77946_l());
            spreader.func_70296_d();
        } else if (!lens.func_190926_b() && !wool) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)lens);
            spreader.getItemHandler().setStackInSlot(0, ItemStack.field_190927_a);
            spreader.func_70296_d();
        }
        if (wool && spreader.paddingColor == null) {
            Block block = Block.func_149634_a((Item)heldItem.func_77973_b());
            spreader.paddingColor = (DyeColor)ColorHelper.WOOL_MAP.inverse().get((Object)block.delegate);
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
        } else if (heldItem.func_190926_b() && spreader.paddingColor != null && lens.func_190926_b()) {
            ItemStack pad = new ItemStack((IItemProvider)((IRegistryDelegate)ColorHelper.WOOL_MAP.get((Object)spreader.paddingColor)).get());
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)pad);
            spreader.paddingColor = null;
            spreader.func_70296_d();
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileSpreader)) {
                return;
            }
            TileSpreader inv = (TileSpreader)tile;
            if (inv.paddingColor != null) {
                ItemStack padding = new ItemStack((IItemProvider)((IRegistryDelegate)ColorHelper.WOOL_MAP.get((Object)inv.paddingColor)).get());
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), padding));
            }
            InventoryHelper.dropInventory(inv, world, state, pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        ((TileSpreader)world.func_175625_s(pos)).onWanded(player, stack);
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileSpreader();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc, World world, BlockPos pos) {
        ((TileSpreader)world.func_175625_s(pos)).renderHUD(mc);
    }

    @Override
    public List<AxisAlignedBB> getWireframeAABB(World world, BlockPos pos) {
        return ImmutableList.of((Object)new AxisAlignedBB(pos).func_186664_h(0.0625));
    }

    public static enum Variant {
        MANA(160, 1000, 0x20FF20, 65280, 60, 4.0f, 1.0f),
        REDSTONE(160, 1000, 0xFF2020, 0xFF0000, 60, 4.0f, 1.0f),
        ELVEN(240, 1000, 16729540, 16711854, 80, 4.0f, 1.25f),
        GAIA(640, 6400, 0x20FF20, 65280, 120, 20.0f, 2.0f);

        public final int burstMana;
        public final int manaCapacity;
        public final int color;
        public final int hudColor;
        public final int preLossTicks;
        public final float lossPerTick;
        public final float motionModifier;

        private Variant(int bm, int mc, int c, int hc, int plt, float lpt, float mm) {
            this.burstMana = bm;
            this.manaCapacity = mc;
            this.color = c;
            this.hudColor = hc;
            this.preLossTicks = plt;
            this.lossPerTick = lpt;
            this.motionModifier = mm;
        }
    }
}

