/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileTeruTeruBozu;

public class BlockTeruTeruBozu
extends BlockMod {
    private static final VoxelShape SHAPE = BlockTeruTeruBozu.func_208617_a((double)4.0, (double)0.16, (double)4.0, (double)12.0, (double)15.84, (double)12.0);

    public BlockTeruTeruBozu(Block.Properties builder) {
        super(builder);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity e) {
        ItemEntity item;
        ItemStack stack;
        if (!world.field_72995_K && e instanceof ItemEntity && (this.isSunflower(stack = (item = (ItemEntity)e).func_92059_d()) && this.removeRain(world) || this.isBlueOrchid(stack) && this.startRain(world))) {
            stack.func_190918_g(1);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && (this.isSunflower(stack) && this.removeRain(world) || this.isBlueOrchid(stack) && this.startRain(world))) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private boolean isSunflower(ItemStack stack) {
        return stack.func_77973_b() == Blocks.field_196800_gd.func_199767_j();
    }

    private boolean isBlueOrchid(ItemStack stack) {
        return stack.func_77973_b() == Blocks.field_196607_be.func_199767_j();
    }

    private boolean removeRain(World world) {
        if (world.func_72896_J()) {
            world.func_72912_H().func_76084_b(false);
            TileTeruTeruBozu.resetRainTime(world);
            return true;
        }
        return false;
    }

    private boolean startRain(World world) {
        if (!world.func_72896_J()) {
            if (world.field_73012_v.nextInt(10) == 0) {
                world.func_72912_H().func_76084_b(true);
                TileTeruTeruBozu.resetRainTime(world);
            }
            return true;
        }
        return false;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return world.func_72896_J() ? 15 : 0;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileTeruTeruBozu();
    }
}

