/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class FloatingFlowerModel
implements IModelGeometry<FloatingFlowerModel> {
    private IUnbakedModel unbakedFlower;
    private final Map<IFloatingFlower.IslandType, IUnbakedModel> unbakedIslands = new HashMap<IFloatingFlower.IslandType, IUnbakedModel>();

    private FloatingFlowerModel(IUnbakedModel flower) {
        this.unbakedFlower = flower;
    }

    @Nonnull
    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> ret = new HashSet<Material>();
        for (Map.Entry<IFloatingFlower.IslandType, ResourceLocation> e : BotaniaAPIClient.instance().getRegisteredIslandTypeModels().entrySet()) {
            IUnbakedModel unbakedIsland = modelGetter.apply(e.getValue());
            ret.addAll(unbakedIsland.func_225614_a_(modelGetter, missingTextureErrors));
            this.unbakedIslands.put(e.getKey(), unbakedIsland);
        }
        ret.addAll(this.unbakedFlower.func_225614_a_(modelGetter, missingTextureErrors));
        return ret;
    }

    @Nullable
    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation name) {
        TransformationMatrix moveFlower = new TransformationMatrix(new Vector3f(0.0f, 0.2f, 0.0f), null, new Vector3f(0.5f, 0.5f, 0.5f), null);
        ModelTransformComposition comp = new ModelTransformComposition((IModelTransform)new SimpleModelTransform(moveFlower), transform);
        IBakedModel bakedFlower = this.unbakedFlower.func_225613_a_(bakery, spriteGetter, (IModelTransform)comp, name);
        HashMap<IFloatingFlower.IslandType, IBakedModel> bakedIslands = new HashMap<IFloatingFlower.IslandType, IBakedModel>();
        for (Map.Entry<IFloatingFlower.IslandType, IUnbakedModel> e : this.unbakedIslands.entrySet()) {
            IBakedModel bakedIsland = e.getValue().func_225613_a_(bakery, spriteGetter, transform, name);
            bakedIslands.put(e.getKey(), bakedIsland);
        }
        return new Baked(bakedFlower, bakedIslands);
    }

    public static enum Loader implements IModelLoader<FloatingFlowerModel>
    {
        INSTANCE;

        public static final ResourceLocation ID;

        public void func_195410_a(@Nonnull IResourceManager resourceManager) {
        }

        @Nonnull
        public FloatingFlowerModel read(JsonDeserializationContext ctx, JsonObject model) {
            BlockModel flower = (BlockModel)ctx.deserialize((JsonElement)model.getAsJsonObject("flower"), BlockModel.class);
            return new FloatingFlowerModel((IUnbakedModel)flower);
        }

        static {
            ID = ResourceLocationHelper.prefix("floating_flower");
        }
    }

    public static class Baked
    extends BakedModelWrapper<IBakedModel> {
        private final Map<IFloatingFlower.IslandType, List<BakedQuad>> genQuads = new HashMap<IFloatingFlower.IslandType, List<BakedQuad>>();
        private final Map<IFloatingFlower.IslandType, Map<Direction, List<BakedQuad>>> faceQuads = new HashMap<IFloatingFlower.IslandType, Map<Direction, List<BakedQuad>>>();

        Baked(IBakedModel flower, Map<IFloatingFlower.IslandType, IBakedModel> islands) {
            super(flower);
            Random rand = new Random();
            for (Map.Entry<IFloatingFlower.IslandType, IBakedModel> e : islands.entrySet()) {
                rand.setSeed(42L);
                ArrayList gen = new ArrayList(flower.getQuads(null, null, rand, (IModelData)EmptyModelData.INSTANCE));
                rand.setSeed(42L);
                gen.addAll(e.getValue().getQuads(null, null, rand, (IModelData)EmptyModelData.INSTANCE));
                this.genQuads.put(e.getKey(), gen);
                EnumMap fq = new EnumMap(Direction.class);
                for (Direction dir : Direction.values()) {
                    rand.setSeed(42L);
                    ArrayList lst = new ArrayList(flower.getQuads(null, dir, rand, (IModelData)EmptyModelData.INSTANCE));
                    rand.setSeed(42L);
                    lst.addAll(e.getValue().getQuads(null, dir, rand, (IModelData)EmptyModelData.INSTANCE));
                    fq.put(dir, lst);
                }
                this.faceQuads.put(e.getKey(), fq);
            }
        }

        @Nonnull
        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
            return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            IFloatingFlower.IslandType type = IFloatingFlower.IslandType.GRASS;
            if (extraData.hasProperty(BotaniaStateProps.FLOATING_DATA)) {
                type = ((IFloatingFlower)extraData.getData(BotaniaStateProps.FLOATING_DATA)).getIslandType();
            }
            if (side == null) {
                return this.genQuads.get(type);
            }
            return this.faceQuads.get(type).get(side);
        }

        @Nonnull
        public IBakedModel handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType, MatrixStack ms) {
            super.handlePerspective(cameraTransformType, ms);
            return this;
        }
    }
}

