/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.drone.DroneConstructingEvent;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.api.semiblock.SemiblockEvent;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.entity.EntityProgrammableController;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.inventory.ContainerProgrammableController;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneFakePlayer;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneItemHandler;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityProgrammableController
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IDroneBase,
ISideConfigurable,
INamedContainerProvider {
    private static final int INVENTORY_SIZE = 1;
    private static final String FALLBACK_NAME = "[ProgController]";
    private static final UUID FALLBACK_UUID = UUID.nameUUIDFromBytes("[ProgController]".getBytes());
    private static final int MAX_ENERGY = 100000;
    private final ProgrammableItemStackHandler inventory = new ProgrammableItemStackHandler(this);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    private final FluidTank tank = new FluidTank(16000);
    private final LazyOptional<IFluidHandler> tankCap = LazyOptional.of(() -> this.tank);
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private EntityProgrammableController drone;
    private DroneAIManager aiManager;
    private DroneFakePlayer fakePlayer;
    private DroneItemHandler droneItemHandler;
    private final List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private final int[] redstoneLevels = new int[6];
    private final SideConfigurator<IItemHandler> itemHandlerSideConfigurator;
    @DescSynced
    private double targetX;
    @DescSynced
    private double targetY;
    @DescSynced
    private double targetZ;
    @DescSynced
    @LazySynced
    private double curX;
    @DescSynced
    @LazySynced
    private double curY;
    @DescSynced
    @LazySynced
    private double curZ;
    @DescSynced
    private int diggingX;
    @DescSynced
    private int diggingY;
    @DescSynced
    private int diggingZ;
    @DescSynced
    private int speedUpgrades;
    @DescSynced
    public boolean isIdle;
    public static final Set<ResourceLocation> BLACKLISTED_WIDGETS = ImmutableSet.of((Object)PneumaticCraftUtils.RL("computer_craft"), (Object)PneumaticCraftUtils.RL("entity_attack"), (Object)PneumaticCraftUtils.RL("drone_condition_entity"), (Object)PneumaticCraftUtils.RL("standby"), (Object)PneumaticCraftUtils.RL("suicide"), (Object)PneumaticCraftUtils.RL("teleport"), (Object[])new ResourceLocation[]{PneumaticCraftUtils.RL("entity_export"), PneumaticCraftUtils.RL("entity_import")});
    private UUID ownerID;
    private ITextComponent ownerName;
    private boolean updateNeighbours;
    private LogisticsManager logisticsManager;

    public TileEntityProgrammableController() {
        super((TileEntityType)ModTileEntities.PROGRAMMABLE_CONTROLLER.get(), 20.0f, 25.0f, 10000, 4);
        MinecraftForge.EVENT_BUS.post((Event)new DroneConstructingEvent(this));
        this.itemHandlerSideConfigurator = new SideConfigurator("items", this);
        this.itemHandlerSideConfigurator.registerHandler("droneInv", new ItemStack((IItemProvider)ModItems.DRONE.get()), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> this.droneItemHandler), SideConfigurator.RelativeFace.TOP, SideConfigurator.RelativeFace.FRONT, SideConfigurator.RelativeFace.BACK, SideConfigurator.RelativeFace.LEFT, SideConfigurator.RelativeFace.RIGHT);
        this.itemHandlerSideConfigurator.registerHandler("programmableInv", new ItemStack((IItemProvider)ModItems.NETWORK_API.get()), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> this.inventory), SideConfigurator.RelativeFace.BOTTOM);
        this.itemHandlerSideConfigurator.setNullFaceHandler("droneInv");
    }

    @SubscribeEvent
    public void onSemiblockEvent(SemiblockEvent event) {
        if (!event.getWorld().field_72995_K && event.getWorld() == this.func_145831_w() && event.getSemiblock() instanceof EntityLogisticsFrame) {
            this.logisticsManager = null;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.updateNeighbours) {
            this.updateNeighbours();
            this.updateNeighbours = false;
        }
        double speed = this.getSpeed();
        if (PneumaticCraftUtils.distBetweenSq((Vec3i)this.func_174877_v(), this.targetX, this.targetY, this.targetZ) <= 1.0 && this.isIdle) {
            this.curX = this.targetX;
            this.curY = this.targetY;
            this.curZ = this.targetZ;
        } else if (PneumaticCraftUtils.distBetweenSq(this.curX, this.curY, this.curZ, this.targetX, this.targetY, this.targetZ) > 0.25) {
            Vec3d vec = new Vec3d(this.targetX - this.curX, this.targetY - this.curY, this.targetZ - this.curZ).func_72432_b().func_186678_a(speed);
            this.curX += vec.field_72450_a;
            this.curY += vec.field_72448_b;
            this.curZ += vec.field_72449_c;
        }
        if (!this.func_145831_w().field_72995_K) {
            DroneFakePlayer fp = this.getFakePlayer();
            for (int i = 0; i < 4; ++i) {
                fp.field_71134_c.func_73075_a();
            }
            fp.func_70107_b(this.curX, this.curY, this.curZ);
            fp.func_70071_h_();
            if (this.getPressure() >= this.getMinWorkingPressure()) {
                if (!this.aiManager.isIdling()) {
                    this.addAir(-10);
                }
                this.aiManager.onUpdateTasks();
            }
        } else {
            if (this.drone == null || !this.drone.func_70089_S()) {
                this.drone = (EntityProgrammableController)((EntityType)ModEntities.PROGRAMMABLE_CONTROLLER.get()).func_200721_a(this.func_145831_w());
                this.drone.setController(this);
                this.drone.func_70107_b(this.curX, this.curY, this.curZ);
                if (this.field_145850_b instanceof ClientWorld) {
                    ((ClientWorld)this.func_145831_w()).func_217411_a(this.drone.func_145782_y(), (Entity)this.drone);
                }
            }
            this.drone.func_70107_b(this.curX, this.curY, this.curZ);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        if (this.drone != null) {
            this.drone.func_70106_y();
        }
    }

    private double getSpeed() {
        return (double)Math.min(10, this.speedUpgrades) * 0.05 + 0.15;
    }

    private UUID getOwnerUUID() {
        if (this.ownerID == null) {
            this.ownerID = UUID.randomUUID();
            Log.warning(String.format("Programmable controller with owner '%s' has no UUID! Substituting a random UUID (%s).", this.ownerName, this.ownerID.toString()), new Object[0]);
        }
        return this.ownerID;
    }

    private DroneItemHandler getDroneItemHandler() {
        if (this.droneItemHandler == null) {
            this.droneItemHandler = new DroneItemHandler(this);
        }
        return this.droneItemHandler;
    }

    private void initializeFakePlayer() {
        this.fakePlayer = new DroneFakePlayer((ServerWorld)this.func_145831_w(), new GameProfile(this.getOwnerUUID(), "test"), this);
        this.fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(ServerLifecycleHooks.getCurrentServer(), (ServerPlayerEntity)this.fakePlayer);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (this.itemHandlerSideConfigurator.handleButtonPress(tag)) {
            this.updateNeighbours = true;
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    public void setOwner(PlayerEntity ownerID) {
        this.ownerID = ownerID.func_110124_au();
        this.ownerName = ownerID.func_200200_C_();
    }

    @Override
    public List<SideConfigurator> getSideConfigurators() {
        return Collections.singletonList(this.itemHandlerSideConfigurator);
    }

    @Override
    public Direction byIndex() {
        return this.getRotation();
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerProgrammableController(i, playerInventory, this.func_174877_v());
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.calculateUpgrades();
        }
    }

    private void calculateUpgrades() {
        int oldDispenserUpgrades = this.getUpgrades(EnumUpgrade.INVENTORY);
        int dispenserUpgrades = Math.min(35, this.getUpgrades(EnumUpgrade.INVENTORY));
        if (!this.func_145831_w().field_72995_K && oldDispenserUpgrades != dispenserUpgrades) {
            this.tank.setCapacity((dispenserUpgrades + 1) * 16000);
            if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
                this.tank.getFluid().setAmount(this.tank.getCapacity());
            }
        }
        this.speedUpgrades = this.getUpgrades(EnumUpgrade.SPEED);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.ownerID = tag.func_74764_b("ownerID") ? UUID.fromString(tag.func_74779_i("ownerID")) : FALLBACK_UUID;
        this.ownerName = tag.func_74764_b("ownerName") ? new StringTextComponent(tag.func_74779_i("ownerName")) : new StringTextComponent(FALLBACK_NAME);
        this.droneItemHandler = new DroneItemHandler(this);
        ItemStackHandler tmpInv = new ItemStackHandler();
        tmpInv.deserializeNBT(tag.func_74775_l("droneItems"));
        if (this.getDroneSlots() != this.droneItemHandler.getSlots()) {
            Log.warning("drone inventory size mismatch: dispenser upgrades = " + this.getDroneSlots() + ", saved inv size = " + this.droneItemHandler.getSlots(), new Object[0]);
        }
        for (int i = 0; i < tmpInv.getSlots() && i < this.droneItemHandler.getSlots(); ++i) {
            this.droneItemHandler.setStackInSlot(i, tmpInv.getStackInSlot(i).func_77946_l());
        }
        this.energy.writeToNBT(tag);
        this.itemHandlerSideConfigurator.updateHandler("droneInv", (NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> this.droneItemHandler));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        CompoundNBT tankTag = new CompoundNBT();
        this.tank.writeToNBT(tankTag);
        tag.func_218657_a("tank", (INBT)tankTag);
        ItemStackHandler handler = new ItemStackHandler(this.getDroneSlots());
        for (int i = 0; i < this.getDroneSlots(); ++i) {
            handler.setStackInSlot(i, this.getDroneItemHandler().getStackInSlot(i));
        }
        tag.func_218657_a("droneItems", (INBT)handler.serializeNBT());
        if (this.ownerID != null) {
            tag.func_74778_a("ownerID", this.ownerID.toString());
        }
        if (this.ownerName != null) {
            tag.func_74778_a("ownerName", this.ownerName.func_150254_d());
        }
        this.energy.readFromNBT(tag);
        return tag;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.tankCap);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.itemHandlerSideConfigurator.getHandler(side));
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, this.energyCap);
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.getDroneItemHandler().setFakePlayerReady();
        this.calculateUpgrades();
        this.inventory.onContentsChanged(0);
        this.curX = this.targetX = (double)this.func_174877_v().func_177958_n() + 0.5;
        this.curY = this.targetY = (double)this.func_174877_v().func_177956_o() + 1.0;
        this.curZ = this.targetZ = (double)this.func_174877_v().func_177952_p() + 0.5;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private int getDroneSlots() {
        return this.field_145850_b != null && this.field_145850_b.field_72995_K ? 0 : Math.min(36, 1 + this.getUpgrades(EnumUpgrade.INVENTORY));
    }

    private static boolean isProgrammableAndValidForDrone(IDroneBase drone, ItemStack programmable) {
        if (programmable.func_77973_b() instanceof IProgrammable && ((IProgrammable)programmable.func_77973_b()).canProgram(programmable) && ((IProgrammable)programmable.func_77973_b()).usesPieces(programmable)) {
            List<IProgWidget> widgets = TileEntityProgrammer.getProgWidgets(programmable);
            return widgets.stream().allMatch(widget -> drone.isProgramApplicable(widget.getType()));
        }
        return false;
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public IFluidTank getFluidTank() {
        return this.tank;
    }

    @Override
    public IItemHandlerModifiable getInv() {
        return this.getDroneItemHandler();
    }

    @Override
    public Vec3d getDronePos() {
        if (this.curX == 0.0 && this.curY == 0.0 && this.curZ == 0.0) {
            this.curX = (double)this.func_174877_v().func_177958_n() + 0.5;
            this.curY = (double)this.func_174877_v().func_177956_o() + 1.0;
            this.curZ = (double)this.func_174877_v().func_177952_p() + 0.5;
            this.targetX = this.curX;
            this.targetY = this.curY;
            this.targetZ = this.curZ;
        }
        return new Vec3d(this.curX, this.curY, this.curZ);
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return new IPathNavigator(){

            @Override
            public boolean moveToXYZ(double x, double y, double z) {
                if (TileEntityProgrammableController.this.isBlockValidPathfindBlock(new BlockPos(x, y, z))) {
                    TileEntityProgrammableController.this.targetX = x + 0.5;
                    TileEntityProgrammableController.this.targetY = y - 0.3;
                    TileEntityProgrammableController.this.targetZ = z + 0.5;
                    return true;
                }
                return false;
            }

            @Override
            public boolean moveToEntity(Entity entity) {
                return this.moveToXYZ(entity.func_226277_ct_(), entity.func_226278_cu_() + 0.3, entity.func_226281_cx_());
            }

            @Override
            public boolean hasNoPath() {
                return PneumaticCraftUtils.distBetweenSq(TileEntityProgrammableController.this.curX, TileEntityProgrammableController.this.curY, TileEntityProgrammableController.this.curZ, TileEntityProgrammableController.this.targetX, TileEntityProgrammableController.this.targetY, TileEntityProgrammableController.this.targetZ) < 0.5;
            }

            @Override
            public boolean isGoingToTeleport() {
                return false;
            }
        };
    }

    @Override
    public void sendWireframeToClient(BlockPos pos) {
    }

    @Override
    public DroneFakePlayer getFakePlayer() {
        if (this.fakePlayer == null) {
            this.initializeFakePlayer();
        }
        return this.fakePlayer;
    }

    @Override
    public boolean isBlockValidPathfindBlock(BlockPos pos) {
        return this.func_145831_w().func_175623_d(pos);
    }

    @Override
    public void dropItem(ItemStack stack) {
        Vec3d pos = this.getDronePos();
        this.func_145831_w().func_217376_c((Entity)new ItemEntity(this.func_145831_w(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack));
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        super.getContentsToDrop(drops);
        for (int i = 0; i < this.getDroneSlots(); ++i) {
            if (this.fakePlayer.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            drops.add((Object)this.fakePlayer.field_71071_by.func_70301_a(i).func_77946_l());
        }
    }

    @Override
    public void setDugBlock(BlockPos pos) {
        if (pos != null) {
            this.diggingX = pos.func_177958_n();
            this.diggingY = pos.func_177956_o();
            this.diggingZ = pos.func_177952_p();
        } else {
            this.diggingZ = 0;
            this.diggingY = 0;
            this.diggingX = 0;
        }
    }

    public BlockPos getDugPosition() {
        return this.diggingX != 0 || this.diggingY != 0 || this.diggingZ != 0 ? new BlockPos(this.diggingX, this.diggingY, this.diggingZ) : null;
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
    }

    @Override
    public boolean isProgramApplicable(ProgWidgetType widgetType) {
        return !BLACKLISTED_WIDGETS.contains(widgetType.getRegistryName());
    }

    @Override
    public GoalSelector getTargetAI() {
        return null;
    }

    @Override
    public void setEmittingRedstone(Direction orientation, int emittingRedstone) {
        this.redstoneLevels[orientation.ordinal()] = emittingRedstone;
        this.updateNeighbours();
    }

    public int getEmittingRedstone(Direction direction) {
        return this.redstoneLevels[direction.ordinal()];
    }

    @Override
    public void setName(ITextComponent name) {
        ItemStack stack;
        if (this.drone != null) {
            this.drone.func_200203_b(name);
        }
        if (!(stack = this.inventory.getStackInSlot(0).func_77946_l()).func_190926_b()) {
            stack.func_200302_a(name);
            this.inventory.setStackInSlot(0, stack);
        }
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        Log.warning("Drone AI setting carrying entity. However a Programmable Controller can't carry entities!", new Object[0]);
        new Throwable().printStackTrace();
    }

    @Override
    public List<Entity> getCarryingEntities() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAIOverriden() {
        return false;
    }

    @Override
    public void onItemPickupEvent(ItemEntity curPickingUpEntity, int stackSize) {
    }

    @Override
    public PlayerEntity getOwner() {
        if (this.ownerID == null) {
            return null;
        }
        if (this.func_145831_w().field_72995_K) {
            return ClientUtils.getClientPlayer();
        }
        return PneumaticCraftUtils.getPlayerFromId(this.ownerID);
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        NetworkHandler.sendToAllAround(new PacketSpawnParticle((IParticleData)ParticleTypes.field_197601_L, (double)this.func_174877_v().func_177958_n() - 0.5, this.func_174877_v().func_177956_o() + 1, (double)this.func_174877_v().func_177952_p() - 0.5, 0.0, 0.0, 0.0, 10, 1.0, 1.0, 1.0), this.func_145831_w());
    }

    @Override
    public DroneAIManager getAIManager() {
        if (!this.func_145831_w().field_72995_K && this.aiManager == null) {
            this.aiManager = new DroneAIManager(this, new ArrayList<IProgWidget>());
            this.aiManager.dontStopWhenEndReached();
        }
        return this.aiManager;
    }

    @Override
    public void updateLabel() {
    }

    @Override
    public void addDebugEntry(String message) {
    }

    @Override
    public void addDebugEntry(String message, BlockPos pos) {
    }

    @Override
    public LogisticsManager getLogisticsManager() {
        return this.logisticsManager;
    }

    @Override
    public void setLogisticsManager(LogisticsManager logisticsManager) {
        this.logisticsManager = logisticsManager;
    }

    private class ProgrammableItemStackHandler
    extends BaseItemStackHandler {
        ProgrammableItemStackHandler(TileEntity te) {
            super(te, 1);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ItemStack stack = this.getStackInSlot(slot);
            TileEntityProgrammableController.this.progWidgets.clear();
            if (!stack.func_190926_b() && TileEntityProgrammableController.isProgrammableAndValidForDrone(TileEntityProgrammableController.this, stack)) {
                TileEntityProgrammableController.this.progWidgets.addAll(TileEntityProgrammer.getProgWidgets(stack));
                TileEntityProgrammer.updatePuzzleConnections(TileEntityProgrammableController.this.progWidgets);
                TileEntityProgrammableController.this.isIdle = false;
            } else {
                TileEntityProgrammableController.this.setDugBlock(null);
                TileEntityProgrammableController.this.targetX = (double)TileEntityProgrammableController.this.func_174877_v().func_177958_n() + 0.5;
                TileEntityProgrammableController.this.targetY = (double)TileEntityProgrammableController.this.func_174877_v().func_177956_o() + 1.0;
                TileEntityProgrammableController.this.targetZ = (double)TileEntityProgrammableController.this.func_174877_v().func_177952_p() + 0.5;
                boolean updateNeighbours = false;
                for (int i = 0; i < TileEntityProgrammableController.this.redstoneLevels.length; ++i) {
                    if (TileEntityProgrammableController.this.redstoneLevels[i] <= 0) continue;
                    ((TileEntityProgrammableController)TileEntityProgrammableController.this).redstoneLevels[i] = 0;
                    updateNeighbours = true;
                }
                if (updateNeighbours) {
                    TileEntityProgrammableController.this.updateNeighbours();
                }
                TileEntityProgrammableController.this.isIdle = true;
            }
            if (!TileEntityProgrammableController.this.func_145831_w().field_72995_K) {
                TileEntityProgrammableController.this.getAIManager().setWidgets(TileEntityProgrammableController.this.progWidgets);
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || TileEntityProgrammableController.isProgrammableAndValidForDrone(TileEntityProgrammableController.this, itemStack);
        }
    }
}

