/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.items.IItemHandler;

public class TileEntityAphorismTile
extends TileEntityBase {
    public static final String NBT_BORDER_COLOR = "borderColor";
    public static final String NBT_BACKGROUND_COLOR = "backgroundColor";
    private static final String NBT_TEXT_ROTATION = "textRot";
    public static final String NBT_TEXT_LINES = "lines";
    private String[] textLines = new String[]{""};
    public int textRotation;
    private int borderColor = DyeColor.BLUE.func_196059_a();
    private int backgroundColor = DyeColor.WHITE.func_196059_a();
    private int maxLineWidth = -1;

    public TileEntityAphorismTile() {
        super((TileEntityType)ModTileEntities.APHORISM_TILE.get());
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    @Override
    public void serializeExtraItemData(CompoundNBT blockEntityTag) {
        this.writeToPacket(blockEntityTag);
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        CompoundNBT subTag = new CompoundNBT();
        subTag.func_218657_a(NBT_TEXT_LINES, (INBT)Arrays.stream(this.textLines).map(StringNBT::func_229705_a_).collect(Collectors.toCollection(ListNBT::new)));
        subTag.func_74768_a(NBT_TEXT_ROTATION, this.textRotation);
        subTag.func_74768_a(NBT_BORDER_COLOR, this.borderColor);
        subTag.func_74768_a(NBT_BACKGROUND_COLOR, this.backgroundColor);
        tag.func_218657_a("ExtraData", (INBT)subTag);
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        if (tag.func_74764_b("ExtraData")) {
            CompoundNBT subTag = tag.func_74775_l("ExtraData");
            ListNBT l = subTag.func_150295_c(NBT_TEXT_LINES, 8);
            if (l.isEmpty()) {
                this.textLines = new String[]{""};
            } else {
                this.textLines = new String[l.size()];
                IntStream.range(0, this.textLines.length).forEach(i -> {
                    this.textLines[i] = l.func_150307_f(i);
                });
            }
            this.textRotation = subTag.func_74762_e(NBT_TEXT_ROTATION);
            if (subTag.func_74764_b(NBT_BORDER_COLOR)) {
                this.borderColor = subTag.func_74762_e(NBT_BORDER_COLOR);
                this.backgroundColor = subTag.func_74762_e(NBT_BACKGROUND_COLOR);
            } else {
                this.borderColor = DyeColor.BLUE.func_196059_a();
                this.backgroundColor = DyeColor.WHITE.func_196059_a();
            }
            if (this.field_145850_b != null) {
                this.rerenderTileEntity();
            }
        }
    }

    public String[] getTextLines() {
        return this.textLines;
    }

    public void setTextLines(String[] textLines) {
        this.setTextLines(textLines, true);
    }

    public void setTextLines(String[] textLines, boolean notifyClient) {
        this.textLines = textLines;
        this.maxLineWidth = -1;
        if (!this.field_145850_b.field_72995_K && notifyClient) {
            this.sendDescriptionPacket();
        }
    }

    public void setBorderColor(int color) {
        this.borderColor = color;
        if (!this.field_145850_b.field_72995_K) {
            this.sendDescriptionPacket();
        }
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        if (!this.field_145850_b.field_72995_K) {
            this.sendDescriptionPacket();
        }
    }

    public int getMaxLineWidth() {
        if (this.maxLineWidth < 0) {
            for (String line : this.textLines) {
                int stringWidth = ClientUtils.getStringWidth(line);
                if (stringWidth <= this.maxLineWidth) continue;
                this.maxLineWidth = stringWidth;
            }
            this.maxLineWidth = (int)((double)this.maxLineWidth * 1.05);
        }
        return this.maxLineWidth;
    }
}

