/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.gui.GuiAmadronAddTrade;
import me.desht.pneumaticcraft.client.gui.GuiAssemblyController;
import me.desht.pneumaticcraft.client.gui.GuiPressureChamber;
import me.desht.pneumaticcraft.client.gui.GuiRefineryController;
import me.desht.pneumaticcraft.client.gui.GuiThermopneumaticProcessingPlant;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetItemFilter;
import me.desht.pneumaticcraft.client.gui.semiblock.GuiLogisticsBase;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.thirdparty.jei.GuiTabHandler;
import me.desht.pneumaticcraft.common.thirdparty.jei.Helpers;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIAmadronTradeCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIAssemblyControllerCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIEtchingTankCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIExplosionCraftingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIHeatFrameCoolingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlasticSolidifyingCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPressureChamberRecipeCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIRefineryCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIThermopneumaticProcessingPlantCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIUVLightBoxCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.thirdparty.jei.ghost.AmadronAddTradeGhost;
import me.desht.pneumaticcraft.common.thirdparty.jei.ghost.LogisticsFilterGhost;
import me.desht.pneumaticcraft.common.thirdparty.jei.ghost.ProgWidgetItemFilterGhost;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUVLightBox;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    static IJeiHelpers jeiHelpers;

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (RegistryObject item : ModItems.ITEMS.getEntries()) {
            if (!(item.get() instanceof ItemPressurizable)) continue;
            registration.registerSubtypeInterpreter((Item)item.get(), s -> (String)s.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h2 -> String.valueOf(h2.getPressure())).orElse((Object)""));
        }
        registration.registerSubtypeInterpreter((Item)ModItems.EMPTY_PCB.get(), s -> String.valueOf(TileEntityUVLightBox.getExposureProgress(s)));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new JEIPressureChamberRecipeCategory(), new JEIAssemblyControllerCategory(), new JEIThermopneumaticProcessingPlantCategory(), new JEIRefineryCategory(), new JEIUVLightBoxCategory(), new JEIAmadronTradeCategory(), new JEIHeatFrameCoolingCategory(), new JEIPlasticSolidifyingCategory(), new JEIEtchingTankCategory()});
        if (PNCConfig.Common.Recipes.explosionCrafting) {
            registry.addRecipeCategories(new IRecipeCategory[]{new JEIExplosionCraftingCategory()});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.addRecipeType(registration, PneumaticCraftRecipeType.PRESSURE_CHAMBER, ModCategoryUid.PRESSURE_CHAMBER);
        this.addRecipeType(registration, PneumaticCraftRecipeType.EXPLOSION_CRAFTING, ModCategoryUid.EXPLOSION_CRAFTING);
        this.addRecipeType(registration, PneumaticCraftRecipeType.HEAT_FRAME_COOLING, ModCategoryUid.HEAT_FRAME_COOLING);
        this.addRecipeType(registration, PneumaticCraftRecipeType.REFINERY, ModCategoryUid.REFINERY);
        this.addRecipeType(registration, PneumaticCraftRecipeType.THERMO_PLANT, ModCategoryUid.THERMO_PLANT);
        this.addRecipeType(registration, PneumaticCraftRecipeType.ASSEMBLY_LASER, ModCategoryUid.ASSEMBLY_CONTROLLER);
        this.addRecipeType(registration, PneumaticCraftRecipeType.ASSEMBLY_DRILL, ModCategoryUid.ASSEMBLY_CONTROLLER);
        this.addRecipeType(registration, PneumaticCraftRecipeType.ASSEMBLY_DRILL_LASER, ModCategoryUid.ASSEMBLY_CONTROLLER);
        this.addRecipeType(registration, PneumaticCraftRecipeType.AMADRON_OFFERS, ModCategoryUid.AMADRON_TRADE);
        registration.addRecipes(JEIUVLightBoxCategory.getAllRecipes(), ModCategoryUid.UV_LIGHT_BOX);
        registration.addRecipes(JEIPlasticSolidifyingCategory.getAllRecipes(), ModCategoryUid.PLASTIC_SOLIDIFYING);
        registration.addRecipes(JEIEtchingTankCategory.getAllRecipes(), ModCategoryUid.ETCHING_TANK);
        for (RegistryObject item : ModItems.ITEMS.getEntries()) {
            this.addStackInfo(registration, new ItemStack((IItemProvider)item.get()));
        }
    }

    private void addRecipeType(IRecipeRegistration registration, PneumaticCraftRecipeType type, ResourceLocation id) {
        registration.addRecipes(type.getRecipes((World)Minecraft.func_71410_x().field_71441_e).values(), id);
    }

    private void addStackInfo(IRecipeRegistration registry, ItemStack stack) {
        String k = ICustomTooltipName.getTranslationKey(stack);
        if (I18n.func_188566_a((String)k)) {
            String raw = TextFormatting.func_110646_a((String)I18n.func_135052_a((String)k, (Object[])new Object[0]));
            registry.addIngredientInfo((Object)stack, VanillaTypes.ITEM, raw.split(" \\\\n"));
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.AMADRON_TABLET.get()), new ResourceLocation[]{ModCategoryUid.AMADRON_TRADE});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ASSEMBLY_CONTROLLER.get()), new ResourceLocation[]{ModCategoryUid.ASSEMBLY_CONTROLLER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_WALL.get()), new ResourceLocation[]{ModCategoryUid.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_VALVE.get()), new ResourceLocation[]{ModCategoryUid.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()), new ResourceLocation[]{ModCategoryUid.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_GLASS.get()), new ResourceLocation[]{ModCategoryUid.PRESSURE_CHAMBER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.REFINERY.get()), new ResourceLocation[]{ModCategoryUid.REFINERY});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.REFINERY_OUTPUT.get()), new ResourceLocation[]{ModCategoryUid.REFINERY});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()), new ResourceLocation[]{ModCategoryUid.THERMO_PLANT});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.UV_LIGHT_BOX.get()), new ResourceLocation[]{ModCategoryUid.UV_LIGHT_BOX});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.HEAT_FRAME.get()), new ResourceLocation[]{ModCategoryUid.HEAT_FRAME_COOLING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ETCHING_TANK.get()), new ResourceLocation[]{ModCategoryUid.ETCHING_TANK});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(GuiAssemblyController.class, 110, 10, 50, 50, new ResourceLocation[]{ModCategoryUid.ASSEMBLY_CONTROLLER});
        registration.addRecipeClickArea(GuiPressureChamber.class, 100, 7, 60, 60, new ResourceLocation[]{ModCategoryUid.PRESSURE_CHAMBER});
        registration.addRecipeClickArea(GuiRefineryController.class, 47, 33, 27, 47, new ResourceLocation[]{ModCategoryUid.REFINERY});
        registration.addRecipeClickArea(GuiThermopneumaticProcessingPlant.class, 30, 31, 48, 20, new ResourceLocation[]{ModCategoryUid.THERMO_PLANT});
        registration.addGlobalGuiHandler((IGlobalGuiHandler)new GuiTabHandler());
        registration.addGuiScreenHandler(GuiProgWidgetItemFilter.class, Helpers::getGuiProperties);
        registration.addGhostIngredientHandler(GuiAmadronAddTrade.class, (IGhostIngredientHandler)new AmadronAddTradeGhost());
        registration.addGhostIngredientHandler(GuiLogisticsBase.class, (IGhostIngredientHandler)new LogisticsFilterGhost());
        registration.addGhostIngredientHandler(GuiProgWidgetItemFilter.class, (IGhostIngredientHandler)new ProgWidgetItemFilterGhost());
    }

    public ResourceLocation getPluginUid() {
        return PneumaticCraftUtils.RL("default");
    }
}

