/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIPlace;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetDigAndPlace;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ProgWidgetPlace
extends ProgWidgetDigAndPlace
implements ISidedWidget {
    public Direction placeDir = Direction.DOWN;

    public ProgWidgetPlace() {
        super(ModProgWidgets.PLACE, IBlockOrdered.EnumOrder.LOW_TO_HIGH);
    }

    ProgWidgetPlace(ProgWidgetType<?> type) {
        super(type, IBlockOrdered.EnumOrder.LOW_TO_HIGH);
    }

    @Override
    public void setSides(boolean[] sides) {
        this.placeDir = ProgWidgetPlace.getDirForSides(sides);
    }

    @Override
    public boolean[] getSides() {
        return ProgWidgetPlace.getSidesFromDir(this.placeDir);
    }

    public static Direction getDirForSides(boolean[] sides) {
        for (int i = 0; i < sides.length; ++i) {
            if (!sides[i]) continue;
            return Direction.func_82600_a((int)i);
        }
        Log.error("[ProgWidgetPlace] Sides boolean array empty!", new Object[0]);
        return Direction.DOWN;
    }

    private static boolean[] getSidesFromDir(Direction dir) {
        boolean[] dirs = new boolean[6];
        dirs[dir.ordinal()] = true;
        return dirs;
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((ITextComponent)new StringTextComponent("Placing direction: " + PneumaticCraftUtils.getOrientationName(this.placeDir)));
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_PLACE;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIPlace(drone, (ProgWidgetPlace)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("dir", this.placeDir.ordinal());
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.placeDir = Direction.func_82600_a((int)tag.func_74762_e("dir"));
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeByte(this.placeDir.ordinal());
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.placeDir = Direction.values()[buf.readByte()];
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.YELLOW;
    }
}

