/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ProgWidgetLiquidFilter
extends ProgWidget {
    private Fluid fluid = Fluids.field_204541_a;

    public ProgWidgetLiquidFilter() {
        super(ModProgWidgets.LIQUID_FILTER);
    }

    public static ProgWidgetLiquidFilter withFilter(Fluid fluid) {
        ProgWidgetLiquidFilter f = new ProgWidgetLiquidFilter();
        f.setFluid(fluid);
        return f;
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.fluid == Fluids.field_204541_a) {
            curInfo.add(PneumaticCraftUtils.xlate("gui.progWidget.liquidFilter.error.noLiquid", new Object[0]));
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType returnType() {
        return ModProgWidgets.LIQUID_FILTER;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.LIQUID_FILTER);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_LIQUID_FILTER;
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.fluid = tag.func_74764_b("fluid") ? (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.func_74779_i("fluid"))) : Fluids.field_204541_a;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        if (this.fluid != Fluids.field_204541_a) {
            tag.func_74778_a("fluid", this.fluid.getRegistryName().toString());
        }
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeFluidStack(new FluidStack(this.fluid, 1000));
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.fluid = buf.readFluidStack().getFluid();
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.fluid != null) {
            curTooltip.add(new StringTextComponent("Fluid: ").func_211708_a(TextFormatting.AQUA).func_150258_a(this.getExtraStringInfo()).func_211708_a(TextFormatting.WHITE));
        }
    }

    private boolean isLiquidValid(Fluid fluid) {
        return this.fluid == null || fluid == this.fluid;
    }

    static boolean isLiquidValid(Fluid fluid, IProgWidget mainWidget, int filterIndex) {
        ProgWidgetLiquidFilter widget = (ProgWidgetLiquidFilter)mainWidget.getConnectedParameters()[mainWidget.getParameters().size() + filterIndex];
        while (widget != null) {
            if (!widget.isLiquidValid(fluid)) {
                return false;
            }
            widget = (ProgWidgetLiquidFilter)widget.getConnectedParameters()[0];
        }
        widget = (ProgWidgetLiquidFilter)mainWidget.getConnectedParameters()[filterIndex];
        if (widget == null) {
            return true;
        }
        while (widget != null) {
            if (widget.isLiquidValid(fluid)) {
                return true;
            }
            widget = (ProgWidgetLiquidFilter)widget.getConnectedParameters()[0];
        }
        return false;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public String getExtraStringInfo() {
        return this.fluid != Fluids.field_204541_a ? new FluidStack(this.fluid, 1).getDisplayName().func_150254_d() : I18n.func_135052_a((String)"gui.progWidget.liquidFilter.noFluid", (Object[])new Object[0]);
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.RED;
    }
}

