/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.ILargePayload;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketProgrammerUpdate
extends LocationIntPacket
implements ILargePayload {
    private List<IProgWidget> widgets;
    private TileEntityProgrammer te;

    public PacketProgrammerUpdate() {
    }

    public PacketProgrammerUpdate(TileEntityProgrammer te) {
        super(te.func_174877_v());
        this.te = te;
    }

    public PacketProgrammerUpdate(PacketBuffer buffer) {
        super(buffer);
        this.widgets = TileEntityProgrammer.readWidgetsFromPacket(buffer);
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        this.te.writeProgWidgetsToPacket(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.updateTE((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender()));
        ctx.get().setPacketHandled(true);
    }

    private void updateTE(PlayerEntity player) {
        World world = player == null ? ClientUtils.getClientWorld() : player.field_70170_p;
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof TileEntityProgrammer) {
            ((TileEntityProgrammer)te).setProgWidgets(this.widgets, player);
        }
    }

    @Override
    public PacketBuffer dumpToBuffer() {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        this.toBytes(buf);
        return buf;
    }

    @Override
    public void handleLargePayload(PlayerEntity player) {
        this.updateTE(player);
    }
}

