/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class HackableEnderman
implements IHackableEntity {
    @Override
    public ResourceLocation getHackableId() {
        return PneumaticCraftUtils.RL("enderman");
    }

    @Override
    public boolean canHack(Entity entity, PlayerEntity player) {
        return HackableEnderman.onEndermanTeleport(entity);
    }

    @Override
    public void addHackInfo(Entity entity, List<String> curInfo, PlayerEntity player) {
        curInfo.add("pneumaticHelmet.hacking.result.stopTeleport");
    }

    @Override
    public void addPostHackInfo(Entity entity, List<String> curInfo, PlayerEntity player) {
        curInfo.add("pneumaticHelmet.hacking.finished.stopTeleporting");
    }

    @Override
    public int getHackTime(Entity entity, PlayerEntity player) {
        return 60;
    }

    @Override
    public void onHackFinished(Entity entity, PlayerEntity player) {
    }

    @Override
    public boolean afterHackTick(Entity entity) {
        return true;
    }

    public static boolean onEndermanTeleport(Entity entity) {
        List<IHackableEntity> hacks = PneumaticRegistry.getInstance().getHelmetRegistry().getCurrentEntityHacks(entity);
        for (IHackableEntity hack : hacks) {
            if (!(hack instanceof HackableEnderman)) continue;
            return false;
        }
        return true;
    }
}

