/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.AirConUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.ChargingUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.ChestplateLauncherHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.CoordTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JetBootsUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JumpBoostUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.KickUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.MagnetUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.MainHelmetHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.NightVisionUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.RunSpeedUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.ScubaUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.SearchUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.StepAssistUpgradeHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;

public enum UpgradeRenderHandlerList {
    INSTANCE;

    private final List<List<IUpgradeRenderHandler>> upgradeRenderers;
    private final Map<Class<? extends IUpgradeRenderHandler>, IUpgradeRenderHandler> classMap = new HashMap<Class<? extends IUpgradeRenderHandler>, IUpgradeRenderHandler>();
    public static final EquipmentSlotType[] ARMOR_SLOTS;

    public static UpgradeRenderHandlerList instance() {
        return INSTANCE;
    }

    private UpgradeRenderHandlerList() {
        this.upgradeRenderers = new ArrayList<List<IUpgradeRenderHandler>>(4);
        for (int i = 0; i < 4; ++i) {
            this.upgradeRenderers.add(new ArrayList());
        }
        this.addUpgradeRenderer(new MainHelmetHandler());
        this.addUpgradeRenderer(new BlockTrackUpgradeHandler());
        this.addUpgradeRenderer(new EntityTrackUpgradeHandler());
        this.addUpgradeRenderer(new SearchUpgradeHandler());
        this.addUpgradeRenderer(new CoordTrackUpgradeHandler());
        this.addUpgradeRenderer(new DroneDebugUpgradeHandler());
        this.addUpgradeRenderer(new NightVisionUpgradeHandler());
        this.addUpgradeRenderer(new ScubaUpgradeHandler());
        this.addUpgradeRenderer(new MagnetUpgradeHandler());
        this.addUpgradeRenderer(new ChargingUpgradeHandler());
        this.addUpgradeRenderer(new ChestplateLauncherHandler());
        this.addUpgradeRenderer(new AirConUpgradeHandler());
        this.addUpgradeRenderer(new RunSpeedUpgradeHandler());
        this.addUpgradeRenderer(new JumpBoostUpgradeHandler());
        this.addUpgradeRenderer(new JetBootsUpgradeHandler());
        this.addUpgradeRenderer(new StepAssistUpgradeHandler());
        this.addUpgradeRenderer(new KickUpgradeHandler());
    }

    public void refreshConfig() {
        for (EquipmentSlotType slot : ARMOR_SLOTS) {
            for (IUpgradeRenderHandler renderHandler : this.getHandlersForSlot(slot)) {
                renderHandler.initConfig();
            }
        }
    }

    void addUpgradeRenderer(IUpgradeRenderHandler handler) {
        this.upgradeRenderers.get(handler.getEquipmentSlot().func_188454_b()).add(handler);
        this.classMap.put(handler.getClass(), handler);
    }

    <T extends IUpgradeRenderHandler> T getRenderHandler(Class<T> clazz) {
        return (T)this.classMap.get(clazz);
    }

    public List<IUpgradeRenderHandler> getHandlersForSlot(EquipmentSlotType slot) {
        return this.upgradeRenderers.get(slot.func_188454_b());
    }

    public float getAirUsage(PlayerEntity player, EquipmentSlotType slot, boolean countDisabled) {
        float totalUsage = 0.0f;
        for (int i = 0; i < this.upgradeRenderers.get(slot.func_188454_b()).size(); ++i) {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            if (!handler.isUpgradeRendererInserted(slot, i) || !countDisabled && !handler.isUpgradeRendererEnabled(slot, i)) continue;
            totalUsage += this.upgradeRenderers.get(slot.func_188454_b()).get(i).getEnergyUsage(handler.getUpgradeCount(slot, EnumUpgrade.RANGE), player);
        }
        return totalUsage;
    }

    static {
        ARMOR_SLOTS = new EquipmentSlotType[4];
        UpgradeRenderHandlerList.ARMOR_SLOTS[0] = EquipmentSlotType.HEAD;
        UpgradeRenderHandlerList.ARMOR_SLOTS[1] = EquipmentSlotType.CHEST;
        UpgradeRenderHandlerList.ARMOR_SLOTS[2] = EquipmentSlotType.LEGS;
        UpgradeRenderHandlerList.ARMOR_SLOTS[3] = EquipmentSlotType.FEET;
    }
}

