/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote.actionwidget;

import me.desht.pneumaticcraft.client.gui.GuiRemoteEditor;
import me.desht.pneumaticcraft.client.gui.remote.GuiRemoteDropdown;
import me.desht.pneumaticcraft.client.gui.remote.actionwidget.ActionWidgetVariable;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.text.WordUtils;

public class ActionWidgetDropdown
extends ActionWidgetVariable<WidgetComboBox> {
    private int x;
    private int y;
    private int width;
    private int height;
    private String dropDownElements = "";
    private String selectedElement = "";
    private boolean sorted;

    public ActionWidgetDropdown() {
    }

    public ActionWidgetDropdown(WidgetComboBox widget) {
        super(widget);
        this.x = widget.x;
        this.y = widget.y;
        this.width = widget.getWidth();
        this.height = widget.getHeight();
        widget.func_146180_a(I18n.func_135052_a((String)"gui.remote.tray.dropdown.name", (Object[])new Object[0]));
        widget.setTooltip(WordUtils.wrap((String)I18n.func_135052_a((String)"gui.remote.tray.dropdown.tooltip", (Object[])new Object[0]), (int)50).split(System.getProperty("line.separator")));
    }

    @Override
    public void readFromNBT(CompoundNBT tag, int guiLeft, int guiTop) {
        super.readFromNBT(tag, guiLeft, guiTop);
        this.x = tag.func_74762_e("x") + guiLeft;
        this.y = tag.func_74762_e("y") + guiTop;
        this.width = tag.func_74762_e("width");
        this.height = tag.func_74762_e("height");
        this.dropDownElements = tag.func_74779_i("dropDownElements");
        this.sorted = tag.func_74767_n("sorted");
        this.updateWidget();
    }

    @Override
    public CompoundNBT toNBT(int guiLeft, int guiTop) {
        CompoundNBT tag = super.toNBT(guiLeft, guiTop);
        tag.func_74768_a("x", this.x - guiLeft);
        tag.func_74768_a("y", this.y - guiTop);
        tag.func_74768_a("width", this.width);
        tag.func_74768_a("height", this.height);
        tag.func_74778_a("dropDownElements", this.dropDownElements);
        tag.func_74757_a("sorted", this.sorted);
        return tag;
    }

    @Override
    public String getId() {
        return "dropdown";
    }

    @Override
    public void onKeyTyped() {
        String[] elements = this.getDropdownElements();
        this.selectedElement = this.getWidget().func_146179_b();
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].equals(this.selectedElement)) continue;
            NetworkHandler.sendToServer(new PacketSetGlobalVariable(this.getVariableName(), i));
            break;
        }
    }

    @Override
    public void onVariableChange() {
        this.updateWidget();
    }

    @Override
    public void setWidgetPos(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateWidget();
    }

    @Override
    public WidgetComboBox getWidget() {
        if (this.widget == null) {
            this.widget = new WidgetComboBox(Minecraft.func_71410_x().field_71466_p, this.x, this.y, this.width, this.height, this::onPressed);
            ((WidgetComboBox)this.widget).setElements(this.getDropdownElements());
            ((WidgetComboBox)this.widget).setFixedOptions();
            ((WidgetComboBox)this.widget).setShouldSort(this.sorted);
            this.updateWidget();
        }
        return (WidgetComboBox)this.widget;
    }

    private void onPressed(WidgetComboBox comboBox) {
        if (comboBox.getSelectedElementIndex() >= 0) {
            NetworkHandler.sendToServer(new PacketSetGlobalVariable(this.getVariableName(), comboBox.getSelectedElementIndex()));
        }
    }

    private String[] getDropdownElements() {
        return this.dropDownElements.split(",");
    }

    private void updateWidget() {
        String[] elements = this.getDropdownElements();
        this.selectedElement = elements[MathHelper.func_76125_a((int)GlobalVariableManager.getInstance().getInteger(this.getVariableName()), (int)0, (int)(elements.length - 1))];
        if (this.widget != null) {
            ((WidgetComboBox)this.widget).x = this.x;
            ((WidgetComboBox)this.widget).y = this.y;
            ((WidgetComboBox)this.widget).setWidth(this.width);
            ((WidgetComboBox)this.widget).setHeight(this.height);
            ((WidgetComboBox)this.widget).setElements(this.getDropdownElements());
            ((WidgetComboBox)this.widget).func_146180_a(this.selectedElement);
            ((WidgetComboBox)this.widget).setShouldSort(this.sorted);
        }
    }

    @Override
    public void onActionPerformed() {
    }

    public void setDropDownElements(String dropDownElements) {
        this.dropDownElements = dropDownElements;
        this.updateWidget();
    }

    public String getDropDownElements() {
        return this.dropDownElements;
    }

    public boolean getSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public void setWidth(int width) {
        this.width = width;
        this.updateWidget();
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen getGui(GuiRemoteEditor guiRemote) {
        return new GuiRemoteDropdown(this, guiRemote);
    }
}

