/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetList;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerTagWorkbench;
import me.desht.pneumaticcraft.common.item.ItemTagFilter;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTagWorkbench;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiTagWorkbench
extends GuiPneumaticContainerBase<ContainerTagWorkbench, TileEntityTagWorkbench> {
    private static final int AVAILABLE_X = 9;
    private static final int SELECTED_X = 123;
    private static final int LIST_HEIGHT = 126;
    private static final int LIST_WIDTH = 98;
    private static final int LIST_Y = 41;
    private Item lastItem = null;
    private ItemStack lastPaperStack = ItemStack.field_190927_a;
    private WidgetButtonExtended addButton;
    private WidgetButtonExtended removeButton;
    private WidgetList<ResourceLocation> availableList;
    private WidgetList<ResourceLocation> selectedList;
    private WidgetButtonExtended writeButton;

    public GuiTagWorkbench(ContainerTagWorkbench container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_146999_f = 234;
        this.field_147000_g = 256;
    }

    @Override
    public void init() {
        super.init();
        this.writeButton = new WidgetButtonExtended(this.field_147003_i + 162, this.field_147009_r + 16, 20, 20, "", b -> this.writeTags()).setRenderStacks(new ItemStack((IItemProvider)Items.field_151099_bA)).setTooltipText(I18n.func_135052_a((String)"gui.tooltip.tag_workbench.write_button", (Object[])new Object[0]));
        this.addButton((Widget)this.writeButton);
        this.addButton = new WidgetButtonExtended(this.field_147003_i + 108, this.field_147009_r + 90, 13, 13, "\u25b6", b -> this.addAvailable());
        this.addButton((Widget)this.addButton);
        this.removeButton = new WidgetButtonExtended(this.field_147003_i + 108, this.field_147009_r + 106, 13, 13, "\u25c0", b -> this.removeSelected());
        this.addButton((Widget)this.removeButton);
        this.availableList = new WidgetList(this.field_147003_i + 9, this.field_147009_r + 41, 98, 126, this::onSelected);
        this.addButton(this.availableList);
        this.selectedList = new WidgetList(this.field_147003_i + 123, this.field_147009_r + 41, 98, 126, this::onSelected);
        this.addButton(this.selectedList);
    }

    private void writeTags() {
        List l = this.selectedList.getLines().stream().map(ResourceLocation::toString).collect(Collectors.toList());
        NetworkHandler.sendToServer(new PacketGuiButton("write:" + String.join((CharSequence)",", l)));
        this.selectedList.clear();
    }

    private void onSelected(WidgetList<ResourceLocation> w) {
        if (w == this.availableList) {
            this.selectedList.unselectAll();
            if (w.isDoubleClicked()) {
                this.addAvailable();
            }
        } else if (w == this.selectedList) {
            this.availableList.unselectAll();
            if (w.isDoubleClicked()) {
                this.removeSelected();
            }
        }
    }

    private void addAvailable() {
        ResourceLocation rl = this.availableList.getSelectedLine();
        if (rl != null && !this.selectedList.contains(rl)) {
            this.selectedList.add(rl);
        }
    }

    private void removeSelected() {
        ResourceLocation rl = this.selectedList.getSelectedLine();
        if (rl != null) {
            this.selectedList.removeSelected();
        }
    }

    @Override
    public void tick() {
        ItemStack stack1;
        super.tick();
        ItemStack stack = ((ContainerTagWorkbench)this.field_147002_h).func_75139_a(0).func_75211_c();
        if (stack.func_77973_b() != this.lastItem) {
            this.availableList.clear();
            stack.func_77973_b().getTags().forEach(rl -> this.availableList.add((ResourceLocation)rl));
            this.availableList.unselectAll();
            this.lastItem = stack.func_77973_b();
        }
        if (!ItemStack.func_77989_b((ItemStack)(stack1 = ((ContainerTagWorkbench)this.field_147002_h).func_75139_a(1).func_75211_c()), (ItemStack)this.lastPaperStack)) {
            if (stack1.func_77973_b() == ModItems.TAG_FILTER.get()) {
                Set<ResourceLocation> s = ItemTagFilter.getConfiguredTagList(stack1);
                s.addAll(this.selectedList.getLines());
                this.selectedList.clear();
                s.forEach(rl -> this.selectedList.add((ResourceLocation)rl));
            }
            this.selectedList.unselectAll();
            this.lastPaperStack = stack1.func_77946_l();
        }
        this.addButton.active = this.availableList.getSelectedLine() != null;
        this.removeButton.active = this.selectedList.getSelectedLine() != null;
        this.writeButton.active = this.selectedList.size() > 0 && (!((ContainerTagWorkbench)this.field_147002_h).func_75139_a(1).func_75211_c().func_190926_b() || !((ContainerTagWorkbench)this.field_147002_h).func_75139_a(2).func_75211_c().func_190926_b());
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_TAG_WORKBENCH;
    }
}

