/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import me.desht.modularrouters.client.gui.module.GuiModule;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.container.ContainerModule;
import me.desht.modularrouters.logic.compiled.CompiledDistributorModule;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class GuiModuleDistributor
extends GuiModule {
    private StrategyButton sb;

    public GuiModuleDistributor(ContainerModule container, PlayerInventory inv, ITextComponent displayText) {
        super(container, inv, displayText);
    }

    @Override
    public void init() {
        super.init();
        CompiledDistributorModule cdm = new CompiledDistributorModule(null, this.moduleItemStack);
        this.addButton((Widget)new TooltipButton(this.field_147003_i + 130, this.field_147009_r + 23));
        this.sb = new StrategyButton(this.field_147003_i + 147, this.field_147009_r + 23, 16, 16, cdm.getDistributionStrategy());
        this.addButton((Widget)this.sb);
        this.getMouseOverHelp().addHelpRegion(this.field_147003_i + 128, this.field_147009_r + 21, this.field_147003_i + 165, this.field_147009_r + 41, "guiText.popup.distributor.strategy");
    }

    @Override
    protected CompoundNBT buildMessageData() {
        CompoundNBT tag = super.buildMessageData();
        tag.func_74768_a("DistStrategy", ((CompiledDistributorModule.DistributionStrategy)((Object)this.sb.getState())).ordinal());
        return tag;
    }

    private class TooltipButton
    extends TexturedButton {
        TooltipButton(int x, int y) {
            super(x, y, 16, 16, p -> {});
            this.tooltip1.add(I18n.func_135052_a((String)"guiText.tooltip.distributor.strategy", (Object[])new Object[0]));
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        public void playDownSound(SoundHandler soundHandlerIn) {
        }

        @Override
        protected int getTextureX() {
            return 176;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }
    }

    private class StrategyButton
    extends TexturedCyclerButton<CompiledDistributorModule.DistributionStrategy> {
        private final List<List<String>> tooltips;

        StrategyButton(int x, int y, int width, int height, CompiledDistributorModule.DistributionStrategy initialVal) {
            super(x, y, width, height, initialVal, GuiModuleDistributor.this);
            this.tooltips = Lists.newArrayList();
            for (CompiledDistributorModule.DistributionStrategy strategy : CompiledDistributorModule.DistributionStrategy.values()) {
                this.tooltips.add(Collections.singletonList(I18n.func_135052_a((String)("itemText.distributor.strategy." + (Object)((Object)strategy)), (Object[])new Object[0])));
            }
        }

        @Override
        protected int getTextureX() {
            return 160 + ((CompiledDistributorModule.DistributionStrategy)((Object)this.getState())).ordinal() * 16;
        }

        @Override
        protected int getTextureY() {
            return 32;
        }

        @Override
        public List<String> getTooltip() {
            return this.tooltips.get(((CompiledDistributorModule.DistributionStrategy)((Object)this.getState())).ordinal());
        }
    }
}

