/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import me.desht.modularrouters.client.gui.IMouseOverHelpProvider;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.Rect;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MouseOverHelp {
    private static final int TEXT_MARGIN = 8;
    private final List<HelpRegion> helpRegions = new ArrayList<HelpRegion>();
    private final ContainerScreen screen;
    private boolean active = false;

    public MouseOverHelp(ContainerScreen screen) {
        this.screen = screen;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, String key) {
        this.addHelpRegion(x1, y1, x2, y2, key, HelpRegion.YES);
    }

    public void addHelpRegion(int x1, int y1, int x2, int y2, String key, Predicate<ContainerScreen> showPredicate) {
        this.helpRegions.add(new HelpRegion(x1, y1, x2, y2, MiscUtil.wrapString(I18n.func_135052_a((String)key, (Object[])new Object[0])), showPredicate));
    }

    private void onMouseOver(int mouseX, int mouseY) {
        HelpRegion region;
        if (this.active && (region = this.getRegionAt(mouseX, mouseY)) != null) {
            MouseOverHelp.showPopupBox(this.screen, Minecraft.func_71410_x().field_71466_p, region.extent, -1073741824, 1614872575, 0, null);
            MouseOverHelp.showPopupBox(this.screen, Minecraft.func_71410_x().field_71466_p, region.extent, -1073741824, -534765536, -2039584, region.text);
        }
    }

    private HelpRegion getRegionAt(int mouseX, int mouseY) {
        for (HelpRegion region : this.helpRegions) {
            if (!region.extent.contains(mouseX, mouseY) || !region.showPredicate.test(this.screen)) continue;
            return region;
        }
        return null;
    }

    private static void showPopupBox(ContainerScreen screen, FontRenderer fontRenderer, Rect rect, int borderColor, int bgColor, int textColor, List<String> helpText) {
        Rect rect2 = new Rect(rect);
        if (helpText != null && !helpText.isEmpty()) {
            int boxWidth = 0;
            int n = helpText.size();
            fontRenderer.getClass();
            int boxHeight = n * 9;
            for (String s : helpText) {
                boxWidth = Math.max(boxWidth, fontRenderer.func_78256_a(s));
            }
            int xOff = rect.x - screen.getGuiLeft() < screen.getXSize() / 2 ? rect.width + 10 : -(boxWidth + 8 + 10);
            int yOff = (rect.height - boxHeight - 8) / 2;
            rect2.setBounds(rect.x + xOff, rect.y + yOff, boxWidth + 8, boxHeight + 8);
        }
        int x1 = rect2.x - screen.getGuiLeft();
        int y1 = rect2.y - screen.getGuiTop();
        int x2 = x1 + rect2.width;
        int y2 = y1 + rect2.height;
        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)300.0f);
        AbstractGui.fill((int)x1, (int)y1, (int)x2, (int)y2, (int)bgColor);
        AbstractGui.fill((int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)borderColor);
        AbstractGui.fill((int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)borderColor);
        AbstractGui.fill((int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)borderColor);
        AbstractGui.fill((int)x2, (int)y1, (int)(x2 + 1), (int)(y2 + 1), (int)borderColor);
        if (helpText != null) {
            for (String s : helpText) {
                fontRenderer.func_211126_b(s, (float)(x1 + 4), (float)(y1 + 4), textColor);
                fontRenderer.getClass();
                y1 += 9;
            }
        }
        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)-300.0f);
    }

    @SubscribeEvent
    public static void drawMouseOver(GuiContainerEvent.DrawForeground event) {
        if (event.getGuiContainer() instanceof IMouseOverHelpProvider) {
            ((IMouseOverHelpProvider)event.getGuiContainer()).getMouseOverHelp().onMouseOver(event.getMouseX(), event.getMouseY());
        }
    }

    public static class Button
    extends TexturedToggleButton {
        private final MouseOverHelp mouseOverHelp;

        public Button(int x, int y, MouseOverHelp mouseOverHelp) {
            super(x, y, 16, 16, false, null);
            this.mouseOverHelp = mouseOverHelp;
            this.tooltip1.addAll(MiscUtil.wrapString(I18n.func_135052_a((String)"guiText.tooltip.mouseOverHelp.false", (Object[])new Object[0])));
            this.tooltip2.addAll(MiscUtil.wrapString(I18n.func_135052_a((String)"guiText.tooltip.mouseOverHelp.true", (Object[])new Object[0])));
        }

        public void onClick(double mouseX, double mouseY) {
            this.toggle();
        }

        @Override
        protected boolean drawStandardBackground() {
            return false;
        }

        @Override
        public boolean sendToServer() {
            return false;
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 208 : 192;
        }

        @Override
        protected int getTextureY() {
            return 0;
        }
    }

    public static class HelpRegion {
        final Rect extent;
        final List<String> text;
        final Predicate<ContainerScreen> showPredicate;
        static final Predicate<ContainerScreen> YES = guiContainer -> true;

        HelpRegion(int x1, int y1, int x2, int y2, List<String> text) {
            this(x1, y1, x2, y2, text, YES);
        }

        HelpRegion(int x1, int y1, int x2, int y2, List<String> text, Predicate<ContainerScreen> showPredicate) {
            this.extent = new Rect(x1, y1, x2 - x1, y2 - y1);
            this.text = text;
            this.showPredicate = showPredicate;
        }
    }
}

