/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet;

import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.TextInClient;
import com.yogpc.qp.packet.IMessage;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClientTextMessage
implements IMessage<ClientTextMessage> {
    private final TextInClient text;
    private final BlockPos pos;
    private final int dim;

    public ClientTextMessage(TextInClient text, BlockPos pos, int dim) {
        this.text = text;
        this.pos = pos;
        this.dim = dim;
    }

    public ClientTextMessage(TextInClient text, BlockPos pos, World world) {
        this(text, pos, IMessage.getDimId(world));
    }

    public ClientTextMessage() {
        this.text = null;
        this.pos = BlockPos.field_177992_a;
        this.dim = 0;
    }

    @Override
    public ClientTextMessage readFromBuffer(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        int dim = buffer.readInt();
        TextInClient textInClient = TextInClient.read(buffer);
        return new ClientTextMessage(textInClient, pos, dim);
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        Objects.requireNonNull(this.text).write(buffer);
    }

    @Override
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        IMessage.findTile(ctx, this.pos, this.dim, APowerTile.class).ifPresent(t -> {
            t.clientText = this.text;
        });
    }
}

