/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.nio.file.Path;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeBlockTagsProvider
extends BlockTagsProvider {
    private Set<ResourceLocation> filter = null;

    public ForgeBlockTagsProvider(DataGenerator gen) {
        super(gen);
    }

    public void func_200432_c() {
        super.func_200432_c();
        this.filter = this.field_200434_b.entrySet().stream().map(e -> ((Tag)e.getKey()).func_199886_b()).collect(Collectors.toSet());
        this.func_200426_a(Tags.Blocks.CHESTS).add(new Tag[]{Tags.Blocks.CHESTS_ENDER, Tags.Blocks.CHESTS_TRAPPED, Tags.Blocks.CHESTS_WOODEN});
        this.func_200426_a(Tags.Blocks.CHESTS_ENDER).func_200048_a((Object)Blocks.field_150477_bB);
        this.func_200426_a(Tags.Blocks.CHESTS_TRAPPED).func_200048_a((Object)Blocks.field_150447_bR);
        this.func_200426_a(Tags.Blocks.CHESTS_WOODEN).func_200573_a((Object[])new Block[]{Blocks.field_150486_ae, Blocks.field_150447_bR});
        this.func_200426_a(Tags.Blocks.COBBLESTONE).func_200573_a((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_196687_dd, Blocks.field_150341_Y});
        this.func_200426_a(Tags.Blocks.DIRT).func_200573_a((Object[])new Block[]{Blocks.field_150346_d, Blocks.field_196658_i, Blocks.field_196660_k, Blocks.field_196661_l, Blocks.field_150391_bh});
        this.func_200426_a(Tags.Blocks.END_STONES).func_200048_a((Object)Blocks.field_150377_bs);
        this.func_200426_a(Tags.Blocks.FENCE_GATES).func_200574_a(Tags.Blocks.FENCE_GATES_WOODEN);
        this.func_200426_a(Tags.Blocks.FENCE_GATES_WOODEN).func_200573_a((Object[])new Block[]{Blocks.field_180390_bo, Blocks.field_180391_bp, Blocks.field_180392_bq, Blocks.field_180386_br, Blocks.field_180387_bt, Blocks.field_180385_bs});
        this.func_200426_a(Tags.Blocks.FENCES).add(new Tag[]{Tags.Blocks.FENCES_NETHER_BRICK, Tags.Blocks.FENCES_WOODEN});
        this.func_200426_a(Tags.Blocks.FENCES_NETHER_BRICK).func_200048_a((Object)Blocks.field_150386_bk);
        this.func_200426_a(Tags.Blocks.FENCES_WOODEN).func_200573_a((Object[])new Block[]{Blocks.field_180407_aO, Blocks.field_180408_aP, Blocks.field_180404_aQ, Blocks.field_180403_aR, Blocks.field_180405_aT, Blocks.field_180406_aS});
        this.func_200426_a(Tags.Blocks.GLASS).add(new Tag[]{Tags.Blocks.GLASS_COLORLESS, Tags.Blocks.STAINED_GLASS});
        this.func_200426_a(Tags.Blocks.GLASS_COLORLESS).func_200048_a((Object)Blocks.field_150359_w);
        this.addColored(arg_0 -> ((Tag.Builder)this.func_200426_a(Tags.Blocks.STAINED_GLASS)).func_200048_a(arg_0), Tags.Blocks.GLASS, "{color}_stained_glass");
        this.func_200426_a(Tags.Blocks.GLASS_PANES).add(new Tag[]{Tags.Blocks.GLASS_PANES_COLORLESS, Tags.Blocks.STAINED_GLASS_PANES});
        this.func_200426_a(Tags.Blocks.GLASS_PANES_COLORLESS).func_200048_a((Object)Blocks.field_150410_aZ);
        this.addColored(arg_0 -> ((Tag.Builder)this.func_200426_a(Tags.Blocks.STAINED_GLASS_PANES)).func_200048_a(arg_0), Tags.Blocks.GLASS_PANES, "{color}_stained_glass_pane");
        this.func_200426_a(Tags.Blocks.GRAVEL).func_200048_a((Object)Blocks.field_150351_n);
        this.func_200426_a(Tags.Blocks.NETHERRACK).func_200048_a((Object)Blocks.field_150424_aL);
        this.func_200426_a(Tags.Blocks.OBSIDIAN).func_200048_a((Object)Blocks.field_150343_Z);
        this.func_200426_a(Tags.Blocks.ORES).add(new Tag[]{Tags.Blocks.ORES_COAL, Tags.Blocks.ORES_DIAMOND, Tags.Blocks.ORES_EMERALD, Tags.Blocks.ORES_GOLD, Tags.Blocks.ORES_IRON, Tags.Blocks.ORES_LAPIS, Tags.Blocks.ORES_REDSTONE, Tags.Blocks.ORES_QUARTZ});
        this.func_200426_a(Tags.Blocks.ORES_COAL).func_200048_a((Object)Blocks.field_150365_q);
        this.func_200426_a(Tags.Blocks.ORES_DIAMOND).func_200048_a((Object)Blocks.field_150482_ag);
        this.func_200426_a(Tags.Blocks.ORES_EMERALD).func_200048_a((Object)Blocks.field_150412_bA);
        this.func_200426_a(Tags.Blocks.ORES_GOLD).func_200048_a((Object)Blocks.field_150352_o);
        this.func_200426_a(Tags.Blocks.ORES_IRON).func_200048_a((Object)Blocks.field_150366_p);
        this.func_200426_a(Tags.Blocks.ORES_LAPIS).func_200048_a((Object)Blocks.field_150369_x);
        this.func_200426_a(Tags.Blocks.ORES_QUARTZ).func_200048_a((Object)Blocks.field_196766_fg);
        this.func_200426_a(Tags.Blocks.ORES_REDSTONE).func_200048_a((Object)Blocks.field_150450_ax);
        this.func_200426_a(Tags.Blocks.SAND).add(new Tag[]{Tags.Blocks.SAND_COLORLESS, Tags.Blocks.SAND_RED});
        this.func_200426_a(Tags.Blocks.SAND_COLORLESS).func_200048_a((Object)Blocks.field_150354_m);
        this.func_200426_a(Tags.Blocks.SAND_RED).func_200048_a((Object)Blocks.field_196611_F);
        this.func_200426_a(Tags.Blocks.SANDSTONE).func_200573_a((Object[])new Block[]{Blocks.field_150322_A, Blocks.field_196585_ak, Blocks.field_196583_aj, Blocks.field_196580_bH, Blocks.field_180395_cM, Blocks.field_196799_hB, Blocks.field_196798_hA, Blocks.field_196582_bJ});
        this.func_200426_a(Tags.Blocks.STONE).func_200573_a((Object[])new Block[]{Blocks.field_196656_g, Blocks.field_196654_e, Blocks.field_196650_c, Blocks.field_196686_dc, Blocks.field_150348_b, Blocks.field_196657_h, Blocks.field_196655_f, Blocks.field_196652_d});
        this.func_200426_a(Tags.Blocks.STORAGE_BLOCKS).add(new Tag[]{Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Tags.Blocks.STORAGE_BLOCKS_REDSTONE});
        this.func_200426_a(Tags.Blocks.STORAGE_BLOCKS_COAL).func_200048_a((Object)Blocks.field_150402_ci);
        this.func_200426_a(Tags.Blocks.STORAGE_BLOCKS_DIAMOND).func_200048_a((Object)Blocks.field_150484_ah);
        this.func_200426_a(Tags.Blocks.STORAGE_BLOCKS_EMERALD).func_200048_a((Object)Blocks.field_150475_bE);
        this.func_200426_a(Tags.Blocks.STORAGE_BLOCKS_GOLD).func_200048_a((Object)Blocks.field_150340_R);
        this.func_200426_a(Tags.Blocks.STORAGE_BLOCKS_IRON).func_200048_a((Object)Blocks.field_150339_S);
        this.func_200426_a(Tags.Blocks.STORAGE_BLOCKS_LAPIS).func_200048_a((Object)Blocks.field_150368_y);
        this.func_200426_a(Tags.Blocks.STORAGE_BLOCKS_QUARTZ).func_200048_a((Object)Blocks.field_150371_ca);
        this.func_200426_a(Tags.Blocks.STORAGE_BLOCKS_REDSTONE).func_200048_a((Object)Blocks.field_150451_bX);
    }

    private void addColored(Consumer<Block> consumer, Tag<Block> group, String pattern) {
        String prefix = group.func_199886_b().func_110623_a().toUpperCase(Locale.ENGLISH) + '_';
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = new ResourceLocation("minecraft", pattern.replace("{color}", color.func_176762_d()));
            Tag<Block> tag = this.getForgeTag(prefix + color.func_176762_d());
            Block block = ForgeRegistries.BLOCKS.getValue(key);
            if (block == null || block == Blocks.field_150350_a) {
                throw new IllegalStateException("Unknown vanilla block: " + key.toString());
            }
            this.func_200426_a(tag).func_200048_a((Object)block);
            consumer.accept(block);
        }
    }

    private Tag<Block> getForgeTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (Tag)Tags.Blocks.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Blocks.class.getName() + " is missing tag name: " + name);
        }
    }

    protected Path func_200431_a(ResourceLocation id) {
        return this.filter != null && this.filter.contains(id) ? null : super.func_200431_a(id);
    }

    public String func_200397_b() {
        return "Forge Block Tags";
    }
}

