/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityDrawersRenderer
extends TileEntityRenderer<TileEntityDrawers> {
    private boolean[] renderAsBlock = new boolean[4];
    private ItemStack[] renderStacks = new ItemStack[4];
    private ItemRenderer renderItem;
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};

    public TileEntityDrawersRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEntityDrawers tile, float partialTickTime, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (tile == null) {
            return;
        }
        World world = tile.func_145831_w();
        if (world == null) {
            return;
        }
        BlockState state = world.func_180495_p(tile.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockDrawers)) {
            return;
        }
        if (tile.upgrades().hasIlluminationUpgrade()) {
            int blockLight = Math.max(combinedLight % 65536, 208);
            combinedLight = combinedLight & 0xFFFF0000 | blockLight;
        }
        this.renderItem = Minecraft.func_71410_x().func_175599_af();
        Direction side = (Direction)state.func_177229_b((IProperty)BlockDrawers.field_185512_D);
        Minecraft mc = Minecraft.func_71410_x();
        boolean cache = mc.field_71474_y.field_74347_j;
        mc.field_71474_y.field_74347_j = true;
        if (!tile.getDrawerAttributes().isConcealed()) {
            this.renderFastItemSet(tile, state, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime);
        }
        mc.field_71474_y.field_74347_j = cache;
        matrix.func_227865_b_();
        RenderHelper.func_227781_a_((Matrix4f)matrix.func_227866_c_().func_227870_a_());
        matrix.func_227860_a_();
    }

    private void renderFastItemSet(TileEntityDrawers tile, BlockState state, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, Direction side, float partialTickTime) {
        int i;
        int drawerCount = tile.getGroup().getDrawerCount();
        for (i = 0; i < drawerCount; ++i) {
            ItemStack itemStack;
            this.renderStacks[i] = ItemStack.field_190927_a;
            IDrawer drawer = tile.getGroup().getDrawer(i);
            if (!drawer.isEnabled() || drawer.isEmpty()) continue;
            this.renderStacks[i] = itemStack = drawer.getStoredItemPrototype();
            this.renderAsBlock[i] = this.isItemBlockType(itemStack);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i].func_190926_b() || this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, state, i, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime);
        }
        for (i = 0; i < drawerCount; ++i) {
            if (this.renderStacks[i].func_190926_b() || !this.renderAsBlock[i]) continue;
            this.renderFastItem(this.renderStacks[i], tile, state, i, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime);
        }
        if (tile.getDrawerAttributes().isShowingQuantity()) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            BlockPos blockPos = tile.func_174877_v().func_177963_a(0.5, 0.5, 0.5);
            double distance = Math.sqrt(blockPos.func_177951_i((Vec3i)player.func_180425_c()));
            float alpha = 1.0f;
            if (distance > 4.0) {
                alpha = Math.max(1.0f - (float)((distance - 4.0) / 6.0), 0.05f);
            }
            if (distance < 10.0) {
                IRenderTypeBuffer.Impl txtBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                for (int i2 = 0; i2 < drawerCount; ++i2) {
                    String format = CountFormatter.format(this.field_228858_b_.func_147548_a(), tile.getGroup().getDrawer(i2));
                    this.renderText(format, state, i2, matrix, (IRenderTypeBuffer)txtBuffer, combinedLight, side, alpha);
                }
                txtBuffer.func_228461_a_();
            }
        }
    }

    private void renderText(String text, BlockState state, int slot, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, Direction side, float alpha) {
        if (text == null || text.isEmpty()) {
            return;
        }
        FontRenderer fontRenderer = this.field_228858_b_.func_147548_a();
        BlockDrawers block = (BlockDrawers)state.func_177230_c();
        AxisAlignedBB labelGeometry = block.countGeometry[slot];
        int textWidth = fontRenderer.func_78256_a(text);
        float x = (float)(labelGeometry.field_72340_a + labelGeometry.func_216364_b() / 2.0);
        float y = 16.0f - (float)labelGeometry.field_72338_b - (float)labelGeometry.func_216360_c();
        float z = (float)labelGeometry.field_72339_c * 0.0625f;
        matrix.func_227860_a_();
        this.alignRendering(matrix, side);
        this.moveRendering(matrix, 0.125f, 0.125f, x, y, z);
        int color = (int)(255.0f * alpha) << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        fontRenderer.func_228079_a_(text, (float)(-textWidth) / 2.0f, 0.5f, color, false, matrix.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLight);
        matrix.func_227865_b_();
    }

    private void renderFastItem(@Nonnull ItemStack itemStack, TileEntityDrawers tile, BlockState state, int slot, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, Direction side, float partialTickTime) {
        BlockDrawers block = (BlockDrawers)state.func_177230_c();
        AxisAlignedBB labelGeometry = block.labelGeometry[slot];
        float scaleX = (float)labelGeometry.func_216364_b() / 16.0f;
        float scaleY = (float)labelGeometry.func_216360_c() / 16.0f;
        float moveX = (float)labelGeometry.field_72340_a + 8.0f * scaleX;
        float moveY = 16.0f - (float)labelGeometry.field_72337_e + 8.0f * scaleY;
        float moveZ = (float)labelGeometry.field_72339_c * 0.0625f;
        matrix.func_227860_a_();
        this.alignRendering(matrix, side);
        this.moveRendering(matrix, scaleX, scaleY, moveX, moveY, moveZ);
        Consumer<IRenderTypeBuffer> finish = buf -> {
            if (buf instanceof IRenderTypeBuffer.Impl) {
                ((IRenderTypeBuffer.Impl)buf).func_228461_a_();
            }
        };
        try {
            matrix.func_227861_a_(0.0, 0.0, 100.0);
            matrix.func_227862_a_(1.0f, -1.0f, 1.0f);
            matrix.func_227862_a_(16.0f, 16.0f, 16.0f);
            IBakedModel itemModel = this.renderItem.func_184393_a(itemStack, null, null);
            boolean render3D = itemModel.func_177556_c();
            finish.accept(buffer);
            if (render3D) {
                RenderHelper.func_227784_d_();
            } else {
                RenderHelper.func_227783_c_();
            }
            matrix.func_227866_c_().func_227872_b_().func_226114_a_(Matrix3f.func_226117_b_((float)1.0f, (float)-1.0f, (float)1.0f));
            this.renderItem.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.GUI, false, matrix, buffer, combinedLight, combinedOverlay, itemModel);
            finish.accept(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrix.func_227865_b_();
    }

    private boolean isItemBlockType(@Nonnull ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof BlockItem;
    }

    private void alignRendering(MatrixStack matrix, Direction side) {
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, this.getRotationYForSide2D(side), true));
        matrix.func_227861_a_(-0.5, -0.5, -0.5);
    }

    private void moveRendering(MatrixStack matrix, float scaleX, float scaleY, float offsetX, float offsetY, float offsetZ) {
        matrix.func_227861_a_(0.0, 1.0, (double)(1.0f - offsetZ));
        matrix.func_227862_a_(0.0625f, -0.0625f, 5.0E-5f);
        matrix.func_227861_a_((double)offsetX, (double)offsetY, 0.0);
        matrix.func_227862_a_(scaleX, scaleY, 1.0f);
    }

    private float getRotationYForSide2D(Direction side) {
        return sideRotationY2D[side.ordinal()] * 90.0f;
    }
}

