/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen.underground;

import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.world.gen.UndergroundBiomeGenerator;

public abstract class UndergroundBiome {
    private static Tag<Block> fillerTag = null;
    public static final Predicate<BlockState> STONE_TYPES_MATCHER = state -> {
        if (state == null) {
            return false;
        }
        Block block = state.func_177230_c();
        if (fillerTag == null) {
            fillerTag = new BlockTags.Wrapper(new ResourceLocation("quark", "underground_biome_replaceable"));
        }
        return block.func_203417_a(fillerTag);
    };
    public double dungeonChance;

    public final void fill(UndergroundBiomeGenerator.Context context, BlockPos pos) {
        IWorld world = context.world;
        BlockState state = world.func_180495_p(pos);
        if (state.func_185887_b((IBlockReader)world, pos) == -1.0f || world.func_175710_j(pos)) {
            return;
        }
        if (this.isFloor(world, pos, state)) {
            context.floorList.add(pos);
            this.fillFloor(context, pos, state);
        } else if (this.isCeiling(world, pos, state)) {
            context.ceilingList.add(pos);
            this.fillCeiling(context, pos, state);
        } else if (this.isWall(world, pos, state)) {
            context.wallMap.put(pos, this.getBorderSide(world, pos));
            this.fillWall(context, pos, state);
        } else if (this.isInside(state)) {
            context.insideList.add(pos);
            this.fillInside(context, pos, state);
        }
    }

    public abstract void fillFloor(UndergroundBiomeGenerator.Context var1, BlockPos var2, BlockState var3);

    public abstract void fillCeiling(UndergroundBiomeGenerator.Context var1, BlockPos var2, BlockState var3);

    public abstract void fillWall(UndergroundBiomeGenerator.Context var1, BlockPos var2, BlockState var3);

    public abstract void fillInside(UndergroundBiomeGenerator.Context var1, BlockPos var2, BlockState var3);

    public void finalFloorPass(UndergroundBiomeGenerator.Context context, BlockPos pos) {
    }

    public void finalCeilingPass(UndergroundBiomeGenerator.Context context, BlockPos pos) {
    }

    public void finalWallPass(UndergroundBiomeGenerator.Context context, BlockPos pos) {
    }

    public void finalInsidePass(UndergroundBiomeGenerator.Context context, BlockPos pos) {
    }

    public boolean isFloor(IWorld world, BlockPos pos, BlockState state) {
        if (!state.func_200015_d((IBlockReader)world, pos)) {
            return false;
        }
        BlockPos upPos = pos.func_177984_a();
        return world.func_175623_d(upPos) || world.func_180495_p(upPos).func_185904_a().func_76222_j();
    }

    public boolean isCeiling(IWorld world, BlockPos pos, BlockState state) {
        if (!state.func_200015_d((IBlockReader)world, pos)) {
            return false;
        }
        BlockPos downPos = pos.func_177977_b();
        return world.func_175623_d(downPos) || world.func_180495_p(downPos).func_185904_a().func_76222_j();
    }

    public boolean isWall(IWorld world, BlockPos pos, BlockState state) {
        if (!state.func_200015_d((IBlockReader)world, pos) || !STONE_TYPES_MATCHER.test(state)) {
            return false;
        }
        return this.isBorder(world, pos);
    }

    public Direction getBorderSide(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        for (Direction facing : MiscUtil.HORIZONTALS) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            BlockState stateAt = world.func_180495_p(offsetPos);
            if ((state == stateAt || !world.func_175623_d(offsetPos)) && !stateAt.func_185904_a().func_76222_j()) continue;
            return facing;
        }
        return null;
    }

    public boolean isBorder(IWorld world, BlockPos pos) {
        return this.getBorderSide(world, pos) != null;
    }

    public boolean isInside(BlockState state) {
        return STONE_TYPES_MATCHER.test(state);
    }

    public static Rotation rotationFromFacing(Direction facing) {
        switch (facing) {
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }
}

