/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.module;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.OpenBoatChestMessage;
import vazkii.quark.management.client.render.ChestPassengerRenderer;
import vazkii.quark.management.entity.ChestPassengerEntity;

@LoadModule(category=ModuleCategory.MANAGEMENT, hasSubscriptions=true)
public class ChestsInBoatsModule
extends Module {
    public static EntityType<ChestPassengerEntity> chestPassengerEntityType;

    @Override
    public void construct() {
        chestPassengerEntityType = EntityType.Builder.func_220322_a(ChestPassengerEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.8f, 0.8f).setTrackingRange(64).setUpdateInterval(128).setCustomClientFactory((spawnEntity, world) -> new ChestPassengerEntity((EntityType<? extends ChestPassengerEntity>)chestPassengerEntityType, (World)world)).func_206830_a("chest_passenger");
        RegistryHelper.register(chestPassengerEntityType, (String)"chest_passenger");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(chestPassengerEntityType, ChestPassengerRenderer::new);
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity target = event.getTarget();
        PlayerEntity player = event.getPlayer();
        if (target instanceof BoatEntity && target.func_184188_bt().isEmpty()) {
            Hand hand = Hand.MAIN_HAND;
            ItemStack stack = player.func_184614_ca();
            if (!this.isChest(stack)) {
                stack = player.func_184592_cb();
                hand = Hand.OFF_HAND;
            }
            if (this.isChest(stack)) {
                World world = event.getWorld();
                if (!event.getWorld().field_72995_K) {
                    ItemStack chestStack = stack.func_77946_l();
                    chestStack.func_190920_e(1);
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    ChestPassengerEntity passenger = new ChestPassengerEntity(world, chestStack);
                    Vec3d pos = target.func_213303_ch();
                    passenger.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                    passenger.field_70177_z = target.field_70177_z;
                    passenger.func_184205_a(target, true);
                    world.func_217376_c((Entity)passenger);
                }
                player.func_184609_a(hand);
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @OnlyIn(value=Dist.CLIENT)
    public void onOpenGUI(GuiOpenEvent event) {
        Entity riding;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && event.getGui() instanceof InventoryScreen && player.func_184218_aH() && (riding = player.func_184187_bx()) instanceof BoatEntity) {
            List passengers = riding.func_184188_bt();
            for (Entity passenger : passengers) {
                if (!(passenger instanceof ChestPassengerEntity)) continue;
                QuarkNetwork.sendToServer(new OpenBoatChestMessage());
                event.setCanceled(true);
                return;
            }
        }
    }

    private boolean isChest(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().func_206844_a(Tags.Items.CHESTS) && stack.func_77973_b() != Items.field_221735_dD;
    }
}

