/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.module;

import java.util.function.BooleanSupplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemGroup;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.block.MagmaBrickBlock;
import vazkii.quark.building.module.SoulSandstoneModule;

@LoadModule(category=ModuleCategory.BUILDING)
public class MoreBrickTypesModule
extends Module {
    @Config(flag="sandy_bricks")
    public boolean enableSandyBricks = true;
    @Config(flag="snow_bricks")
    public boolean enableSnowBricks = true;
    @Config(flag="magma_bricks")
    public boolean enableMagmaBricks = true;
    @Config(flag="charred_nether_bricks")
    public boolean enableCharredNetherBricks = true;
    @Config(flag="sandstone_bricks", description="This also includes Red Sandstone Bricks and Soul Sandstone Bricks")
    public boolean enableSandstoneBricks = true;

    @Override
    public void construct() {
        this.add("sandy", MaterialColor.field_151658_d, () -> this.enableSandyBricks);
        this.add("snow", MaterialColor.field_151666_j, Material.field_151596_z, () -> this.enableSnowBricks);
        this.add("charred_nether", MaterialColor.field_151646_E, () -> this.enableCharredNetherBricks);
        this.add("sandstone", MaterialColor.field_151658_d, () -> this.enableSandstoneBricks);
        this.add("red_sandstone", MaterialColor.field_151676_q, () -> this.enableSandstoneBricks);
        this.add("soul_sandstone", MaterialColor.field_151650_B, () -> this.enableSandstoneBricks && ModuleLoader.INSTANCE.isModuleEnabled(SoulSandstoneModule.class));
        VariantHandler.addSlabStairsWall(new MagmaBrickBlock(this).setCondition(() -> this.enableMagmaBricks));
    }

    private void add(String name, MaterialColor color, BooleanSupplier cond) {
        this.add(name, color, Material.field_151576_e, cond);
    }

    private void add(String name, MaterialColor color, Material material, BooleanSupplier cond) {
        VariantHandler.addSlabStairsWall(new QuarkBlock(name + "_bricks", this, ItemGroup.field_78030_b, Block.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200948_a(2.0f, 6.0f)).setCondition(cond));
    }
}

