/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GearNamePrefixesEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.IPartData;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.crafting.ingredient.GearPartIngredient;
import net.silentchaos512.gear.item.MiscUpgrades;
import net.silentchaos512.gear.parts.LazyPartData;
import net.silentchaos512.gear.parts.PartConst;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.PartPositions;
import net.silentchaos512.gear.traits.TraitConst;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearGenerator;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.advancements.LibTriggers;

public final class GearHelper {
    private static final UUID REACH_MODIFIER_UUID = UUID.fromString("5e889b20-a8bd-43df-9ece-88a9f9be7530");
    private static final float BROKEN_ATTACK_SPEED_CHANGE = 0.7f;
    private static final float BROKEN_DESTROY_SPEED = 0.25f;
    private static final int DAMAGE_FACTOR_LEVELS = 10;

    private GearHelper() {
    }

    public static boolean isGear(ItemStack stack) {
        return stack.func_77973_b() instanceof ICoreItem;
    }

    public static boolean isGearNullable(@Nullable ItemStack stack) {
        return stack != null && !stack.func_190926_b() && GearHelper.isGear(stack);
    }

    public static float getMeleeDamageModifier(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 1.0f;
        }
        float val = GearData.getStat(stack, ItemStats.MELEE_DAMAGE);
        return val < 0.0f ? 0.0f : val;
    }

    public static float getMagicDamageModifier(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0f;
        }
        float val = GearData.getStat(stack, ItemStats.MAGIC_DAMAGE);
        return val < 0.0f ? 0.0f : val;
    }

    public static float getAttackSpeedModifier(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ICoreTool)) {
            return 0.0f;
        }
        float speed = GearData.getStat(stack, ItemStats.ATTACK_SPEED);
        if (GearHelper.isBroken(stack)) {
            speed += 0.7f;
        }
        return speed;
    }

    public static Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack, true);
    }

    public static Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack, boolean addStandardMainHandMods) {
        LinkedHashMultimap map = LinkedHashMultimap.create((Multimap)stack.func_77973_b().func_111205_h(slot));
        return GearHelper.getAttributeModifiers(slot, stack, (Multimap<String, AttributeModifier>)map, addStandardMainHandMods);
    }

    public static Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack, Multimap<String, AttributeModifier> map) {
        return GearHelper.getAttributeModifiers(slot, stack, map, true);
    }

    public static Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack, Multimap<String, AttributeModifier> map, boolean addStandardMainHandMods) {
        if (addStandardMainHandMods && slot == EquipmentSlotType.MAINHAND) {
            GearHelper.replaceAttributeModifierInMap(map, SharedMonsterAttributes.field_111264_e.func_111108_a(), GearHelper.getMeleeDamageModifier(stack));
            GearHelper.replaceAttributeModifierInMap(map, SharedMonsterAttributes.field_188790_f.func_111108_a(), GearHelper.getAttackSpeedModifier(stack));
            float reachStat = GearData.getStat(stack, ItemStats.REACH_DISTANCE);
            AttributeModifier reachModifier = new AttributeModifier(REACH_MODIFIER_UUID, "Gear reach", (double)reachStat, AttributeModifier.Operation.ADDITION);
            map.put((Object)PlayerEntity.REACH_DISTANCE.func_111108_a(), (Object)reachModifier);
        }
        TraitHelper.getCachedTraits(stack).forEach((trait, level) -> trait.onGetAttributeModifiers(new TraitActionContext(null, (int)level, stack), map, slot));
        return map;
    }

    private static void replaceAttributeModifierInMap(Multimap<String, AttributeModifier> map, String key, float value) {
        Iterator iter;
        if (map.containsKey((Object)key) && (iter = map.get((Object)key).iterator()).hasNext()) {
            AttributeModifier mod = (AttributeModifier)iter.next();
            map.removeAll((Object)key);
            map.put((Object)key, (Object)new AttributeModifier(mod.func_111167_a(), mod.func_111166_b(), (double)value, mod.func_220375_c()));
        }
    }

    public static boolean getIsRepairable(ItemStack stack, ItemStack material) {
        PartData data = GearData.getPrimaryPart(stack);
        PartData dataMaterial = PartData.from(material);
        return data != null && dataMaterial != null && data.getTier() <= dataMaterial.getTier();
    }

    public static void attemptDamage(ItemStack stack, int amount, @Nullable LivingEntity entity, Hand hand) {
        GearHelper.attemptDamage(stack, amount, entity, hand == Hand.OFF_HAND ? EquipmentSlotType.OFFHAND : EquipmentSlotType.MAINHAND);
    }

    public static void attemptDamage(ItemStack stack, int amount, @Nullable LivingEntity entity, EquipmentSlotType slot) {
        if (GearHelper.isUnbreakable(stack) || entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            return;
        }
        ServerPlayerEntity player = entity instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity : null;
        int preTraitAmount = amount;
        amount = (int)TraitHelper.activateTraits(stack, preTraitAmount, (trait, level, val) -> trait.onDurabilityDamage(new TraitActionContext((PlayerEntity)player, level, stack), (int)val));
        int maxDamage = stack.func_77958_k();
        int preDamageFactor = GearHelper.getDamageFactor(stack, maxDamage);
        if (!GearHelper.canBreakPermanently(stack)) {
            amount = Math.min(maxDamage - stack.func_77952_i(), amount);
        }
        stack.func_96631_a(amount, SilentGear.random, player);
        if (GearHelper.getDamageFactor(stack, maxDamage) != preDamageFactor) {
            GearData.recalculateStats(stack, (PlayerEntity)player);
            if (player != null) {
                GearHelper.onDamageFactorChange(player, preDamageFactor, GearHelper.getDamageFactor(stack, maxDamage));
            }
        }
        GearHelper.handleBrokenItem(stack, player, slot);
    }

    private static void handleBrokenItem(ItemStack stack, @Nullable ServerPlayerEntity player, EquipmentSlotType slot) {
        if (GearHelper.isBroken(stack)) {
            GearData.incrementBrokenCount(stack);
            GearData.recalculateStats(stack, (PlayerEntity)player);
            if (player != null) {
                player.func_213361_c(slot);
                GearHelper.notifyPlayerOfBrokenGear(stack, player);
            }
        } else if (GearHelper.canBreakPermanently(stack) && stack.func_77952_i() > stack.func_77958_k()) {
            if (player != null) {
                player.func_213361_c(slot);
            }
            stack.func_190918_g(1);
        }
    }

    public static ActionResultType useAndCheckBroken(ItemUseContext context, Function<ItemUseContext, ActionResultType> useFunction) {
        ActionResultType result = useFunction.apply(context);
        if (context.func_195999_j() instanceof ServerPlayerEntity) {
            GearHelper.handleBrokenItem(context.func_195996_i(), (ServerPlayerEntity)context.func_195999_j(), context.func_221531_n() == Hand.OFF_HAND ? EquipmentSlotType.OFFHAND : EquipmentSlotType.MAINHAND);
        }
        return result;
    }

    private static void onDamageFactorChange(ServerPlayerEntity player, int preDamageFactor, int newDamageFactor) {
        if (newDamageFactor > preDamageFactor) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 0.5f, 2.0f);
            LibTriggers.GENERIC_INT.trigger(player, new ResourceLocation("silentgear", "damage_factor_change"), 1);
        }
    }

    private static void notifyPlayerOfBrokenGear(ItemStack stack, ServerPlayerEntity player) {
        player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.silentgear.notifyOnBreak", new Object[]{stack.func_200301_q()}));
    }

    private static int getDamageFactor(ItemStack stack, int maxDamage) {
        if (maxDamage == 0) {
            return 1;
        }
        int step = Math.max(1, maxDamage / 10);
        return stack.func_77952_i() / step;
    }

    public static int calcDamageClamped(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return 0;
        }
        if (!GearHelper.canBreakPermanently(stack)) {
            damage = damage > stack.func_77952_i() ? Math.min(stack.func_77958_k(), damage) : Math.max(0, damage);
        }
        return damage;
    }

    private static boolean canBreakPermanently(ItemStack stack) {
        return (Boolean)Config.GENERAL.gearBreaksPermanently.get() != false || GearData.hasPart(stack, MiscUpgrades.RED_CARD.getPartId());
    }

    public static boolean isBroken(ItemStack stack) {
        if (stack.func_190926_b() || GearHelper.canBreakPermanently(stack) || GearHelper.isUnbreakable(stack)) {
            return false;
        }
        int maxDamage = stack.func_77958_k();
        return maxDamage > 0 && stack.func_77952_i() >= maxDamage - 1;
    }

    public static boolean isUnbreakable(ItemStack stack) {
        return TraitHelper.getTraitLevel(stack, TraitConst.INDESTRUCTIBLE) > 0;
    }

    public static void setDamage(ItemStack stack, int damage, BiConsumer<ItemStack, Integer> superFunction) {
        int newDamage = GearHelper.calcDamageClamped(stack, damage);
        int diff = newDamage - stack.func_77952_i();
        if (diff > 0 && !GearHelper.isBroken(stack)) {
            GearHelper.damageParts(stack, diff);
        }
        superFunction.accept(stack, newDamage);
        if (GearHelper.isBroken(stack)) {
            GearData.recalculateStats(stack, null);
        }
    }

    public static void damageParts(ItemStack stack, int amount) {
        GearData.getConstructionParts(stack).forEach(p -> p.getPart().onGearDamaged((PartData)p, stack, amount));
    }

    public static Item.Properties getBuilder(@Nullable ToolType toolType) {
        Item.Properties b = new Item.Properties().func_200917_a(1).func_200916_a(SilentGear.ITEM_GROUP);
        if (toolType != null) {
            b.addToolType(toolType, 3);
        }
        return b;
    }

    public static void addModelTypeProperty(ICoreItem item) {
        PartPositions.LITE_MODEL_LAYERS.forEach((position, partType) -> item.func_199767_j().func_185043_a(SilentGear.getId("lite_" + position.getTexturePrefix()), (stack, world, entity) -> {
            PartData part = GearData.getPartOfType(stack, partType);
            return part != null ? (float)part.getPart().getDisplayProperties(part, ItemStack.field_190927_a, 0).getLiteTexture().getIndex() : -1.0f;
        }));
    }

    @Nullable
    public static GearType getType(ItemStack gear) {
        if (!(gear.func_77973_b() instanceof ICoreItem)) {
            return null;
        }
        return ((ICoreItem)gear.func_77973_b()).getGearType();
    }

    public static int getHarvestLevel(ItemStack stack, ToolType toolClass, @Nullable BlockState state, @Nullable Set<Material> effectiveMaterials) {
        boolean effectiveOnMaterial;
        if (GearHelper.isBroken(stack) || !stack.func_77973_b().getToolTypes(stack).contains(toolClass)) {
            return -1;
        }
        int level = GearData.getStatInt(stack, ItemStats.HARVEST_LEVEL);
        if (state == null) {
            return level;
        }
        boolean bl = effectiveOnMaterial = effectiveMaterials == null || effectiveMaterials.contains(state.func_185904_a());
        if (effectiveOnMaterial && state.func_177230_c().getHarvestLevel(state) <= level) {
            return level;
        }
        return -1;
    }

    public static void setHarvestLevel(ICoreItem item, String toolClass, int level, Set<String> mutableSet) {
        boolean add = level >= 0;
        SilentGear.LOGGER.info("{}: {} tool class \"{}\"", (Object)item.getClass().getSimpleName(), (Object)(add ? "set" : "remove"), (Object)toolClass);
        if (add) {
            mutableSet.add(toolClass);
        } else {
            mutableSet.remove(toolClass);
        }
    }

    public static float getDestroySpeed(ItemStack stack, BlockState state, @Nullable Set<Material> extraMaterials) {
        if (GearHelper.isBroken(stack)) {
            return 0.25f;
        }
        float speed = GearData.getStat(stack, ItemStats.HARVEST_SPEED);
        if (stack.func_77973_b().canHarvestBlock(stack, state)) {
            return speed;
        }
        for (ToolType type : stack.func_77973_b().getToolTypes(stack)) {
            if (!state.func_177230_c().isToolEffective(state, type)) continue;
            return speed;
        }
        if (extraMaterials != null && extraMaterials.contains(state.func_185904_a())) {
            return speed;
        }
        return 1.0f;
    }

    public static boolean onBlockDestroyed(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!GearHelper.isBroken(stack) && stack.func_77973_b() instanceof ICoreTool) {
            int damage = ((ICoreTool)stack.func_77973_b()).getDamageOnBlockBreak(stack, world, state, pos);
            GearHelper.attemptDamage(stack, damage, entityLiving, EquipmentSlotType.MAINHAND);
        }
        GearHelper.selfHarmWithToolHead(stack, entityLiving);
        return true;
    }

    public static boolean hitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean isBroken = GearHelper.isBroken(stack);
        if (!isBroken && stack.func_77973_b() instanceof ICoreTool) {
            int damage = ((ICoreTool)stack.func_77973_b()).getDamageOnHitEntity(stack, target, attacker);
            GearHelper.attemptDamage(stack, damage, attacker, EquipmentSlotType.MAINHAND);
        }
        GearHelper.selfHarmWithToolHead(stack, attacker);
        return !isBroken;
    }

    private static void selfHarmWithToolHead(final ItemStack stack, LivingEntity user) {
        if (stack.func_77973_b() instanceof ICoreItem) {
            ICoreItem item = (ICoreItem)stack.func_77973_b();
            if (GearData.isMissingRequiredPart(stack, PartType.ROD)) {
                float damageAmount = item.getStat(stack, ItemStats.MELEE_DAMAGE) / 2.0f;
                DamageSource source = new DamageSource("silentgear.broken_tool"){

                    @Nonnull
                    public ITextComponent func_151519_b(LivingEntity entity) {
                        return new TranslationTextComponent("death.silentgear.broken_tool", new Object[]{entity.func_145748_c_(), stack.func_200301_q()});
                    }
                }.func_76348_h();
                user.func_70097_a(source, damageAmount);
                if (user instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)user;
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("misc.silentgear.missingRod.attack", new Object[0]), true);
                }
            }
        }
    }

    public static void inventoryTick(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        PlayerEntity player;
        PlayerEntity playerEntity = player = entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
        if (!world.field_72995_K) {
            TraitHelper.tickTraits(world, player, stack, isSelected);
        }
    }

    public static ActionResultType onItemUse(ItemUseContext context) {
        ActionResultType ret = ActionResultType.PASS;
        Map<ITrait, Integer> traits = TraitHelper.getCachedTraits(context.func_195996_i());
        for (Map.Entry<ITrait, Integer> entry : traits.entrySet()) {
            ActionResultType result = entry.getKey().onItemUse(context, entry.getValue());
            if (result == ActionResultType.PASS) continue;
            ret = result;
        }
        return ret;
    }

    public static boolean shouldUseFallbackColor(ItemStack stack, PartData part) {
        return false;
    }

    public static Rarity getRarity(ItemStack stack) {
        int rarity = GearData.getStatInt(stack, ItemStats.RARITY);
        if (stack.func_77948_v()) {
            rarity += 20;
        }
        if (rarity < 40) {
            return Rarity.COMMON;
        }
        if (rarity < 80) {
            return Rarity.UNCOMMON;
        }
        if (rarity < 120) {
            return Rarity.RARE;
        }
        return Rarity.EPIC;
    }

    public static void fillItemGroup(ICoreItem item, ItemGroup group, Collection<ItemStack> items) {
        boolean inTab = false;
        for (ItemGroup tabInList : item.func_199767_j().getCreativeTabs()) {
            if (tabInList != group) continue;
            inTab = true;
            break;
        }
        if (!inTab) {
            return;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 3; i <= Math.max(3, PartManager.getHighestMainPartTier()); ++i) {
            ItemStack stack = GearHelper.createSampleItem(item, i);
            if (stack.func_190926_b()) continue;
            list.add(stack);
        }
        items.addAll(list);
    }

    private static ItemStack createSampleItem(ICoreItem item, int tier) {
        ItemStack result = GearGenerator.create(item, tier);
        if (result.func_190926_b()) {
            ArrayList<LazyPartData> parts = new ArrayList<LazyPartData>();
            parts.add(new LazyPartData(PartConst.MAIN_EXAMPLE));
            if (item.requiresPartOfType(PartType.ROD)) {
                parts.add(new LazyPartData(PartConst.ROD_EXAMPLE));
            }
            if (item.requiresPartOfType(PartType.BOWSTRING)) {
                parts.add(new LazyPartData(PartConst.BOWSTRING_EXAMPLE));
            }
            result = item.construct(parts);
        }
        GearData.setExampleTag(result, true);
        return result;
    }

    public static ITextComponent getDisplayName(ItemStack gear) {
        TranslationTextComponent gearName;
        PartData part = GearData.getPrimaryPart(gear);
        if (part == null) {
            return new TranslationTextComponent(gear.func_77977_a(), new Object[0]);
        }
        ITextComponent partName = part.getDisplayName(gear);
        TranslationTextComponent result = gearName = new TranslationTextComponent(gear.func_77977_a() + ".nameProper", new Object[]{partName});
        if (gear.func_77973_b() instanceof ICoreTool) {
            ICoreItem item = (ICoreItem)gear.func_77973_b();
            if (item.requiresPartOfType(PartType.ROD) && GearData.getPartOfType(gear, PartType.ROD) == null) {
                result = new TranslationTextComponent(gear.func_77977_a() + ".noRod", new Object[]{gearName});
            } else if (item.requiresPartOfType(PartType.BOWSTRING) && GearData.getPartOfType(gear, PartType.BOWSTRING) == null) {
                result = new TranslationTextComponent(gear.func_77977_a() + ".unstrung", new Object[]{gearName});
            }
        }
        for (ITextComponent t : GearHelper.getNamePrefixes(gear, GearData.getConstructionParts(gear))) {
            result = t.func_212638_h().func_150257_a((ITextComponent)new StringTextComponent(" ")).func_150257_a((ITextComponent)result);
        }
        return result;
    }

    private static Collection<ITextComponent> getNamePrefixes(ItemStack gear, PartDataList parts) {
        GearNamePrefixesEvent event = new GearNamePrefixesEvent(gear, parts);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getPrefixes();
    }

    public static Collection<IPartData> getExamplePartsFromRecipe(Iterable<Ingredient> ingredients) {
        ArrayList<IPartData> list = new ArrayList<IPartData>();
        for (Ingredient ingredient : ingredients) {
            PartData part;
            if (ingredient instanceof GearPartIngredient) {
                PartType type = ((GearPartIngredient)ingredient).getPartType();
                if (type == PartType.MAIN) {
                    list.add(new LazyPartData(PartConst.MAIN_EXAMPLE));
                    continue;
                }
                if (type == PartType.ROD) {
                    list.add(new LazyPartData(PartConst.ROD_EXAMPLE));
                    continue;
                }
                if (type != PartType.BOWSTRING) continue;
                list.add(new LazyPartData(PartConst.BOWSTRING_EXAMPLE));
                continue;
            }
            ItemStack[] matchingStacks = ingredient.func_193365_a();
            if (matchingStacks.length <= 0 || (part = PartData.fromStackFast(matchingStacks[0])) == null) continue;
            list.add(part);
        }
        return list;
    }
}

