/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.util.Size2i;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.init.ModItems;

public class GearCraftingRecipeCategoryJei
implements IRecipeCategory<ICraftingRecipe> {
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private final ICraftingGridHelper craftingGridHelper;

    public GearCraftingRecipeCategoryJei(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
        this.background = guiHelper.createDrawable(location, 0, 60, 116, 54);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.blueprintPackage));
        this.localizedName = I18n.func_135052_a((String)"gui.silentgear.category.gearCrafting", (Object[])new Object[0]);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1);
    }

    public ResourceLocation getUid() {
        return SGearJeiPlugin.GEAR_CRAFTING;
    }

    public Class<? extends ICraftingRecipe> getRecipeClass() {
        return ICraftingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ICraftingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        Size2i size = GearCraftingRecipeCategoryJei.getRecipeSize(recipe);
        if (size != null && size.width > 0 && size.height > 0) {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, size.width, size.height);
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(0, (List)outputs.get(0));
    }

    public void setIngredients(ICraftingRecipe recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        ingredients.setInputIngredients((List)recipe.func_192400_c());
    }

    @Nullable
    private static Size2i getRecipeSize(ICraftingRecipe recipe) {
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            return new Size2i(shapedRecipe.getRecipeWidth(), shapedRecipe.getRecipeHeight());
        }
        return null;
    }
}

