/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class BookRightClickHandler {
    @SubscribeEvent
    public static void onRenderHUD(RenderGameOverlayEvent.Post event) {
        BookEntry entry;
        Pair<BookEntry, Integer> hover;
        Book book;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ItemStack bookStack = player.func_184614_ca();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && mc.field_71462_r == null && (book = BookRightClickHandler.getBookFromStack(bookStack)) != null && (hover = BookRightClickHandler.getHoveredEntry(book)) != null && !(entry = (BookEntry)hover.getFirst()).isLocked()) {
            MainWindow window = event.getWindow();
            int x = window.func_198107_o() / 2 + 3;
            int y = window.func_198087_p() / 2 + 3;
            entry.getIcon().render(x, y);
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
            mc.func_175599_af().func_180450_b(bookStack, (x + 8) * 2, (y + 8) * 2);
            RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            mc.field_71466_p.func_175063_a(entry.getName(), (float)(x + 18), (float)(y + 3), 0xFFFFFF);
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.75f, (float)0.75f, (float)1.0f);
            String s = I18n.func_135052_a((String)("patchouli.gui.lexicon." + (player.func_225608_bj_() ? "view" : "sneak")), (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(TextFormatting.ITALIC + s, (float)(x + 18) / 0.75f, (float)(y + 14) / 0.75f, 0xBBBBBB);
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Pair<BookEntry, Integer> hover;
        Book book;
        PlayerEntity player = event.getPlayer();
        if (event.getWorld().field_72995_K && player.func_225608_bj_() && (book = BookRightClickHandler.getBookFromStack(event.getItemStack())) != null && (hover = BookRightClickHandler.getHoveredEntry(book)) != null) {
            int page = (Integer)hover.getSecond() * 2;
            book.contents.setTopEntry(((BookEntry)hover.getFirst()).getId(), page);
        }
    }

    @Nullable
    public static Book getBookFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemModBook) {
            return ItemModBook.getBook(stack);
        }
        Collection<Book> books = BookRegistry.INSTANCE.books.values();
        for (Book b : books) {
            if (!b.getBookItem().func_77969_a(stack)) continue;
            return b;
        }
        return null;
    }

    private static Pair<BookEntry, Integer> getHoveredEntry(Book book) {
        BlockPos pos;
        BlockState state;
        Block block;
        ItemStack picked;
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult res = mc.field_71476_x;
        if (res instanceof BlockRayTraceResult && !(picked = (block = (state = mc.field_71441_e.func_180495_p(pos = ((BlockRayTraceResult)res).func_216350_a())).func_177230_c()).getPickBlock(state, res, (IBlockReader)mc.field_71441_e, pos, (PlayerEntity)mc.field_71439_g)).func_190926_b()) {
            return book.contents.getEntryForStack(picked);
        }
        return null;
    }
}

