/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookEye;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;
import vazkii.patchouli.common.multiblock.SerializedMultiblock;

public class PageMultiblock
extends PageWithText {
    private static final Random RAND = new Random();
    String name = "";
    @SerializedName(value="multiblock_id")
    ResourceLocation multiblockId;
    @SerializedName(value="multiblock")
    SerializedMultiblock serializedMultiblock;
    @SerializedName(value="enable_visualize")
    boolean showVisualizeButton = true;
    private transient AbstractMultiblock multiblockObj;
    private transient Button visualizeButton;
    private final transient Set<TileEntity> erroredTiles = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public void build(BookEntry entry, int pageNum) {
        IMultiblock mb;
        if (this.multiblockId != null && (mb = MultiblockRegistry.MULTIBLOCKS.get(this.multiblockId)) instanceof AbstractMultiblock) {
            this.multiblockObj = (AbstractMultiblock)mb;
        }
        if (this.multiblockObj == null && this.serializedMultiblock != null) {
            this.multiblockObj = this.serializedMultiblock.toMultiblock();
        }
        if (this.multiblockObj == null) {
            throw new IllegalArgumentException("No multiblock located for " + this.multiblockId);
        }
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        if (this.showVisualizeButton) {
            this.visualizeButton = new GuiButtonBookEye(parent, 12, 97, this::handleButtonVisualize);
            this.addButton(this.visualizeButton);
        }
    }

    @Override
    public int getTextHeight() {
        return 115;
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        int x = 5;
        int y = 7;
        RenderSystem.enableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(this.book, x, y, 405, 149, 106, 106);
        this.parent.drawCenteredStringNoShadow(this.name, 58, 0, this.book.headerColor);
        if (this.multiblockObj != null) {
            this.renderMultiblock();
        }
        super.render(mouseX, mouseY, pticks);
    }

    public void handleButtonVisualize(Button button) {
        String entryKey = this.parent.getEntry().getId().toString();
        PersistentData.DataHolder.BookData.Bookmark bookmark = new PersistentData.DataHolder.BookData.Bookmark(entryKey, this.pageNum / 2);
        MultiblockVisualizationHandler.setMultiblock((IMultiblock)this.multiblockObj, (ITextComponent)new StringTextComponent(this.name), bookmark, true);
        this.parent.addBookmarkButtons();
        if (!PersistentData.data.clickedVisualize) {
            PersistentData.data.clickedVisualize = true;
            PersistentData.save();
        }
    }

    private void renderMultiblock() {
        this.multiblockObj.setWorld((World)this.mc.field_71441_e);
        Vec3i size = this.multiblockObj.getSize();
        int sizeX = size.func_177958_n();
        int sizeY = size.func_177956_o();
        int sizeZ = size.func_177952_p();
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 58;
        int yPos = 60;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)xPos, (float)yPos, (float)100.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        RenderSystem.translatef((float)(-((float)sizeX) / 2.0f), (float)(-((float)sizeY) / 2.0f), (float)0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.func_226591_a_();
        RenderSystem.rotatef((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        rotMat.func_226596_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parent.ticksInBook * 0.5f;
        if (!Screen.hasShiftDown()) {
            time += ClientTicker.partialTicks;
        }
        RenderSystem.translatef((float)(-offX), (float)0.0f, (float)(-offZ));
        RenderSystem.rotatef((float)time, (float)0.0f, (float)1.0f, (float)0.0f);
        rotMat.func_226596_a_(Vector3f.field_229181_d_.func_229187_a_(-time));
        RenderSystem.rotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        rotMat.func_226596_a_(Vector3f.field_229181_d_.func_229187_a_(-45.0f));
        RenderSystem.translatef((float)offX, (float)0.0f, (float)offZ);
        eye.func_229372_a_(rotMat);
        eye.func_229375_f_();
        this.renderElements(this.multiblockObj, BlockPos.func_218278_a((BlockPos)BlockPos.field_177992_a, (BlockPos)new BlockPos(sizeX - 1, sizeY - 1, sizeZ - 1)), eye);
        RenderSystem.popMatrix();
    }

    private void renderElements(AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, Vector4f eye) {
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-1.0f);
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        this.doWorldRenderPass(mb, blocks, buffers, eye);
        this.doTileEntityRenderPass(mb, blocks, (IRenderTypeBuffer)buffers, eye);
        buffers.func_228461_a_();
        RenderSystem.popMatrix();
    }

    private void doWorldRenderPass(AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, @Nonnull IRenderTypeBuffer.Impl buffers, Vector4f eye) {
        MatrixStack ms = new MatrixStack();
        for (BlockPos blockPos : blocks) {
            BlockState bs = mb.func_180495_p(blockPos);
            ms.func_227860_a_();
            ms.func_227861_a_((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
            for (RenderType layer : RenderType.func_228661_n_()) {
                if (!RenderTypeLookup.canRenderInLayer((BlockState)bs, (RenderType)layer)) continue;
                ForgeHooksClient.setRenderLayer((RenderType)layer);
                IVertexBuilder buffer = buffers.getBuffer(layer);
                Minecraft.func_71410_x().func_175602_ab().func_228793_a_(bs, blockPos, (ILightReader)mb, ms, buffer, false, RAND);
                ForgeHooksClient.setRenderLayer(null);
            }
            ms.func_227865_b_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTileEntityRenderPass(AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, IRenderTypeBuffer buffers, Vector4f eye) {
        MatrixStack ms = new MatrixStack();
        for (BlockPos blockPos : blocks) {
            TileEntity te = mb.func_175625_s(blockPos);
            if (te == null || this.erroredTiles.contains(te)) continue;
            te.func_226984_a_((World)this.mc.field_71441_e, blockPos);
            ObfuscationReflectionHelper.setPrivateValue(TileEntity.class, (Object)te, (Object)mb.func_180495_p(blockPos), (String)"field_195045_e");
            ms.func_227860_a_();
            ms.func_227861_a_((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p());
            try {
                TileEntityRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te);
                if (renderer == null) continue;
                renderer.func_225616_a_(te, ClientTicker.partialTicks, ms, buffers, 0xF000F0, OverlayTexture.field_229196_a_);
            }
            catch (Exception e) {
                this.erroredTiles.add(te);
                Patchouli.LOGGER.error("An exception occured rendering tile entity", (Throwable)e);
            }
            finally {
                ms.func_227865_b_();
            }
        }
    }
}

