/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.UUID;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.security.IOwnerItem;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityData;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;

public final class SecurityUtils {
    public static boolean canAccess(PlayerEntity player, ItemStack stack) {
        if (!MekanismConfig.general.allowProtection.get()) {
            return true;
        }
        if (!(stack.func_77973_b() instanceof ISecurityItem) && stack.func_77973_b() instanceof IOwnerItem) {
            UUID owner = ((IOwnerItem)stack.func_77973_b()).getOwnerUUID(stack);
            return owner == null || owner.equals(player.func_110124_au());
        }
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ISecurityItem)) {
            return true;
        }
        ISecurityItem security = (ISecurityItem)stack.func_77973_b();
        if (MekanismUtils.isOp(player)) {
            return true;
        }
        return SecurityUtils.canAccess(security.getSecurity(stack), player, security.getOwnerUUID(stack));
    }

    public static boolean canAccess(PlayerEntity player, TileEntity tile) {
        if (!(tile instanceof ISecurityTile) || !((ISecurityTile)tile).hasSecurity()) {
            return true;
        }
        ISecurityTile security = (ISecurityTile)tile;
        if (MekanismUtils.isOp(player)) {
            return true;
        }
        return SecurityUtils.canAccess(security.getSecurity().getMode(), player, security.getSecurity().getOwnerUUID());
    }

    private static boolean canAccess(ISecurityTile.SecurityMode mode, PlayerEntity player, UUID owner) {
        if (!MekanismConfig.general.allowProtection.get()) {
            return true;
        }
        if (owner == null || player.func_110124_au().equals(owner)) {
            return true;
        }
        SecurityFrequency freq = SecurityUtils.getFrequency(owner);
        if (freq == null) {
            return true;
        }
        if (freq.override) {
            mode = freq.securityMode;
        }
        if (mode == ISecurityTile.SecurityMode.PUBLIC) {
            return true;
        }
        if (mode == ISecurityTile.SecurityMode.TRUSTED) {
            return freq.trusted.contains(player.func_110124_au());
        }
        return false;
    }

    public static SecurityFrequency getFrequency(UUID uuid) {
        if (uuid != null) {
            for (Frequency f : Mekanism.securityFrequencies.getFrequencies()) {
                if (!(f instanceof SecurityFrequency) || !f.ownerUUID.equals(uuid)) continue;
                return (SecurityFrequency)f;
            }
        }
        return null;
    }

    public static void displayNoAccess(PlayerEntity player) {
        player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.NO_ACCESS.translateColored(EnumColor.RED, new Object[0])));
    }

    public static ISecurityTile.SecurityMode getSecurity(ISecurityTile security, Dist side) {
        SecurityData data;
        if (!security.hasSecurity()) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        if (side.isDedicatedServer()) {
            SecurityFrequency freq = security.getSecurity().getFrequency();
            if (freq != null && freq.override) {
                return freq.securityMode;
            }
        } else if (side.isClient() && (data = MekanismClient.clientSecurityMap.get(security.getSecurity().getOwnerUUID())) != null && data.override) {
            return data.mode;
        }
        return security.getSecurity().getMode();
    }

    public static ISecurityTile.SecurityMode getSecurity(ItemStack stack, Dist side) {
        ISecurityItem security = (ISecurityItem)stack.func_77973_b();
        ISecurityTile.SecurityMode mode = security.getSecurity(stack);
        if (security.getOwnerUUID(stack) != null) {
            SecurityData data;
            if (side.isDedicatedServer()) {
                SecurityFrequency freq = SecurityUtils.getFrequency(security.getOwnerUUID(stack));
                if (freq != null && freq.override) {
                    mode = freq.securityMode;
                }
            } else if (side.isClient() && (data = MekanismClient.clientSecurityMap.get(security.getOwnerUUID(stack))) != null && data.override) {
                mode = data.mode;
            }
        }
        return mode;
    }

    public static boolean isOverridden(ItemStack stack, Dist side) {
        ISecurityItem security = (ISecurityItem)stack.func_77973_b();
        if (security.getOwnerUUID(stack) == null) {
            return false;
        }
        if (side.isDedicatedServer()) {
            SecurityFrequency freq = SecurityUtils.getFrequency(security.getOwnerUUID(stack));
            return freq != null && freq.override;
        }
        SecurityData data = MekanismClient.clientSecurityMap.get(security.getOwnerUUID(stack));
        return data != null && data.override;
    }

    public static boolean isOverridden(TileEntity tile, Dist side) {
        ISecurityTile security = (ISecurityTile)tile;
        if (!security.hasSecurity() || security.getSecurity().getOwnerUUID() == null) {
            return false;
        }
        if (side.isDedicatedServer()) {
            SecurityFrequency freq = SecurityUtils.getFrequency(security.getSecurity().getOwnerUUID());
            return freq != null && freq.override;
        }
        SecurityData data = MekanismClient.clientSecurityMap.get(security.getSecurity().getOwnerUUID());
        return data != null && data.override;
    }
}

