/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.inventory.AutomationType;
import mekanism.api.providers.IGasProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.distribution.target.GasHandlerTarget;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class GasUtils {
    public static IGasHandler[] getConnectedAcceptors(BlockPos pos, World world, Set<Direction> sides) {
        IGasHandler[] acceptors = new IGasHandler[EnumUtils.DIRECTIONS.length];
        EmitUtils.forEachSide(world, pos, sides, (tile, side) -> CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, side.func_176734_d()).ifPresent(handler -> {
            acceptors[side.ordinal()] = handler;
        }));
        return acceptors;
    }

    public static ItemStack getFilledVariant(ItemStack toFill, long capacity, IGasProvider gasProvider) {
        BasicGasTank tank = BasicGasTank.createDummy(capacity);
        tank.setStack(gasProvider.getGasStack(tank.getCapacity()));
        ItemDataUtils.setList(toFill, "GasTanks", DataHandlerUtils.writeTanks(Collections.singletonList(tank)));
        return toFill;
    }

    public static boolean hasGas(ItemStack stack) {
        Optional capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY));
        if (capability.isPresent()) {
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            for (int tank = 0; tank < gasHandlerItem.getGasTankCount(); ++tank) {
                if (gasHandlerItem.getGasInTank(tank).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static void emit(IGasTank tank, TileEntity from) {
        GasUtils.emit(EnumSet.allOf(Direction.class), tank, from);
    }

    public static void emit(Set<Direction> outputSides, IGasTank tank, TileEntity from) {
        GasUtils.emit(outputSides, tank, from, tank.getCapacity());
    }

    public static void emit(Set<Direction> outputSides, IGasTank tank, TileEntity from, long maxOutput) {
        if (!tank.isEmpty() && maxOutput > 0L) {
            tank.extract(GasUtils.emit(outputSides, (GasStack)tank.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL), from), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static long emit(Set<Direction> sides, @Nonnull GasStack stack, TileEntity from) {
        if (stack.isEmpty() || sides.isEmpty()) {
            return 0L;
        }
        GasHandlerTarget target = new GasHandlerTarget(stack);
        GasStack unitStack = new GasStack(stack, 1L);
        EmitUtils.forEachSide(from.func_145831_w(), from.func_174877_v(), sides, (acceptor, side) -> {
            Direction accessSide = side.func_176734_d();
            CapabilityUtils.getCapability((ICapabilityProvider)acceptor, Capabilities.GAS_HANDLER_CAPABILITY, accessSide).ifPresent(handler -> {
                if (GasUtils.canInsert(handler, unitStack)) {
                    target.addHandler(accessSide, handler);
                }
            });
        });
        int curHandlers = target.getHandlers().size();
        if (curHandlers > 0) {
            ObjectOpenHashSet targets = new ObjectOpenHashSet();
            targets.add(target);
            return EmitUtils.sendToAcceptors(targets, curHandlers, stack.getAmount(), stack.copy());
        }
        return 0L;
    }

    public static boolean canInsert(IGasHandler handler, @Nonnull GasStack unitStack) {
        return handler.insertGas(unitStack, Action.SIMULATE).isEmpty();
    }
}

