/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.DataHandlerUtils;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.ColorRGBA;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.capabilities.proxy.ProxyHeatHandler;
import mekanism.common.capabilities.resolver.advanced.AdvancedCapabilityResolver;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.ConductorTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.grid.HeatNetwork;
import mekanism.common.upgrade.transmitter.ThermodynamicConductorUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityThermodynamicConductor
extends TileEntityTransmitter<IHeatHandler, HeatNetwork, Void>
implements ITileHeatHandler {
    public final ConductorTier tier;
    public double clientTemperature = 300.0;
    private final List<IHeatCapacitor> capacitors;
    public BasicHeatCapacitor buffer;

    public TileEntityThermodynamicConductor(IBlockProvider blockProvider) {
        super(blockProvider);
        this.tier = Attribute.getTier(blockProvider.getBlock(), ConductorTier.class);
        this.buffer = BasicHeatCapacitor.create(this.tier.getHeatCapacity(), this.tier.getInverseConduction(), this.tier.getInverseConductionInsulation(), this);
        this.capacitors = Collections.singletonList(this.buffer);
        this.addCapabilityResolver(AdvancedCapabilityResolver.readOnly(Capabilities.HEAT_HANDLER_CAPABILITY, this, () -> new ProxyHeatHandler(this, null, null)));
    }

    @Override
    public HeatNetwork createNewNetwork() {
        return new HeatNetwork();
    }

    @Override
    public HeatNetwork createNewNetworkWithID(UUID networkID) {
        return new HeatNetwork(networkID);
    }

    @Override
    public HeatNetwork createNetworkByMerging(Collection<HeatNetwork> networks) {
        return new HeatNetwork(networks);
    }

    @Override
    public long getCapacity() {
        return 0L;
    }

    @Override
    public Void getBuffer() {
        return null;
    }

    @Override
    public void takeShare() {
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.THERMODYNAMIC_CONDUCTOR;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, Direction side) {
        return this.isAcceptorAndListen(tile, side, Capabilities.HEAT_HANDLER_CAPABILITY);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.HEAT;
    }

    @Override
    public IHeatHandler getCachedAcceptor(Direction side) {
        return MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)this.getCachedTile(side), Capabilities.HEAT_HANDLER_CAPABILITY, side.func_176734_d())).orElse(null);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.buffer.serializeNBT();
        tag.func_218657_a("HeatCapacitors", (INBT)DataHandlerUtils.writeContainers(this.getHeatCapacitors(null)));
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        DataHandlerUtils.readContainers(this.getHeatCapacitors(null), tag.func_150295_c("HeatCapacitors", 10));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74780_a("temperature", this.buffer.getHeat());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setDoubleIfPresent(tag, "temperature", heat -> this.buffer.setHeat(heat));
    }

    public ColorRGBA getBaseColor() {
        return this.tier.getBaseColor();
    }

    @Override
    @Nonnull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.capacitors;
    }

    @Override
    public void onContentsChanged() {
        if (!this.field_145850_b.func_201670_d() && Math.abs(this.buffer.getTemperature() - this.clientTemperature) > this.buffer.getTemperature() / 20.0) {
            this.clientTemperature = this.buffer.getTemperature();
            this.sendUpdatePacket();
        }
        this.markDirty(false);
    }

    @Override
    @Nullable
    public IHeatHandler getAdjacent(Direction side) {
        if (TileEntityThermodynamicConductor.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
            TileEntity adj = MekanismUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(side));
            return MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_HANDLER_CAPABILITY, side.func_176734_d())).orElse(null);
        }
        return null;
    }

    @Override
    protected boolean canUpgrade(AlloyTier alloyTier) {
        return alloyTier.getBaseTier().ordinal() == this.tier.getBaseTier().ordinal() + 1;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        switch (tier) {
            case BASIC: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_THERMODYNAMIC_CONDUCTOR.getBlock().func_176223_P());
            }
            case ADVANCED: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_THERMODYNAMIC_CONDUCTOR.getBlock().func_176223_P());
            }
            case ELITE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_THERMODYNAMIC_CONDUCTOR.getBlock().func_176223_P());
            }
            case ULTIMATE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_THERMODYNAMIC_CONDUCTOR.getBlock().func_176223_P());
            }
        }
        return current;
    }

    @Override
    @Nullable
    protected ThermodynamicConductorUpgradeData getUpgradeData() {
        return new ThermodynamicConductorUpgradeData(this.redstoneReactive, this.connectionTypes, this.buffer.getHeat());
    }

    @Override
    protected void parseUpgradeData(@Nonnull TransmitterUpgradeData upgradeData) {
        if (upgradeData instanceof ThermodynamicConductorUpgradeData) {
            ThermodynamicConductorUpgradeData data = (ThermodynamicConductorUpgradeData)upgradeData;
            this.redstoneReactive = data.redstoneReactive;
            this.connectionTypes = data.connectionTypes;
            this.buffer.setHeat(data.heat);
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }
}

