/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTranslationKey;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.laser.TileEntityLaserReceptor;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;

public class TileEntityLaserAmplifier
extends TileEntityLaserReceptor
implements IHasMode {
    private static final FloatingLong MAX = FloatingLong.createConst(5000000000L);
    public FloatingLong minThreshold = FloatingLong.ZERO;
    public FloatingLong maxThreshold = MAX;
    public int ticks = 0;
    public int time = 0;
    public boolean emittingRedstone;
    public RedstoneOutput outputMode = RedstoneOutput.OFF;

    public TileEntityLaserAmplifier() {
        super(MekanismBlocks.LASER_AMPLIFIER);
    }

    @Override
    protected void addInitialEnergyContainers(EnergyContainerHelper builder) {
        this.energyContainer = LaserEnergyContainer.create(BasicEnergyContainer.alwaysTrue, BasicEnergyContainer.internalOnly, this);
        builder.addContainer(this.energyContainer);
    }

    @Override
    protected void onUpdateServer() {
        boolean prevRedstone = this.emittingRedstone;
        this.emittingRedstone = false;
        this.ticks = this.ticks < this.time ? ++this.ticks : 0;
        super.onUpdateServer();
        if (this.outputMode != RedstoneOutput.ENTITY_DETECTION) {
            this.emittingRedstone = false;
        }
        if (this.emittingRedstone != prevRedstone) {
            this.field_145850_b.func_195593_d(this.func_174877_v(), this.getBlockType());
        }
    }

    @Override
    protected void setEmittingRedstone(boolean foundEntity) {
        this.emittingRedstone = foundEntity;
    }

    private boolean shouldFire() {
        return this.ticks >= this.time && this.energyContainer.getEnergy().compareTo(this.minThreshold) >= 0 && MekanismUtils.canFunction(this);
    }

    @Override
    protected FloatingLong toFire() {
        return this.shouldFire() ? super.toFire().min(this.maxThreshold) : FloatingLong.ZERO;
    }

    @Override
    public int getRedstoneLevel() {
        if (this.outputMode == RedstoneOutput.ENERGY_CONTENTS) {
            return MekanismUtils.redstoneLevelFromContents(this.energyContainer.getEnergy(), this.energyContainer.getMaxEnergy());
        }
        return this.emittingRedstone ? 15 : 0;
    }

    public void setTime(int time) {
        this.time = Math.max(0, time);
        this.markDirty(false);
    }

    @Override
    public void nextMode() {
        this.outputMode = (RedstoneOutput)this.outputMode.getNext();
        this.markDirty(false);
    }

    public void setMinThresholdFromPacket(FloatingLong floatingLong) {
        FloatingLong maxEnergy = this.energyContainer.getMaxEnergy();
        this.minThreshold = maxEnergy.greaterThan(floatingLong) ? floatingLong : maxEnergy.copyAsConst();
        this.markDirty(false);
    }

    public void setMaxThresholdFromPacket(FloatingLong floatingLong) {
        FloatingLong maxEnergy = this.energyContainer.getMaxEnergy();
        this.maxThreshold = maxEnergy.greaterThan(floatingLong) ? floatingLong : maxEnergy.copyAsConst();
        this.markDirty(false);
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        NBTUtils.setFloatingLongIfPresent(nbtTags, "min", value -> {
            this.minThreshold = value;
        });
        NBTUtils.setFloatingLongIfPresent(nbtTags, "max", value -> {
            this.maxThreshold = value;
        });
        NBTUtils.setIntIfPresent(nbtTags, "time", value -> {
            this.time = value;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "outputMode", RedstoneOutput::byIndexStatic, mode -> {
            this.outputMode = mode;
        });
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74778_a("min", this.minThreshold.toString());
        nbtTags.func_74778_a("max", this.maxThreshold.toString());
        nbtTags.func_74768_a("time", this.time);
        nbtTags.func_74768_a("outputMode", this.outputMode.ordinal());
        return nbtTags;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFloatingLong.create(() -> this.minThreshold, value -> {
            this.minThreshold = value;
        }));
        container.track(SyncableFloatingLong.create(() -> this.maxThreshold, value -> {
            this.maxThreshold = value;
        }));
        container.track(SyncableInt.create(() -> this.time, value -> {
            this.time = value;
        }));
        container.track(SyncableEnum.create(RedstoneOutput::byIndexStatic, RedstoneOutput.OFF, () -> this.outputMode, value -> {
            this.outputMode = value;
        }));
    }

    public static enum RedstoneOutput implements IIncrementalEnum<RedstoneOutput>,
    IHasTranslationKey
    {
        OFF(MekanismLang.OFF),
        ENTITY_DETECTION(MekanismLang.ENTITY_DETECTION),
        ENERGY_CONTENTS(MekanismLang.ENERGY_CONTENTS);

        private static final RedstoneOutput[] MODES;
        private final ILangEntry langEntry;

        private RedstoneOutput(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public String getTranslationKey() {
            return this.langEntry.getTranslationKey();
        }

        @Override
        @Nonnull
        public RedstoneOutput byIndex(int index) {
            return RedstoneOutput.byIndexStatic(index);
        }

        public static RedstoneOutput byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = RedstoneOutput.values();
        }
    }
}

