/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.heat.HeatAPI;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.content.boiler.BoilerCache;
import mekanism.common.content.boiler.BoilerUpdateProtocol;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableGasStack;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.multiblock.IValveHandler;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityBoilerCasing
extends TileEntityMultiblock<SynchronizedBoilerData>
implements IValveHandler {
    public float prevWaterScale;
    public float prevSteamScale;

    public TileEntityBoilerCasing() {
        this(MekanismBlocks.BOILER_CASING);
    }

    public TileEntityBoilerCasing(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.structure != null && this.isRendering) {
            float steamScale;
            boolean newHot;
            boolean needsPacket = this.needsValveUpdate();
            boolean bl = newHot = ((SynchronizedBoilerData)this.structure).getTotalTemperature() >= SynchronizedBoilerData.BASE_BOIL_TEMP - 0.01;
            if (newHot != ((SynchronizedBoilerData)this.structure).clientHot) {
                needsPacket = true;
                ((SynchronizedBoilerData)this.structure).clientHot = newHot;
                SynchronizedBoilerData.hotMap.put((Object)((SynchronizedBoilerData)this.structure).inventoryID, ((SynchronizedBoilerData)this.structure).clientHot);
            }
            HeatAPI.HeatTransfer transfer = ((SynchronizedBoilerData)this.structure).simulate();
            ((SynchronizedBoilerData)this.structure).updateHeatCapacitors(null);
            ((SynchronizedBoilerData)this.structure).lastEnvironmentLoss = transfer.getEnvironmentTransfer();
            if (((SynchronizedBoilerData)this.structure).getTotalTemperature() >= SynchronizedBoilerData.BASE_BOIL_TEMP && !((SynchronizedBoilerData)this.structure).waterTank.isEmpty()) {
                double heatAvailable = ((SynchronizedBoilerData)this.structure).getHeatAvailable();
                ((SynchronizedBoilerData)this.structure).lastMaxBoil = (int)(heatAvailable / HeatUtils.getVaporizationEnthalpy());
                int amountToBoil = Math.min(((SynchronizedBoilerData)this.structure).lastMaxBoil, ((SynchronizedBoilerData)this.structure).waterTank.getFluidAmount());
                amountToBoil = Math.min(amountToBoil, MathUtils.clampToInt(((SynchronizedBoilerData)this.structure).steamTank.getNeeded()));
                if (!((SynchronizedBoilerData)this.structure).waterTank.isEmpty()) {
                    ((SynchronizedBoilerData)this.structure).waterTank.shrinkStack(amountToBoil, Action.EXECUTE);
                }
                if (((SynchronizedBoilerData)this.structure).steamTank.isEmpty()) {
                    ((SynchronizedBoilerData)this.structure).steamTank.setStack(MekanismGases.STEAM.getGasStack(amountToBoil));
                } else {
                    ((SynchronizedBoilerData)this.structure).steamTank.growStack(amountToBoil, Action.EXECUTE);
                }
                ((SynchronizedBoilerData)this.structure).handleHeat((double)(-amountToBoil) * HeatUtils.getVaporizationEnthalpy());
                ((SynchronizedBoilerData)this.structure).lastBoilRate = amountToBoil;
            } else {
                ((SynchronizedBoilerData)this.structure).lastBoilRate = 0;
                ((SynchronizedBoilerData)this.structure).lastMaxBoil = 0;
            }
            float waterScale = MekanismUtils.getScale(this.prevWaterScale, ((SynchronizedBoilerData)this.structure).waterTank);
            if (waterScale != this.prevWaterScale) {
                needsPacket = true;
                this.prevWaterScale = waterScale;
            }
            if ((steamScale = MekanismUtils.getScale(this.prevSteamScale, ((SynchronizedBoilerData)this.structure).steamTank)) != this.prevSteamScale) {
                needsPacket = true;
                this.prevSteamScale = steamScale;
            }
            if (needsPacket) {
                this.sendUpdatePacket();
            }
            this.markDirty(false);
        }
    }

    @Override
    @Nonnull
    protected SynchronizedBoilerData getNewStructure() {
        return new SynchronizedBoilerData(this);
    }

    public BoilerCache getNewCache() {
        return new BoilerCache();
    }

    protected BoilerUpdateProtocol getProtocol() {
        return new BoilerUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedBoilerData> getManager() {
        return Mekanism.boilerManager;
    }

    public double getLastEnvironmentLoss() {
        return this.structure == null ? 0.0 : ((SynchronizedBoilerData)this.structure).lastEnvironmentLoss;
    }

    public double getTemperature() {
        return this.structure == null ? 0.0 : ((SynchronizedBoilerData)this.structure).getTotalTemperature();
    }

    public int getLastBoilRate() {
        return this.structure == null ? 0 : ((SynchronizedBoilerData)this.structure).lastBoilRate;
    }

    public int getLastMaxBoil() {
        return this.structure == null ? 0 : ((SynchronizedBoilerData)this.structure).lastMaxBoil;
    }

    public int getSuperheatingElements() {
        return this.structure == null ? 0 : ((SynchronizedBoilerData)this.structure).superheatingElements;
    }

    @Override
    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors() {
        return side -> this.structure == null ? Collections.emptyList() : ((SynchronizedBoilerData)this.structure).getHeatCapacitors(side);
    }

    @Override
    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.HEAT) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    public Collection<IValveHandler.ValveData> getValveData() {
        return this.structure != null ? ((SynchronizedBoilerData)this.structure).valves : null;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        if (this.structure != null && this.isRendering) {
            updateTag.func_74776_a("scale", this.prevWaterScale);
            updateTag.func_74776_a("scaleAlt", this.prevSteamScale);
            updateTag.func_74768_a("volume", ((SynchronizedBoilerData)this.structure).getWaterVolume());
            updateTag.func_74772_a("lowerVolume", ((SynchronizedBoilerData)this.structure).getSteamVolume());
            updateTag.func_218657_a("fluid", (INBT)((SynchronizedBoilerData)this.structure).waterTank.getFluid().writeToNBT(new CompoundNBT()));
            updateTag.func_218657_a("gas", (INBT)((GasStack)((SynchronizedBoilerData)this.structure).steamTank.getStack()).write(new CompoundNBT()));
            updateTag.func_218657_a("renderY", (INBT)((SynchronizedBoilerData)this.structure).upperRenderLocation.write(new CompoundNBT()));
            updateTag.func_74757_a("hot", ((SynchronizedBoilerData)this.structure).clientHot);
            this.writeValves(updateTag);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        if (this.clientHasStructure && this.isRendering && this.structure != null) {
            NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
                this.prevWaterScale = scale;
            });
            NBTUtils.setFloatIfPresent(tag, "scaleAlt", scale -> {
                this.prevSteamScale = scale;
            });
            NBTUtils.setIntIfPresent(tag, "volume", value -> ((SynchronizedBoilerData)this.structure).setWaterVolume(value));
            NBTUtils.setLongIfPresent(tag, "lowerVolume", value -> ((SynchronizedBoilerData)this.structure).setSteamVolume(value));
            NBTUtils.setFluidStackIfPresent(tag, "fluid", value -> ((SynchronizedBoilerData)this.structure).waterTank.setStack((FluidStack)value));
            NBTUtils.setGasStackIfPresent(tag, "gas", value -> ((SynchronizedBoilerData)this.structure).steamTank.setStack(value));
            NBTUtils.setCoord4DIfPresent(tag, "renderY", value -> {
                ((SynchronizedBoilerData)this.structure).upperRenderLocation = value;
            });
            NBTUtils.setBooleanIfPresent(tag, "hot", value -> {
                ((SynchronizedBoilerData)this.structure).clientHot = value;
            });
            this.readValves(tag);
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedBoilerData)this.structure).getWaterVolume(), value -> {
            if (this.structure != null) {
                ((SynchronizedBoilerData)this.structure).setWaterVolume(value);
            }
        }));
        container.track(SyncableLong.create(() -> this.structure == null ? 0L : ((SynchronizedBoilerData)this.structure).getSteamVolume(), value -> {
            if (this.structure != null) {
                ((SynchronizedBoilerData)this.structure).setSteamVolume(value);
            }
        }));
        container.track(SyncableFluidStack.create(() -> this.structure == null ? FluidStack.EMPTY : ((SynchronizedBoilerData)this.structure).waterTank.getFluid(), value -> {
            if (this.structure != null) {
                ((SynchronizedBoilerData)this.structure).waterTank.setStack((FluidStack)value);
            }
        }));
        container.track(SyncableGasStack.create(() -> this.structure == null ? GasStack.EMPTY : (GasStack)((SynchronizedBoilerData)this.structure).steamTank.getStack(), value -> {
            if (this.structure != null) {
                ((SynchronizedBoilerData)this.structure).steamTank.setStack(value);
            }
        }));
        container.track(SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            if (this.structure != null) {
                ((SynchronizedBoilerData)this.structure).lastEnvironmentLoss = value;
            }
        }));
        container.track(SyncableInt.create(this::getLastBoilRate, value -> {
            if (this.structure != null) {
                ((SynchronizedBoilerData)this.structure).lastBoilRate = value;
            }
        }));
        container.track(SyncableInt.create(this::getSuperheatingElements, value -> {
            if (this.structure != null) {
                ((SynchronizedBoilerData)this.structure).superheatingElements = value;
            }
        }));
        container.track(SyncableDouble.create(() -> this.structure == null ? 0.0 : ((SynchronizedBoilerData)this.structure).heatCapacitor.getHeat(), value -> {
            if (this.structure != null) {
                ((SynchronizedBoilerData)this.structure).heatCapacitor.setHeat(value);
            }
        }));
        container.track(SyncableDouble.create(() -> this.structure == null ? 0.0 : ((SynchronizedBoilerData)this.structure).heatCapacitor.getHeatCapacity(), value -> {
            if (this.structure != null) {
                ((SynchronizedBoilerData)this.structure).heatCapacitor.setHeatCapacity(value, false);
            }
        }));
        container.track(SyncableInt.create(this::getLastMaxBoil, value -> {
            if (this.structure != null) {
                ((SynchronizedBoilerData)this.structure).lastMaxBoil = value;
            }
        }));
    }
}

