/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.tier.ITier;
import mekanism.client.render.item.ISTERProvider;
import mekanism.common.Resource;
import mekanism.common.block.BlockBounding;
import mekanism.common.block.BlockCardboardBox;
import mekanism.common.block.BlockEnergyCube;
import mekanism.common.block.BlockOre;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.basic.BlockBin;
import mekanism.common.block.basic.BlockFluidTank;
import mekanism.common.block.basic.BlockLogisticalSorter;
import mekanism.common.block.basic.BlockPressureDisperser;
import mekanism.common.block.basic.BlockResource;
import mekanism.common.block.basic.BlockSecurityDesk;
import mekanism.common.block.basic.BlockStructuralGlass;
import mekanism.common.block.basic.BlockTeleporterFrame;
import mekanism.common.block.machine.prefab.BlockBase;
import mekanism.common.block.machine.prefab.BlockBasicMultiblock;
import mekanism.common.block.machine.prefab.BlockFactoryMachine;
import mekanism.common.block.machine.prefab.BlockTile;
import mekanism.common.block.transmitter.BlockDiversionTransporter;
import mekanism.common.block.transmitter.BlockLogisticalTransporter;
import mekanism.common.block.transmitter.BlockMechanicalPipe;
import mekanism.common.block.transmitter.BlockPressurizedTube;
import mekanism.common.block.transmitter.BlockRestrictiveTransporter;
import mekanism.common.block.transmitter.BlockThermodynamicConductor;
import mekanism.common.block.transmitter.BlockUniversalCable;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.Factory;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.item.block.ItemBlockCardboardBox;
import mekanism.common.item.block.ItemBlockEnergyCube;
import mekanism.common.item.block.ItemBlockGasTank;
import mekanism.common.item.block.ItemBlockInductionCell;
import mekanism.common.item.block.ItemBlockInductionProvider;
import mekanism.common.item.block.ItemBlockResource;
import mekanism.common.item.block.ItemBlockSecurityDesk;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.block.machine.ItemBlockChargepad;
import mekanism.common.item.block.machine.ItemBlockDigitalMiner;
import mekanism.common.item.block.machine.ItemBlockFactory;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.item.block.machine.ItemBlockFuelwoodHeater;
import mekanism.common.item.block.machine.ItemBlockLaser;
import mekanism.common.item.block.machine.ItemBlockLaserAmplifier;
import mekanism.common.item.block.machine.ItemBlockLaserTractorBeam;
import mekanism.common.item.block.machine.ItemBlockLogisticalSorter;
import mekanism.common.item.block.machine.ItemBlockMachine;
import mekanism.common.item.block.machine.ItemBlockOredictionificator;
import mekanism.common.item.block.machine.ItemBlockPersonalChest;
import mekanism.common.item.block.machine.ItemBlockQuantumEntangloporter;
import mekanism.common.item.block.machine.ItemBlockSeismicVibrator;
import mekanism.common.item.block.machine.ItemBlockSolarNeutronActivator;
import mekanism.common.item.block.transmitter.ItemBlockDiversionTransporter;
import mekanism.common.item.block.transmitter.ItemBlockLogisticalTransporter;
import mekanism.common.item.block.transmitter.ItemBlockMechanicalPipe;
import mekanism.common.item.block.transmitter.ItemBlockPressurizedTube;
import mekanism.common.item.block.transmitter.ItemBlockRestrictiveTransporter;
import mekanism.common.item.block.transmitter.ItemBlockThermodynamicConductor;
import mekanism.common.item.block.transmitter.ItemBlockUniversalCable;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.tier.CableTier;
import mekanism.common.tier.ConductorTier;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tier.PipeTier;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tier.TubeTier;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityBoilerValve;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityChemicalCrystallizer;
import mekanism.common.tile.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.TileEntityChemicalInfuser;
import mekanism.common.tile.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.tile.TileEntityChemicalWasher;
import mekanism.common.tile.TileEntityCombiner;
import mekanism.common.tile.TileEntityCrusher;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityDynamicValve;
import mekanism.common.tile.TileEntityElectricPump;
import mekanism.common.tile.TileEntityElectrolyticSeparator;
import mekanism.common.tile.TileEntityEnergizedSmelter;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityEnrichmentChamber;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityFluidicPlenisher;
import mekanism.common.tile.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.TileEntityFuelwoodHeater;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionPort;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.tile.TileEntityMetallurgicInfuser;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.tile.TileEntityOsmiumCompressor;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.tile.TileEntityPrecisionSawmill;
import mekanism.common.tile.TileEntityPressurizedReactionChamber;
import mekanism.common.tile.TileEntityPurificationChamber;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.tile.TileEntityRotaryCondensentrator;
import mekanism.common.tile.TileEntitySeismicVibrator;
import mekanism.common.tile.TileEntitySolarNeutronActivator;
import mekanism.common.tile.TileEntitySuperheatingElement;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.tile.TileEntityThermalEvaporationValve;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.laser.TileEntityLaser;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.laser.TileEntityLaserTractorBeam;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;

public class MekanismBlocks {
    public static final BlockDeferredRegister BLOCKS = new BlockDeferredRegister("mekanism");
    private static final Table<FactoryTier, FactoryType, BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory>> FACTORIES = HashBasedTable.create();
    public static final BlockRegistryObject<BlockResource, ItemBlockResource> OSMIUM_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockResource> BRONZE_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockResource> REFINED_OBSIDIAN_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockResource> CHARCOAL_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockResource> REFINED_GLOWSTONE_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockResource> STEEL_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockResource> COPPER_BLOCK;
    public static final BlockRegistryObject<BlockResource, ItemBlockResource> TIN_BLOCK;
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> BASIC_BIN;
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> ADVANCED_BIN;
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> ELITE_BIN;
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> ULTIMATE_BIN;
    public static final BlockRegistryObject<BlockBin, ItemBlockBin> CREATIVE_BIN;
    public static final BlockRegistryObject<BlockTeleporterFrame, ItemBlockTooltip<BlockTeleporterFrame>> TELEPORTER_FRAME;
    public static final BlockRegistryObject<BlockBase<BlockType>, ItemBlockTooltip<BlockBase<BlockType>>> STEEL_CASING;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityDynamicTank>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityDynamicTank>>> DYNAMIC_TANK;
    public static final BlockRegistryObject<BlockStructuralGlass, ItemBlockTooltip<BlockStructuralGlass>> STRUCTURAL_GLASS;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityDynamicValve>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityDynamicValve>>> DYNAMIC_VALVE;
    public static final BlockRegistryObject<BlockTile<TileEntityThermalEvaporationController, BlockTypeTile<TileEntityThermalEvaporationController>>, ItemBlockTooltip<BlockTile<TileEntityThermalEvaporationController, BlockTypeTile<TileEntityThermalEvaporationController>>>> THERMAL_EVAPORATION_CONTROLLER;
    public static final BlockRegistryObject<BlockTile<TileEntityThermalEvaporationValve, BlockTypeTile<TileEntityThermalEvaporationValve>>, ItemBlockTooltip<BlockTile<TileEntityThermalEvaporationValve, BlockTypeTile<TileEntityThermalEvaporationValve>>>> THERMAL_EVAPORATION_VALVE;
    public static final BlockRegistryObject<BlockTile<TileEntityThermalEvaporationBlock, BlockTypeTile<TileEntityThermalEvaporationBlock>>, ItemBlockTooltip<BlockTile<TileEntityThermalEvaporationBlock, BlockTypeTile<TileEntityThermalEvaporationBlock>>>> THERMAL_EVAPORATION_BLOCK;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityInductionCasing>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityInductionCasing>>> INDUCTION_CASING;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityInductionPort>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityInductionPort>>> INDUCTION_PORT;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> BASIC_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> ADVANCED_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> ELITE_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> ULTIMATE_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> BASIC_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> ADVANCED_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> ELITE_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> ULTIMATE_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<TileEntitySuperheatingElement, BlockTypeTile<TileEntitySuperheatingElement>>, ItemBlockTooltip<BlockTile<TileEntitySuperheatingElement, BlockTypeTile<TileEntitySuperheatingElement>>>> SUPERHEATING_ELEMENT;
    public static final BlockRegistryObject<BlockPressureDisperser, ItemBlockTooltip<BlockPressureDisperser>> PRESSURE_DISPERSER;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityBoilerCasing>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityBoilerCasing>>> BOILER_CASING;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityBoilerValve>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityBoilerValve>>> BOILER_VALVE;
    public static final BlockRegistryObject<BlockSecurityDesk, ItemBlockSecurityDesk> SECURITY_DESK;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityEnrichmentChamber, Machine.FactoryMachine<TileEntityEnrichmentChamber>>, ItemBlockMachine> ENRICHMENT_CHAMBER;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityOsmiumCompressor, Machine.FactoryMachine<TileEntityOsmiumCompressor>>, ItemBlockMachine> OSMIUM_COMPRESSOR;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityCombiner, Machine.FactoryMachine<TileEntityCombiner>>, ItemBlockMachine> COMBINER;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityCrusher, Machine.FactoryMachine<TileEntityCrusher>>, ItemBlockMachine> CRUSHER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityDigitalMiner, Machine<TileEntityDigitalMiner>>, ItemBlockDigitalMiner> DIGITAL_MINER;
    public static final BlockRegistryObject<BlockFactoryMachine.BlockFactoryMachineModel<TileEntityMetallurgicInfuser>, ItemBlockMachine> METALLURGIC_INFUSER;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityPurificationChamber, Machine.FactoryMachine<TileEntityPurificationChamber>>, ItemBlockMachine> PURIFICATION_CHAMBER;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityEnergizedSmelter, Machine.FactoryMachine<TileEntityEnergizedSmelter>>, ItemBlockMachine> ENERGIZED_SMELTER;
    public static final BlockRegistryObject<BlockTile<TileEntityTeleporter, Machine<TileEntityTeleporter>>, ItemBlockMachine> TELEPORTER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityElectricPump, Machine<TileEntityElectricPump>>, ItemBlockMachine> ELECTRIC_PUMP;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityPersonalChest, BlockTypeTile<TileEntityPersonalChest>>, ItemBlockPersonalChest> PERSONAL_CHEST;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChargepad, BlockTypeTile<TileEntityChargepad>>, ItemBlockChargepad> CHARGEPAD;
    public static final BlockRegistryObject<BlockLogisticalSorter, ItemBlockLogisticalSorter> LOGISTICAL_SORTER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityRotaryCondensentrator, Machine<TileEntityRotaryCondensentrator>>, ItemBlockMachine> ROTARY_CONDENSENTRATOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalOxidizer, Machine<TileEntityChemicalOxidizer>>, ItemBlockMachine> CHEMICAL_OXIDIZER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalInfuser, Machine<TileEntityChemicalInfuser>>, ItemBlockMachine> CHEMICAL_INFUSER;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityChemicalInjectionChamber, Machine.FactoryMachine<TileEntityChemicalInjectionChamber>>, ItemBlockMachine> CHEMICAL_INJECTION_CHAMBER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityElectrolyticSeparator, Machine<TileEntityElectrolyticSeparator>>, ItemBlockMachine> ELECTROLYTIC_SEPARATOR;
    public static final BlockRegistryObject<BlockFactoryMachine<TileEntityPrecisionSawmill, Machine.FactoryMachine<TileEntityPrecisionSawmill>>, ItemBlockMachine> PRECISION_SAWMILL;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalDissolutionChamber, Machine<TileEntityChemicalDissolutionChamber>>, ItemBlockMachine> CHEMICAL_DISSOLUTION_CHAMBER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalWasher, Machine<TileEntityChemicalWasher>>, ItemBlockMachine> CHEMICAL_WASHER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityChemicalCrystallizer, Machine<TileEntityChemicalCrystallizer>>, ItemBlockMachine> CHEMICAL_CRYSTALLIZER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntitySeismicVibrator, Machine<TileEntitySeismicVibrator>>, ItemBlockSeismicVibrator> SEISMIC_VIBRATOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityPressurizedReactionChamber, Machine<TileEntityPressurizedReactionChamber>>, ItemBlockMachine> PRESSURIZED_REACTION_CHAMBER;
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> BASIC_FLUID_TANK;
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> ADVANCED_FLUID_TANK;
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> ELITE_FLUID_TANK;
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> ULTIMATE_FLUID_TANK;
    public static final BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> CREATIVE_FLUID_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityFluidicPlenisher, Machine<TileEntityFluidicPlenisher>>, ItemBlockMachine> FLUIDIC_PLENISHER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityLaser, BlockTypeTile<TileEntityLaser>>, ItemBlockLaser> LASER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityLaserAmplifier, BlockTypeTile<TileEntityLaserAmplifier>>, ItemBlockLaserAmplifier> LASER_AMPLIFIER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityLaserTractorBeam, BlockTypeTile<TileEntityLaserTractorBeam>>, ItemBlockLaserTractorBeam> LASER_TRACTOR_BEAM;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityQuantumEntangloporter, Machine<TileEntityQuantumEntangloporter>>, ItemBlockQuantumEntangloporter> QUANTUM_ENTANGLOPORTER;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntitySolarNeutronActivator, Machine<TileEntitySolarNeutronActivator>>, ItemBlockSolarNeutronActivator> SOLAR_NEUTRON_ACTIVATOR;
    public static final BlockRegistryObject<BlockTile<TileEntityOredictionificator, BlockTypeTile<TileEntityOredictionificator>>, ItemBlockOredictionificator> OREDICTIONIFICATOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityResistiveHeater, Machine<TileEntityResistiveHeater>>, ItemBlockMachine> RESISTIVE_HEATER;
    public static final BlockRegistryObject<BlockTile<TileEntityFormulaicAssemblicator, Machine<TileEntityFormulaicAssemblicator>>, ItemBlockMachine> FORMULAIC_ASSEMBLICATOR;
    public static final BlockRegistryObject<BlockTile<TileEntityFuelwoodHeater, BlockTypeTile<TileEntityFuelwoodHeater>>, ItemBlockFuelwoodHeater> FUELWOOD_HEATER;
    public static final BlockRegistryObject<BlockOre, ItemBlockTooltip<BlockOre>> OSMIUM_ORE;
    public static final BlockRegistryObject<BlockOre, ItemBlockTooltip<BlockOre>> COPPER_ORE;
    public static final BlockRegistryObject<BlockOre, ItemBlockTooltip<BlockOre>> TIN_ORE;
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> BASIC_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> ADVANCED_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> ELITE_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> ULTIMATE_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> CREATIVE_ENERGY_CUBE;
    public static final BlockRegistryObject<BlockUniversalCable, ItemBlockUniversalCable> BASIC_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockUniversalCable, ItemBlockUniversalCable> ADVANCED_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockUniversalCable, ItemBlockUniversalCable> ELITE_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockUniversalCable, ItemBlockUniversalCable> ULTIMATE_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockMechanicalPipe, ItemBlockMechanicalPipe> BASIC_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockMechanicalPipe, ItemBlockMechanicalPipe> ADVANCED_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockMechanicalPipe, ItemBlockMechanicalPipe> ELITE_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockMechanicalPipe, ItemBlockMechanicalPipe> ULTIMATE_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockPressurizedTube, ItemBlockPressurizedTube> BASIC_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockPressurizedTube, ItemBlockPressurizedTube> ADVANCED_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockPressurizedTube, ItemBlockPressurizedTube> ELITE_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockPressurizedTube, ItemBlockPressurizedTube> ULTIMATE_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockLogisticalTransporter, ItemBlockLogisticalTransporter> BASIC_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLogisticalTransporter, ItemBlockLogisticalTransporter> ADVANCED_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLogisticalTransporter, ItemBlockLogisticalTransporter> ELITE_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLogisticalTransporter, ItemBlockLogisticalTransporter> ULTIMATE_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockRestrictiveTransporter, ItemBlockRestrictiveTransporter> RESTRICTIVE_TRANSPORTER;
    public static final BlockRegistryObject<BlockDiversionTransporter, ItemBlockDiversionTransporter> DIVERSION_TRANSPORTER;
    public static final BlockRegistryObject<BlockThermodynamicConductor, ItemBlockThermodynamicConductor> BASIC_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockThermodynamicConductor, ItemBlockThermodynamicConductor> ADVANCED_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockThermodynamicConductor, ItemBlockThermodynamicConductor> ELITE_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockThermodynamicConductor, ItemBlockThermodynamicConductor> ULTIMATE_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockBounding, BlockItem> BOUNDING_BLOCK;
    public static final BlockRegistryObject<BlockBounding, BlockItem> ADVANCED_BOUNDING_BLOCK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityGasTank, Machine<TileEntityGasTank>>, ItemBlockGasTank> BASIC_GAS_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityGasTank, Machine<TileEntityGasTank>>, ItemBlockGasTank> ADVANCED_GAS_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityGasTank, Machine<TileEntityGasTank>>, ItemBlockGasTank> ELITE_GAS_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityGasTank, Machine<TileEntityGasTank>>, ItemBlockGasTank> ULTIMATE_GAS_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityGasTank, Machine<TileEntityGasTank>>, ItemBlockGasTank> CREATIVE_GAS_TANK;
    public static final BlockRegistryObject<BlockCardboardBox, ItemBlockCardboardBox> CARDBOARD_BOX;
    public static final BlockRegistryObject<Block, BlockItem> SALT_BLOCK;

    private static BlockRegistryObject<BlockBounding, BlockItem> registerBoundingBlock(String name, Supplier<BlockBounding> blockSupplier) {
        return BLOCKS.register(name, blockSupplier, block -> new BlockItem((Block)block, new Item.Properties().func_200916_a(null)));
    }

    private static BlockRegistryObject<BlockResource, ItemBlockResource> registerResourceBlock(BlockResourceInfo resource) {
        return BLOCKS.register("block_" + resource.getRegistrySuffix(), () -> new BlockResource(resource), ItemBlockResource::new);
    }

    private static BlockRegistryObject<BlockBin, ItemBlockBin> registerBin(BlockTypeTile<TileEntityBin> type) {
        return MekanismBlocks.registerTieredBlock(type.get(AttributeTier.class).getTier(), "_bin", () -> new BlockBin(type), ItemBlockBin::new);
    }

    private static BlockRegistryObject<BlockTile<TileEntityInductionCell, BlockTypeTile<TileEntityInductionCell>>, ItemBlockInductionCell> registerInductionCell(BlockTypeTile<TileEntityInductionCell> type) {
        return MekanismBlocks.registerTieredBlock(type.get(AttributeTier.class).getTier(), "_induction_cell", () -> new BlockTile(type), ItemBlockInductionCell::new);
    }

    private static BlockRegistryObject<BlockTile<TileEntityInductionProvider, BlockTypeTile<TileEntityInductionProvider>>, ItemBlockInductionProvider> registerInductionProvider(BlockTypeTile<TileEntityInductionProvider> type) {
        return MekanismBlocks.registerTieredBlock(type.get(AttributeTier.class).getTier(), "_induction_provider", () -> new BlockTile(type), ItemBlockInductionProvider::new);
    }

    private static BlockRegistryObject<BlockFluidTank, ItemBlockFluidTank> registerFluidTank(Machine<TileEntityFluidTank> type) {
        return MekanismBlocks.registerTieredBlock(type.get(AttributeTier.class).getTier(), "_fluid_tank", () -> new BlockFluidTank(type), ItemBlockFluidTank::new);
    }

    private static BlockRegistryObject<BlockEnergyCube, ItemBlockEnergyCube> registerEnergyCube(Machine<TileEntityEnergyCube> type) {
        return MekanismBlocks.registerTieredBlock(type.get(AttributeTier.class).getTier(), "_energy_cube", () -> new BlockEnergyCube(type), ItemBlockEnergyCube::new);
    }

    private static BlockRegistryObject<BlockUniversalCable, ItemBlockUniversalCable> registerUniversalCable(CableTier tier) {
        return MekanismBlocks.registerTieredBlock(tier, "_universal_cable", () -> new BlockUniversalCable(tier), ItemBlockUniversalCable::new);
    }

    private static BlockRegistryObject<BlockMechanicalPipe, ItemBlockMechanicalPipe> registerMechanicalPipe(PipeTier tier) {
        return MekanismBlocks.registerTieredBlock(tier, "_mechanical_pipe", () -> new BlockMechanicalPipe(tier), ItemBlockMechanicalPipe::new);
    }

    private static BlockRegistryObject<BlockPressurizedTube, ItemBlockPressurizedTube> registerPressurizedTube(TubeTier tier) {
        return MekanismBlocks.registerTieredBlock(tier, "_pressurized_tube", () -> new BlockPressurizedTube(tier), ItemBlockPressurizedTube::new);
    }

    private static BlockRegistryObject<BlockLogisticalTransporter, ItemBlockLogisticalTransporter> registerLogisticalTransporter(TransporterTier tier) {
        return MekanismBlocks.registerTieredBlock(tier, "_logistical_transporter", () -> new BlockLogisticalTransporter(tier), ItemBlockLogisticalTransporter::new);
    }

    private static BlockRegistryObject<BlockThermodynamicConductor, ItemBlockThermodynamicConductor> registerThermodynamicConductor(ConductorTier tier) {
        return MekanismBlocks.registerTieredBlock(tier, "_thermodynamic_conductor", () -> new BlockThermodynamicConductor(tier), ItemBlockThermodynamicConductor::new);
    }

    private static BlockRegistryObject<BlockTile.BlockTileModel<TileEntityGasTank, Machine<TileEntityGasTank>>, ItemBlockGasTank> registerGasTank(Machine<TileEntityGasTank> type) {
        return MekanismBlocks.registerTieredBlock(type.get(AttributeTier.class).getTier(), "_gas_tank", () -> new BlockTile.BlockTileModel(type), ItemBlockGasTank::new);
    }

    private static <TILE extends TileEntityFactory<?>> BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory> registerFactory(Factory<TILE> type) {
        return MekanismBlocks.registerTieredBlock(type.get(AttributeTier.class).getTier(), "_" + type.get(AttributeFactoryType.class).getFactoryType().getRegistryNameComponent() + "_factory", () -> new BlockFactoryMachine.BlockFactory(type), ItemBlockFactory::new);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(ITier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, Function<BLOCK, ITEM> itemCreator) {
        return BLOCKS.register(tier.getBaseTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }

    private static BlockRegistryObject<BlockOre, ItemBlockTooltip<BlockOre>> registerOre(Resource resource) {
        return BLOCKS.registerDefaultProperties(resource.getRegistrySuffix() + "_ore", () -> new BlockOre(resource), ItemBlockTooltip::new);
    }

    private static <BLOCK extends Block> BlockRegistryObject<BLOCK, ItemBlockTooltip<BLOCK>> registerBlock(String name, Supplier<? extends BLOCK> blockSupplier) {
        return BLOCKS.registerDefaultProperties(name, blockSupplier, (x$0, x$1) -> new ItemBlockTooltip<Block>((Block)x$0, (Item.Properties)x$1));
    }

    public static BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory> getFactory(@Nonnull FactoryTier tier, @Nonnull FactoryType type) {
        return (BlockRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static BlockRegistryObject<BlockFactoryMachine.BlockFactory<?>, ItemBlockFactory>[] getFactoryBlocks() {
        return FACTORIES.values().toArray(new BlockRegistryObject[0]);
    }

    static {
        for (FactoryTier tier : FactoryTier.values()) {
            for (FactoryType type : FactoryType.values()) {
                FACTORIES.put((Object)tier, (Object)type, MekanismBlocks.registerFactory(MekanismBlockTypes.getFactory(tier, type)));
            }
        }
        OSMIUM_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.OSMIUM);
        BRONZE_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.BRONZE);
        REFINED_OBSIDIAN_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.REFINED_OBSIDIAN);
        CHARCOAL_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.CHARCOAL);
        REFINED_GLOWSTONE_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.REFINED_GLOWSTONE);
        STEEL_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.STEEL);
        COPPER_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.COPPER);
        TIN_BLOCK = MekanismBlocks.registerResourceBlock(BlockResourceInfo.TIN);
        BASIC_BIN = MekanismBlocks.registerBin(MekanismBlockTypes.BASIC_BIN);
        ADVANCED_BIN = MekanismBlocks.registerBin(MekanismBlockTypes.ADVANCED_BIN);
        ELITE_BIN = MekanismBlocks.registerBin(MekanismBlockTypes.ELITE_BIN);
        ULTIMATE_BIN = MekanismBlocks.registerBin(MekanismBlockTypes.ULTIMATE_BIN);
        CREATIVE_BIN = MekanismBlocks.registerBin(MekanismBlockTypes.CREATIVE_BIN);
        TELEPORTER_FRAME = MekanismBlocks.registerBlock("teleporter_frame", BlockTeleporterFrame::new);
        STEEL_CASING = MekanismBlocks.registerBlock("steel_casing", () -> new BlockBase<BlockType>(MekanismBlockTypes.STEEL_CASING));
        DYNAMIC_TANK = MekanismBlocks.registerBlock("dynamic_tank", () -> new BlockBasicMultiblock<TileEntityDynamicTank>(MekanismBlockTypes.DYNAMIC_TANK));
        STRUCTURAL_GLASS = MekanismBlocks.registerBlock("structural_glass", BlockStructuralGlass::new);
        DYNAMIC_VALVE = MekanismBlocks.registerBlock("dynamic_valve", () -> new BlockBasicMultiblock<TileEntityDynamicValve>(MekanismBlockTypes.DYNAMIC_VALVE));
        THERMAL_EVAPORATION_CONTROLLER = MekanismBlocks.registerBlock("thermal_evaporation_controller", () -> new BlockTile(MekanismBlockTypes.THERMAL_EVAPORATION_CONTROLLER));
        THERMAL_EVAPORATION_VALVE = MekanismBlocks.registerBlock("thermal_evaporation_valve", () -> new BlockTile(MekanismBlockTypes.THERMAL_EVAPORATION_VALVE));
        THERMAL_EVAPORATION_BLOCK = MekanismBlocks.registerBlock("thermal_evaporation_block", () -> new BlockTile(MekanismBlockTypes.THERMAL_EVAPORATION_BLOCK));
        INDUCTION_CASING = MekanismBlocks.registerBlock("induction_casing", () -> new BlockBasicMultiblock<TileEntityInductionCasing>(MekanismBlockTypes.INDUCTION_CASING));
        INDUCTION_PORT = MekanismBlocks.registerBlock("induction_port", () -> new BlockBasicMultiblock<TileEntityInductionPort>(MekanismBlockTypes.INDUCTION_PORT));
        BASIC_INDUCTION_CELL = MekanismBlocks.registerInductionCell(MekanismBlockTypes.BASIC_INDUCTION_CELL);
        ADVANCED_INDUCTION_CELL = MekanismBlocks.registerInductionCell(MekanismBlockTypes.ADVANCED_INDUCTION_CELL);
        ELITE_INDUCTION_CELL = MekanismBlocks.registerInductionCell(MekanismBlockTypes.ELITE_INDUCTION_CELL);
        ULTIMATE_INDUCTION_CELL = MekanismBlocks.registerInductionCell(MekanismBlockTypes.ULTIMATE_INDUCTION_CELL);
        BASIC_INDUCTION_PROVIDER = MekanismBlocks.registerInductionProvider(MekanismBlockTypes.BASIC_INDUCTION_PROVIDER);
        ADVANCED_INDUCTION_PROVIDER = MekanismBlocks.registerInductionProvider(MekanismBlockTypes.ADVANCED_INDUCTION_PROVIDER);
        ELITE_INDUCTION_PROVIDER = MekanismBlocks.registerInductionProvider(MekanismBlockTypes.ELITE_INDUCTION_PROVIDER);
        ULTIMATE_INDUCTION_PROVIDER = MekanismBlocks.registerInductionProvider(MekanismBlockTypes.ULTIMATE_INDUCTION_PROVIDER);
        SUPERHEATING_ELEMENT = MekanismBlocks.registerBlock("superheating_element", () -> new BlockTile(MekanismBlockTypes.SUPERHEATING_ELEMENT));
        PRESSURE_DISPERSER = MekanismBlocks.registerBlock("pressure_disperser", BlockPressureDisperser::new);
        BOILER_CASING = MekanismBlocks.registerBlock("boiler_casing", () -> new BlockBasicMultiblock<TileEntityBoilerCasing>(MekanismBlockTypes.BOILER_CASING));
        BOILER_VALVE = MekanismBlocks.registerBlock("boiler_valve", () -> new BlockBasicMultiblock<TileEntityBoilerValve>(MekanismBlockTypes.BOILER_VALVE));
        SECURITY_DESK = BLOCKS.register("security_desk", BlockSecurityDesk::new, ItemBlockSecurityDesk::new);
        ENRICHMENT_CHAMBER = BLOCKS.register("enrichment_chamber", () -> new BlockFactoryMachine(MekanismBlockTypes.ENRICHMENT_CHAMBER), ItemBlockMachine::new);
        OSMIUM_COMPRESSOR = BLOCKS.register("osmium_compressor", () -> new BlockFactoryMachine(MekanismBlockTypes.OSMIUM_COMPRESSOR), ItemBlockMachine::new);
        COMBINER = BLOCKS.register("combiner", () -> new BlockFactoryMachine(MekanismBlockTypes.COMBINER), ItemBlockMachine::new);
        CRUSHER = BLOCKS.register("crusher", () -> new BlockFactoryMachine(MekanismBlockTypes.CRUSHER), ItemBlockMachine::new);
        DIGITAL_MINER = BLOCKS.register("digital_miner", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.DIGITAL_MINER), ItemBlockDigitalMiner::new);
        METALLURGIC_INFUSER = BLOCKS.register("metallurgic_infuser", () -> new BlockFactoryMachine.BlockFactoryMachineModel<TileEntityMetallurgicInfuser>(MekanismBlockTypes.METALLURGIC_INFUSER), ItemBlockMachine::new);
        PURIFICATION_CHAMBER = BLOCKS.register("purification_chamber", () -> new BlockFactoryMachine(MekanismBlockTypes.PURIFICATION_CHAMBER), ItemBlockMachine::new);
        ENERGIZED_SMELTER = BLOCKS.register("energized_smelter", () -> new BlockFactoryMachine(MekanismBlockTypes.ENERGIZED_SMELTER), ItemBlockMachine::new);
        TELEPORTER = BLOCKS.register("teleporter", () -> new BlockTile(MekanismBlockTypes.TELEPORTER), ItemBlockMachine::new);
        ELECTRIC_PUMP = BLOCKS.register("electric_pump", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.ELECTRIC_PUMP), ItemBlockMachine::new);
        PERSONAL_CHEST = BLOCKS.register("personal_chest", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.PERSONAL_CHEST), ItemBlockPersonalChest::new);
        CHARGEPAD = BLOCKS.register("chargepad", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHARGEPAD), ItemBlockChargepad::new);
        LOGISTICAL_SORTER = BLOCKS.register("logistical_sorter", BlockLogisticalSorter::new, ItemBlockLogisticalSorter::new);
        ROTARY_CONDENSENTRATOR = BLOCKS.register("rotary_condensentrator", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.ROTARY_CONDENSENTRATOR), ItemBlockMachine::new);
        CHEMICAL_OXIDIZER = BLOCKS.register("chemical_oxidizer", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHEMICAL_OXIDIZER), ItemBlockMachine::new);
        CHEMICAL_INFUSER = BLOCKS.register("chemical_infuser", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHEMICAL_INFUSER), ItemBlockMachine::new);
        CHEMICAL_INJECTION_CHAMBER = BLOCKS.register("chemical_injection_chamber", () -> new BlockFactoryMachine(MekanismBlockTypes.CHEMICAL_INJECTION_CHAMBER), ItemBlockMachine::new);
        ELECTROLYTIC_SEPARATOR = BLOCKS.register("electrolytic_separator", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.ELECTROLYTIC_SEPARATOR), ItemBlockMachine::new);
        PRECISION_SAWMILL = BLOCKS.register("precision_sawmill", () -> new BlockFactoryMachine(MekanismBlockTypes.PRECISION_SAWMILL), ItemBlockMachine::new);
        CHEMICAL_DISSOLUTION_CHAMBER = BLOCKS.register("chemical_dissolution_chamber", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHEMICAL_DISSOLUTION_CHAMBER), block -> new ItemBlockMachine((BlockTile<?, ?>)block, ISTERProvider::dissolution));
        CHEMICAL_WASHER = BLOCKS.register("chemical_washer", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHEMICAL_WASHER), ItemBlockMachine::new);
        CHEMICAL_CRYSTALLIZER = BLOCKS.register("chemical_crystallizer", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.CHEMICAL_CRYSTALLIZER), block -> new ItemBlockMachine((BlockTile<?, ?>)block, ISTERProvider::crystallizer));
        SEISMIC_VIBRATOR = BLOCKS.register("seismic_vibrator", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.SEISMIC_VIBRATOR), ItemBlockSeismicVibrator::new);
        PRESSURIZED_REACTION_CHAMBER = BLOCKS.register("pressurized_reaction_chamber", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.PRESSURIZED_REACTION_CHAMBER), ItemBlockMachine::new);
        BASIC_FLUID_TANK = MekanismBlocks.registerFluidTank(MekanismBlockTypes.BASIC_FLUID_TANK);
        ADVANCED_FLUID_TANK = MekanismBlocks.registerFluidTank(MekanismBlockTypes.ADVANCED_FLUID_TANK);
        ELITE_FLUID_TANK = MekanismBlocks.registerFluidTank(MekanismBlockTypes.ELITE_FLUID_TANK);
        ULTIMATE_FLUID_TANK = MekanismBlocks.registerFluidTank(MekanismBlockTypes.ULTIMATE_FLUID_TANK);
        CREATIVE_FLUID_TANK = MekanismBlocks.registerFluidTank(MekanismBlockTypes.CREATIVE_FLUID_TANK);
        FLUIDIC_PLENISHER = BLOCKS.register("fluidic_plenisher", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.FLUIDIC_PLENISHER), ItemBlockMachine::new);
        LASER = BLOCKS.register("laser", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.LASER), ItemBlockLaser::new);
        LASER_AMPLIFIER = BLOCKS.register("laser_amplifier", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.LASER_AMPLIFIER), ItemBlockLaserAmplifier::new);
        LASER_TRACTOR_BEAM = BLOCKS.register("laser_tractor_beam", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.LASER_TRACTOR_BEAM), ItemBlockLaserTractorBeam::new);
        QUANTUM_ENTANGLOPORTER = BLOCKS.register("quantum_entangloporter", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.QUANTUM_ENTANGLOPORTER), ItemBlockQuantumEntangloporter::new);
        SOLAR_NEUTRON_ACTIVATOR = BLOCKS.register("solar_neutron_activator", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.SOLAR_NEUTRON_ACTIVATOR), ItemBlockSolarNeutronActivator::new);
        OREDICTIONIFICATOR = BLOCKS.register("oredictionificator", () -> new BlockTile(MekanismBlockTypes.OREDICTIONIFICATOR), ItemBlockOredictionificator::new);
        RESISTIVE_HEATER = BLOCKS.register("resistive_heater", () -> new BlockTile.BlockTileModel(MekanismBlockTypes.RESISTIVE_HEATER), block -> new ItemBlockMachine((BlockTile<?, ?>)block, ISTERProvider::resistiveHeater));
        FORMULAIC_ASSEMBLICATOR = BLOCKS.register("formulaic_assemblicator", () -> new BlockTile(MekanismBlockTypes.FORMULAIC_ASSEMBLICATOR), ItemBlockMachine::new);
        FUELWOOD_HEATER = BLOCKS.register("fuelwood_heater", () -> new BlockTile(MekanismBlockTypes.FUELWOOD_HEATER), ItemBlockFuelwoodHeater::new);
        OSMIUM_ORE = MekanismBlocks.registerOre(Resource.OSMIUM);
        COPPER_ORE = MekanismBlocks.registerOre(Resource.COPPER);
        TIN_ORE = MekanismBlocks.registerOre(Resource.TIN);
        BASIC_ENERGY_CUBE = MekanismBlocks.registerEnergyCube(MekanismBlockTypes.BASIC_ENERGY_CUBE);
        ADVANCED_ENERGY_CUBE = MekanismBlocks.registerEnergyCube(MekanismBlockTypes.ADVANCED_ENERGY_CUBE);
        ELITE_ENERGY_CUBE = MekanismBlocks.registerEnergyCube(MekanismBlockTypes.ELITE_ENERGY_CUBE);
        ULTIMATE_ENERGY_CUBE = MekanismBlocks.registerEnergyCube(MekanismBlockTypes.ULTIMATE_ENERGY_CUBE);
        CREATIVE_ENERGY_CUBE = MekanismBlocks.registerEnergyCube(MekanismBlockTypes.CREATIVE_ENERGY_CUBE);
        BASIC_UNIVERSAL_CABLE = MekanismBlocks.registerUniversalCable(CableTier.BASIC);
        ADVANCED_UNIVERSAL_CABLE = MekanismBlocks.registerUniversalCable(CableTier.ADVANCED);
        ELITE_UNIVERSAL_CABLE = MekanismBlocks.registerUniversalCable(CableTier.ELITE);
        ULTIMATE_UNIVERSAL_CABLE = MekanismBlocks.registerUniversalCable(CableTier.ULTIMATE);
        BASIC_MECHANICAL_PIPE = MekanismBlocks.registerMechanicalPipe(PipeTier.BASIC);
        ADVANCED_MECHANICAL_PIPE = MekanismBlocks.registerMechanicalPipe(PipeTier.ADVANCED);
        ELITE_MECHANICAL_PIPE = MekanismBlocks.registerMechanicalPipe(PipeTier.ELITE);
        ULTIMATE_MECHANICAL_PIPE = MekanismBlocks.registerMechanicalPipe(PipeTier.ULTIMATE);
        BASIC_PRESSURIZED_TUBE = MekanismBlocks.registerPressurizedTube(TubeTier.BASIC);
        ADVANCED_PRESSURIZED_TUBE = MekanismBlocks.registerPressurizedTube(TubeTier.ADVANCED);
        ELITE_PRESSURIZED_TUBE = MekanismBlocks.registerPressurizedTube(TubeTier.ELITE);
        ULTIMATE_PRESSURIZED_TUBE = MekanismBlocks.registerPressurizedTube(TubeTier.ULTIMATE);
        BASIC_LOGISTICAL_TRANSPORTER = MekanismBlocks.registerLogisticalTransporter(TransporterTier.BASIC);
        ADVANCED_LOGISTICAL_TRANSPORTER = MekanismBlocks.registerLogisticalTransporter(TransporterTier.ADVANCED);
        ELITE_LOGISTICAL_TRANSPORTER = MekanismBlocks.registerLogisticalTransporter(TransporterTier.ELITE);
        ULTIMATE_LOGISTICAL_TRANSPORTER = MekanismBlocks.registerLogisticalTransporter(TransporterTier.ULTIMATE);
        RESTRICTIVE_TRANSPORTER = BLOCKS.register("restrictive_transporter", BlockRestrictiveTransporter::new, ItemBlockRestrictiveTransporter::new);
        DIVERSION_TRANSPORTER = BLOCKS.register("diversion_transporter", BlockDiversionTransporter::new, ItemBlockDiversionTransporter::new);
        BASIC_THERMODYNAMIC_CONDUCTOR = MekanismBlocks.registerThermodynamicConductor(ConductorTier.BASIC);
        ADVANCED_THERMODYNAMIC_CONDUCTOR = MekanismBlocks.registerThermodynamicConductor(ConductorTier.ADVANCED);
        ELITE_THERMODYNAMIC_CONDUCTOR = MekanismBlocks.registerThermodynamicConductor(ConductorTier.ELITE);
        ULTIMATE_THERMODYNAMIC_CONDUCTOR = MekanismBlocks.registerThermodynamicConductor(ConductorTier.ULTIMATE);
        BOUNDING_BLOCK = MekanismBlocks.registerBoundingBlock("bounding_block", () -> new BlockBounding(false));
        ADVANCED_BOUNDING_BLOCK = MekanismBlocks.registerBoundingBlock("advanced_bounding_block", () -> new BlockBounding(true));
        BASIC_GAS_TANK = MekanismBlocks.registerGasTank(MekanismBlockTypes.BASIC_GAS_TANK);
        ADVANCED_GAS_TANK = MekanismBlocks.registerGasTank(MekanismBlockTypes.ADVANCED_GAS_TANK);
        ELITE_GAS_TANK = MekanismBlocks.registerGasTank(MekanismBlockTypes.ELITE_GAS_TANK);
        ULTIMATE_GAS_TANK = MekanismBlocks.registerGasTank(MekanismBlockTypes.ULTIMATE_GAS_TANK);
        CREATIVE_GAS_TANK = MekanismBlocks.registerGasTank(MekanismBlockTypes.CREATIVE_GAS_TANK);
        CARDBOARD_BOX = BLOCKS.register("cardboard_box", BlockCardboardBox::new, ItemBlockCardboardBox::new);
        SALT_BLOCK = BLOCKS.register("block_salt", Block.Properties.func_200945_a((Material)Material.field_151595_p).func_200948_a(0.5f, 0.0f).func_200947_a(SoundType.field_185855_h));
    }
}

