/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.block.IHasTileEntity;
import mekanism.api.chemical.infuse.BasicInfusionTank;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.IMekanismInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class InfusionRecipeData
implements RecipeUpgradeData<InfusionRecipeData> {
    private final List<IInfusionTank> infusionTanks;

    InfusionRecipeData(ListNBT tanks) {
        int count = DataHandlerUtils.getMaxId(tanks, "Tank");
        this.infusionTanks = new ArrayList<IInfusionTank>(count);
        for (int i = 0; i < count; ++i) {
            this.infusionTanks.add(BasicInfusionTank.create(Long.MAX_VALUE, null));
        }
        DataHandlerUtils.readTanks(this.infusionTanks, tanks);
    }

    InfusionRecipeData(List<IInfusionTank> infusionTanks) {
        this.infusionTanks = infusionTanks;
    }

    @Override
    @Nullable
    public InfusionRecipeData merge(InfusionRecipeData other) {
        ArrayList<IInfusionTank> allTanks = new ArrayList<IInfusionTank>(this.infusionTanks.size() + other.infusionTanks.size());
        allTanks.addAll(this.infusionTanks);
        allTanks.addAll(other.infusionTanks);
        return new InfusionRecipeData(allTanks);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.infusionTanks.isEmpty()) {
            return true;
        }
        Item item = stack.func_77973_b();
        Optional capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY));
        final ArrayList<BasicInfusionTank> infusionTanks = new ArrayList<BasicInfusionTank>();
        if (capability.isPresent()) {
            IInfusionHandler infusionHandler = (IInfusionHandler)capability.get();
            int i = 0;
            while (i < infusionHandler.getInfusionTankCount()) {
                int tank = i++;
                infusionTanks.add(BasicInfusionTank.create(infusionHandler.getInfusionTankCapacity(tank), type -> infusionHandler.isInfusionValid(tank, new InfusionStack((IInfuseTypeProvider)type, 1L)), null));
            }
        } else if (item instanceof BlockItem) {
            TileEntity tileEntity;
            TileEntityMekanism tile = null;
            Block block = ((BlockItem)item).func_179223_d();
            if (block instanceof IHasTileEntity && (tileEntity = ((IHasTileEntity)block).getTileType().func_200968_a()) instanceof TileEntityMekanism) {
                tile = (TileEntityMekanism)tileEntity;
            }
            if (tile == null || !tile.handles(SubstanceType.INFUSION)) {
                return false;
            }
            TileEntityMekanism mekTile = tile;
            int i = 0;
            while (i < tile.getInfusionTankCount()) {
                int tank = i++;
                infusionTanks.add(BasicInfusionTank.create(tile.getInfusionTankCapacity(tank), type -> mekTile.isInfusionValid(tank, new InfusionStack((IInfuseTypeProvider)type, 1L)), null));
            }
        } else {
            return false;
        }
        if (infusionTanks.isEmpty()) {
            return true;
        }
        IMekanismInfusionHandler outputHandler = new IMekanismInfusionHandler(){

            @Override
            @Nonnull
            public List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
                return infusionTanks;
            }

            @Override
            public void onContentsChanged() {
            }
        };
        boolean hasData = false;
        for (IInfusionTank infusionTank : this.infusionTanks) {
            if (infusionTank.isEmpty()) continue;
            if (!outputHandler.insertInfusion((InfusionStack)infusionTank.getStack(), Action.EXECUTE).isEmpty()) {
                return false;
            }
            hasData = true;
        }
        if (hasData) {
            ItemDataUtils.setList(stack, "InfusionTanks", DataHandlerUtils.writeTanks(infusionTanks));
        }
        return true;
    }
}

