/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.inputs.GasStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ChemicalInfuserRecipeSerializer<T extends ChemicalInfuserRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public ChemicalInfuserRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @Nonnull
    public T read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray leftIngredients = JSONUtils.func_151202_d((JsonObject)json, (String)"leftInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"leftInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"leftInput");
        GasStackIngredient leftInput = GasStackIngredient.deserialize((JsonElement)leftIngredients);
        JsonArray rightIngredients = JSONUtils.func_151202_d((JsonObject)json, (String)"rightInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"rightInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"rightInput");
        GasStackIngredient rightInput = GasStackIngredient.deserialize((JsonElement)rightIngredients);
        GasStack output = SerializerHelper.getGasStack(json, "output");
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Chemical infuser recipe output must not be empty.");
        }
        return this.factory.create(recipeId, leftInput, rightInput, output);
    }

    public T read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            GasStackIngredient leftInput = GasStackIngredient.read(buffer);
            GasStackIngredient rightInput = GasStackIngredient.read(buffer);
            GasStack output = GasStack.readFromPacket(buffer);
            return this.factory.create(recipeId, leftInput, rightInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading chemical infuser recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull T recipe) {
        try {
            ((ChemicalInfuserRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing chemical infuser recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    public static interface IFactory<T extends ChemicalInfuserRecipe> {
        public T create(ResourceLocation var1, GasStackIngredient var2, GasStackIngredient var3, GasStack var4);
    }
}

