/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.container;

import java.util.function.Supplier;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.BasePacketHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class PacketUpdateContainer<PACKET extends PacketUpdateContainer<PACKET>> {
    protected final short windowId;
    protected final short property;

    protected PacketUpdateContainer(short windowId, short property) {
        this.windowId = windowId;
        this.property = property;
    }

    protected PacketUpdateContainer(PacketBuffer buffer) {
        this.windowId = buffer.readUnsignedByte();
        this.property = buffer.readShort();
    }

    protected void encode(PacketBuffer buffer) {
        buffer.writeByte((int)this.windowId);
        buffer.writeShort((int)this.property);
    }

    protected abstract void handle(MekanismContainer var1, PACKET var2);

    public static void handle(PacketUpdateContainer message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            PlayerEntity player = BasePacketHandler.getPlayer(context);
            if (player.field_71070_bA instanceof MekanismContainer && player.field_71070_bA.field_75152_c == message.windowId) {
                message.handle((MekanismContainer)player.field_71070_bA, message);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketUpdateContainer<?> pkt, PacketBuffer buffer) {
        pkt.encode(buffer);
    }
}

